package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;

import javax.swing.text.html.HTMLDocument.HTMLReader.IsindexAction;

//import org.apache.log4j.Level;
//import org.apache.log4j.Logger;

//zeitpunkt des feuerns = getCurrentTime
public class MyShip extends MyObject {

//	public static final Logger logger = //logger.getLogger(MyShip.class);
	
	public static final Color COLOR = Color.green; 

	public static final int RADIUS_INNER = 10*8; 
	public static final int RADIUS_OUTER = 17*8; 
	public static final float SHIPROTATIONSPEED = 4.21875f; // deg/1rot
	public static final float SHIPROTATIONSPEEDRAD = (float)(Math.PI*4.21875f/180); // rad/1rot
	public static final int MAXBULLETS = 4;
	public static final int RESTARTSIGNALINTERVALL = 200;

	
	//orientation & angle variables
	public int angleIndexByte = 100;
	private boolean orientationGenau = false;

	
	
	
	
	/**
	 * Assumes the ship to be visible.
	 * @param s
	 */
	MyShip(Ship s) 
	{
		super(s,new Vector(0,0,0f,Integer.MAX_VALUE,1f),RADIUS_INNER, RADIUS_OUTER,true);
		setDrawColor(COLOR);
	}

	//ein neues zukuenftiges schiff
	MyShip(MyShip currShip, int destTime, int destAngle) 
	{
		super(currShip);
		setPosition(estimatePosition(destTime));
		angleIndexByte = destAngle;
		setNewID();
		setDrawColor(COLOR);
	}

	//copy constructor
	MyShip(MyShip s) 
	{
		super(s);
		this.angleIndexByte = s.angleIndexByte;
		orientationGenau = s.orientationGenau;
	}
	

	/**
	 *  Sucht, ausgehend von angleIndexByte in Richtung
	 *  lastKey, die nchste mit s bereinstimmende 
	 *  Position in shots[][ORIX/Y].
	 *   
	 * @param s				gemessene Position
	 * @param lastKey		letzte gedrckte taste
	 * @param frameNumDiff	framedifferenz 
	 */
	public void setOrientation(Ship s, TastenTyp lastKey, int frameNumDiff) {
		
		int currIDX;
		boolean noDir=true;
		
		//laufrichtung
		int inc=1;
		
		if (lastKey.compareTo(TastenTyp.LINKS)==0) 
		{
			inc = 1;
			noDir=false;
		}
		if (lastKey.compareTo(TastenTyp.RECHTS)==0)
		{
			inc = -1;
			noDir=false;
		}
		
		int ox = s.getOrientation().getX();
		int oy = s.getOrientation().getY();
		
		//suche im shots-array
		for(int i=0;i<256;i++)
		{

			//alternierend in beide richtungen, falls keine vorgegeben
			if (noDir)
			{
				if (inc==-1) i--;
				inc*=-1;
				
			}
			currIDX=(angleIndexByte+i*inc+512)%256;
			
			//found orientation?
			if (shots[currIDX][ORIX]==ox &&
				shots[currIDX][ORIY]==oy)
			{
				orientationGenau=true;
				if (i>frameNumDiff)
				{
					//logger.warn("orientation out of search Range: old="+angleIndexByte+" new="+currIDX+" taste="+lastKey+" maxdiff="+frameNumDiff);
					orientationGenau=false;
				}
				//set new angle
				angleIndexByte=currIDX;
				return;
			}
					
					
		}
		
	}
	

	

	public Vector getOrientation() 
	{
		return getOrientation(TastenTyp.NICHTS);
	}
	
	public Vector getOrientation(TastenTyp next)
	{
		
		if (!orientationGenau)
			return null;
		
		if (TastenTyp.LINKS.ordinal()==next.ordinal())
		{
			
			return new Vector(
					shots[angleIndexAdd(1)][ORIX],
					shots[angleIndexAdd(1)][ORIY], 
					0f,Integer.MAX_VALUE,1f);
		}
		
		if (TastenTyp.RECHTS.ordinal()==next.ordinal())
		{
			return new Vector(
					shots[angleIndexAdd(-1)][ORIX],
					shots[angleIndexAdd(-1)][ORIY],
					0f,Integer.MAX_VALUE,1f
			);
		}

		return new Vector(
					shots[angleIndexByte][ORIX],
					shots[angleIndexByte][ORIY], 
					0f,Integer.MAX_VALUE,1f);
		
	}
	
	public final int angleIndexAdd(int i)
	{
		return (angleIndexByte+i+shots.length)%shots.length; 
	}
	
	/**
	 * Changes the angle-state of the ship according to the key pressed
	 * @param letzteTaste
	 * @param status
	 */
	public void execute(TastenTyp letzteTaste, StatusFlags status) {
		if(status.ueberpruefe(StatusFlags.SHIP_EXISTS))
			switch(letzteTaste) {
				case LINKS:
					angleIndexByte = angleIndexAdd(1);
					break;
				case RECHTS:
					angleIndexByte = angleIndexAdd(-1);
					break;
				default:
					break;
						
						
			}
	}
	public void drehLinks(KeysPacket keysPacket, StatusFlags status) {
		if (status.ueberpruefe(StatusFlags.SHIP_EXISTS)) {
			keysPacket.left(true);
		}
	}
	public void drehRechts(KeysPacket keysPacket, StatusFlags status) {
		if (status.ueberpruefe(StatusFlags.SHIP_EXISTS)) {
			keysPacket.right(true);
		}
	}
	public void hyperSpace(KeysPacket keysPacket, StatusFlags status) {
		keysPacket.hyperspace(true);
	}
	public void schiess(KeysPacket keysPacket, StatusFlags objectStatus) {
		if (objectStatus.ueberpruefe(StatusFlags.SHIP_EXISTS)) {
			keysPacket.fire(true);
		}
	}
	public void neustart(KeysPacket keysPacket, StatusFlags objectStatus) {
		keysPacket.restart(true);
	}
	public void beschleunige(KeysPacket keysPacket, StatusFlags status) {
		if (status.ueberpruefe(StatusFlags.SHIP_EXISTS)) {
			keysPacket.thrust(true);
		}
	}
	public void nichts(KeysPacket keysPacket, StatusFlags status) {
		keysPacket.clear();
	}
	
	
	


	
	/**
	 *  Diese Methode generiert ein Schuss aus dem Aktuellen schiffszustand
	 * @return 
	 */
	public MyShot shootNow()
	{
		Position startPoint = new Shot(
				getPosition().getX()+shots[angleIndexByte][PX],
				getPosition().getY()+shots[angleIndexByte][PY],
				getCurrentTime()+MyShot.SHOTCREATIONDELAY
				);
		
		
		Vector dir = new Vector(
				shots[angleIndexByte][DX],
				shots[angleIndexByte][DY],0f,Integer.MAX_VALUE,1f);
		
		MyShot s = new MyShot(startPoint,dir);
		s.setBewegungGenau(dir);
		s.setPosition(startPoint);
		
		return s;
	}
	
	/**
	 * Computes the shortest time to turn to an angle Index.
	 * 
	 * @param destination	Destionation Angle
	 * @return 				turn time <=128
	 */
	public int getTurnTime(int destinationIndex)
	{
		destinationIndex = ((destinationIndex%256)+256)%256;
		//turntime
		int diffa = angleIndexByte-destinationIndex;
		
		
		if (diffa>128) diffa = 256-diffa;
		if (diffa<-128) diffa = 256+diffa;
		if (diffa<0) diffa*=-1;
		
		return diffa;
	}
	
	/**
	 * Returns the key which would turn the current ship closer
	 * towards the destination.
	 * 
	 * @param destionation	Destination Angle
	 * @return				TastenTyp.LINKS or TastenTyp.RECHTS or, if angleIndex is reached TastenTyp.NICHTS
	 */
	public TastenTyp turnTowards(MyShip destionation)
	{
		int diff = destionation.angleIndexByte - angleIndexByte;
		
		if (diff==0) return TastenTyp.NICHTS; //ziel erreicht
		if (diff<-128) return TastenTyp.LINKS; 
		if (diff>128) return TastenTyp.RECHTS;
		if (diff<0) return TastenTyp.RECHTS;
		return TastenTyp.LINKS; //diff>0
		
	}
	
	/**
	 * Reftime is current ship
	 * @param target
	 * @return
	 */
	public FireSolution getFireSolution(MyObject target)
	{
		return getFireSolution(target,true,1d,getCurrentTime());
	}


	/**
	 * Erzeugt ausgehend von der aktuellen Schiffslage 
	 * ein FireSolutionObjekt, um das target 
	 * schnellstmoeglich zu zerstoergen.
	 * 
	 * @param target 			Das Ziel, dass es abzuschiessen gilt.
	 * @param preferHitTime		Falls true, minimiert den Treffzeitpunkt. (unterscheiden sich max um 1) 
	 * 							Falls false minimiert den Abschusszeitpunkt.
	 * @param accel				accel muss im Bereich [0..1] liegen. 
	 * 							Falls =0 wird ein zentraler Schuss ermittelt (sicherer, aber mit mehr Wartezeit) 
	 * 							Falls =1 wird ein maximal frueher Schuss ermittelt, was dessen
	 * 							Trefferwarscheinlichkeit verringert aber den Abschusszeitpunkt vorverlegt.
	 * @param earliestShotTime	definiert, den fruehestmoeglichen schusszeitpunkt
	 * @return 					FireSolution fuer den Abschuss des Ziels
	 * 							Gibt nur gltige (.isValid(t)==true) firesolutions zurck, sonst null.
	 */
	public FireSolution getFireSolution(MyObject target, boolean preferHitTime, double accel, int earliestShotTime)
	{
		
		//TODO: target killist!=null && hitbefore 
		//    -> if computed hitprobability *= sum of all hitprobs
		
		if (target==null)
		{
			//logger.debug("Error in FS-computation: Target null!");
			return null;
		}
		//reference time
		int refTime = (int)Math.max(earliestShotTime,getCurrentTime());

		//TODO:min hitzeit! - wo is die? - bei abgeschossene
		
		//target lifespan
		int maxAbsHitTime = (int)Math.max(
				target.getDeathTime(),
				refTime);
		
		if (refTime==maxAbsHitTime)
		{
			//logger.debug("ommit FS-computation, dead target: maxAbsHitTime="+maxAbsHitTime+", refTime="+refTime+", ct="+getCurrentTime()+", deathtime="+target.getDeathTime());
			return null;
		}
		
		//target creation
		int minAbsHitTime = (int)Math.max(
				target.getCreationTime(),
				refTime);

//		//logger.debug("max("+target.getDeathTime()+","+refTime+")="+maxAbsHitTime);
		//ship is asumed to to live forever
		
		Position tp = target.estimatePosition(refTime);
		Position sp = estimatePosition(refTime);
		Vector tbew = target.getBewegung();
		Vector sbew = getBewegung();

		if (tp==null || sp==null || tbew==null || sbew==null)
		{
			//logger.debug("Error in FS-computation: could not estimate position: target="+tp+" this="+sp+" "+tbew+"  "+sbew);
			return null;
		}
		
			
		int tnx = tbew.getX();
		int tny = tbew.getY();
	
		int dposx = tp.getX()-sp.getX();
		int dposy = tp.getY()-sp.getY();

		//hittest vars
		int maxDist = target.getRadius_inner()+MyShot.RADIUS;

		
		//solution storage
		double bestTwait=Double.MAX_VALUE;
		double bestTT=Double.MAX_VALUE;
		double bestTB=Double.MAX_VALUE;
		int bestIDX=-1;
		int drehzeitBest=Integer.MAX_VALUE;
		

		//seach valid solution linear
		int relShotTime;
		int relShotTimeBest = Integer.MAX_VALUE;
		int drehzeit;

		
		Position targetpos,shotpos;
		int relHitTime,idx,absHitTime;
		int absHitTimeBest = Integer.MAX_VALUE;
		int relHitTimeBest = Integer.MAX_VALUE;
		double est; //exact shottime
		double deltaTtargetBest = Double.MIN_VALUE;
		
		MyShip bestShip=null;
		MyShip currShip;
		int absShotTime;
		


		for(int i=-43;i<43;i++)
		{

			//*****compute shottime
			idx = computeHitTime(i+angleIndexByte,tnx,tny,dposx,dposy);
			computeDeltaT(shots[idx][DX], shots[idx][DY], tnx, tny, target.getRadius_inner());
			drehzeit = getTurnTime(idx)+MyShot.SHOTCREATIONDELAY;

			//exact shot time (relative)
			est = tt-tb+drehzeit;
			//decrease (improve) est with deltaTtarget
			relShotTime = est >= drehzeit+1 ?
					(int)Math.max(drehzeit+1,Math.ceil(est-deltaTtarget*accel))
					:(int)Math.min(drehzeit+1,Math.floor(est+deltaTtarget*accel));
			absShotTime = relShotTime+refTime;

			//shot is too early
			if (absShotTime<earliestShotTime) continue; 
			
			//shot cannot be executed
			if (absShotTime-getCurrentTime()<drehzeit) continue;
			
			
			//*****compute hittime
			targetpos = target.estimatePosition(absShotTime);
			currShip = new MyShip(this,absShotTime,idx);
			shotpos = currShip.shootNow().estimatePosition(absShotTime);

			if (targetpos==null || shotpos==null)
			{
				//logger.warn("shit "+absShotTime+" "+targetpos+shotpos);
				continue;
			}

			relHitTime = hitTest(
					shots[idx][DX]-tnx,
					shots[idx][DY]-tny,
					shotpos.getX()-targetpos.getX(),
					shotpos.getY()-targetpos.getY(),
					0,
					maxDist);

			absHitTime = relHitTime + absShotTime;

			
			if (
				target.isAliveAndCertainAt(absHitTime) &&
				shotpos.isAliveAt(absHitTime) 	
//				relHitTime>1 &&					//treffzeitpunkt in der zukunft
//				relHitTime<MyShot.BULLETLIFETIME &&//shot muss ankommen
//				relHitTime!=Integer.MIN_VALUE &&  //genrell wird das ziel getroffen (sollte immer! der fall sein!
//				absHitTime<maxAbsHitTime&&    //muss vor target-sterbezeitpunkt liegen
//				absHitTime>minAbsHitTime   //muss hinter erzeugungszeitpunkt liegen
				)
			{

				if ((!preferHitTime && relShotTime<relShotTimeBest) ||
						(preferHitTime && absHitTime<absHitTimeBest))
				{
					absHitTimeBest = absHitTime;
					relHitTimeBest = relHitTime;
					relShotTimeBest = relShotTime;
					bestTT = tt;
					bestIDX= idx;
					bestTB = tb;
					drehzeitBest = drehzeit;
					deltaTtargetBest = deltaTtarget;
					bestShip = currShip;
				}

//				//logger.debug("["+idx+"] ShotTime(rel="+relShotTime+"{exact="+((int)Math.round(est))+"}, abs="+absShotTime+", min1="+earliestShotTime+", min2="+(getCurrentTime()+drehzeit)+")  hitTime(rel="+relHitTime+", abs="+absHitTime+", max="+maxAbsHitTime+") tt="+((int)Math.round(tt))+",  tb="+((int)Math.round(tb))+"),  tdreh="+drehzeit+"("+this.angleIndexByte+", dx="+shots[idx][DX]+",dy="+shots[idx][DY]+")   deltaTbullet="+deltaTbullet+" deltaTtargt="+deltaTtarget
//				);

			}
			else
			{
//						//logger.debug(" "+idx+"  tshot="+relShotTime+ "("+((int)Math.round(est))+")  thit="+t+"(tot="+totHitTime+",  tt="+((int)Math.round(tt))+",  tb="+((int)Math.round(tb))+"),  tdreh="+drehzeit+"("+this.angleIndexByte+", dx="+shots[idx][DX]+",dy="+shots[idx][DY]+")   deltaTbullet="+deltaTbullet+" deltaTtargt="+deltaTtarget
//						+(relShotTime>=drehzeit+1)+(t!=Integer.MIN_VALUE)+(t>0)+(t<MyShot.BULLETLIFETIME)
//						);
			}

		}	
		
		
		////logger.debug("Best IDX: ["+bestIDX+"]");
	
		
		if (bestIDX==-1) //eigentlich idx<0
		{
			//logger.debug("Error: No valid firesolution found(ct="+getCurrentTime()
//					+"): earliestShotTime="+earliestShotTime
//					+", maxAbsHitTime="+maxAbsHitTime
//					+", minAbsHitTime="+minAbsHitTime
//					+", target:"+target
//			);
//			if (maxAbsHitTime<= minAbsHitTime)  //kommt vor, wenn auf tot beballert wird
//			{
//				target.getDeathTime();
//			}

			return null;
		} //TODO: bug: earliestShotTime=72maxAbsHitTime=72
	
		
		FireSolution fs = new FireSolution(bestShip,target); 

		if (!fs.canBeExecuted(this))
		{
			//logger.warn("Error: fs not executable(ct="+getCurrentTime()
//					+"): earliestShotTime="+earliestShotTime
//					+", maxAbsHitTime="+maxAbsHitTime
//					+", minAbsHitTime="+minAbsHitTime
//					+", target:"+target
//			);
			fs.canBeExecuted(this);
			fs = new FireSolution(bestShip,target); 
			return null;
		}
		
		////logger.debug("foundFS: dhit:"+(bestTT-(fs.getHitTimeInner()-refTime))+" wait"+bestTwait+"   fs:"+fs);

//		if (//logger.isDebugEnabled())
//		{
//			if (fs.optTargets==null) fs.optTargets = new LinkedList<Position>();
//	
//			//debug output
//			Position optTrg;
//			fs.optTargets.clear();
//			
//			
//	
//			optTrg = target.estimatePosition((int)Math.round(refTime+bestTT+deltaTtargetBest),false);
//			optTrg.setSize_inner(target.getRadius_inner());
//			optTrg.setDrawColor(Color.cyan);
//			fs.optTargets.add(optTrg);
//	
//			optTrg = target.estimatePosition((int)Math.round(refTime+bestTT),false);
//			optTrg.setSize_inner(target.getRadius_inner());
//			optTrg.setDrawColor(Color.green);
//			fs.optTargets.add(optTrg);
//			
//			
//			optTrg = target.estimatePosition((int)Math.round(refTime+bestTT-deltaTtargetBest),false);
//			optTrg.setSize_inner(target.getRadius_inner());
//			optTrg.setDrawColor(Color.cyan);
//			fs.optTargets.add(optTrg);
//		}
		
		return fs;
		
	}
	
	
	
	

	//communication variables
	//flugzeit bullet bis treffpunkt (incl. drehung) - variabler startpunkt, vz vom winkel abh.
	private static double tb;
	//basis flugzeit asteroid bis treffpunkt (relativ zur referenzzeit)
	private static double tt;
	
	
	
	/**
	 * Computes relative intersection time, (also considering turntime).
	 * 
	 * @param idx		ship angle index
	 * @param tnx		target movement y
	 * @param tny		target movement y	
	 * @param dposx		postion difference targetx - shipx
	 * @param dposy		postion difference targety - shipy 
	 * @return
	 */
	private int computeHitTime(int idx, int tnx, int tny, int dposx, int dposy)
	{
		idx = ((idx%len)+256)%len;
		int bnx = shots[idx][DX];
		int bny = shots[idx][DY];
		int drehzeit = getTurnTime(idx)+MyShot.SHOTCREATIONDELAY;
		
//		int e = dposx+drehzeit*bnx-shots[idx][PX];
//		int f = dposy+drehzeit*bny-shots[idx][PY];
//		double detinv=1d/(tnx*bny-bnx*tny);
//		//flugzeit bullet bis treffpunkt (incl. drehung) - variabler startpunkt, vz vom winkel abh.
//		tb = detinv*(tnx*f-tny*e);
//		//basis flugzeit asteroid bis treffpunkt (relativ zur referenzzeit)
//		tt = detinv*(bnx*f-bny*e);

		int e;
		int f;
		double detinv;
		double ttt;
		double tbt;
		
		tb=Double.MAX_VALUE;
		tt=Double.MAX_VALUE;
		
		//search modulo space
		for (int i=-1;i<2;i++)
			for (int j=-1;j<2;j++)
			{
				e = dposx+drehzeit*bnx-shots[idx][PX]+Position.screenSizeX*i;
				f = dposy+drehzeit*bny-shots[idx][PY]+Position.screenSizeY*j;
				detinv =1d/(tnx*bny-bnx*tny);
				//flugzeit bullet bis treffpunkt (incl. drehung) - variabler startpunkt, vz vom winkel abh.
				tbt = detinv*(tnx*f-tny*e);
				//basis flugzeit asteroid bis treffpunkt (relativ zur referenzzeit)
				ttt = detinv*(bnx*f-bny*e);
				
				if (ttt<tt && ttt>0 && tbt>0)
				{
					tt=ttt;
					tb=tbt;
				}
				
			}

		
		
		return idx;
	}
	
	
	//communication variables
	private static double deltaTbullet;
	private static double deltaTtarget;
	
	/**
	 * Computes the time variance for not hitting the target exactly.
	 * 
	 * @param nbx 	x-component of the velocity vector of the bullet 
	 * @param nby	y-component of the velocity vector of the bullet
	 * @param ntx 	x-component of the velocity vector of the target
	 * @param nty	y-component of the velocity vector of the target
	 * @param tr	target radius
	 * 
	 * @return 	sets the communication variables deltaTbullet and deltaTtarget
	 */
	private void computeDeltaT(int nbx,int nby, int ntx,int nty, int tr)
	{
		tr=tr+MyShot.RADIUS; // add the radius of the bullet to target radius
		double trsq= tr*tr; //sqared it

		//length nt
		int ltsq = ntx*ntx+nty*nty;
		//length nb
		int lbsq = nbx*nbx+nby*nby;
		
		//scalar product squared
		double spsq = nbx*ntx+nby*nty;
		spsq*=spsq;
		
		//sinus squared beween nb and nt 
		double sinsq = 1- spsq/(lbsq*ltsq); //correct
		//special case
		if (sinsq==0)
		{
			deltaTbullet = Double.MAX_VALUE;
			deltaTtarget = Double.MAX_VALUE;
			return;
		}
		
		//length target squared
		double dltsq = trsq/sinsq;
		//length bullet squared
		double dlbsq = dltsq-trsq;

				
		deltaTbullet = Math.sqrt(dlbsq/lbsq);
		deltaTtarget = Math.sqrt(dltsq/ltsq);
		
		return;
		
	}
	
	
	@Override
	public String toString()
	{
		return super.toString()+" angle="+angleIndexByte+" angleGenau:"+orientationGenau;		
	}
	
	
	@Override
	public void draw(Graphics2D g)
	{
		super.draw(g);
		
		double angle = Math.atan2(shots[angleIndexByte][ORIY],shots[angleIndexByte][ORIX]);
		int x1 = (int)( RADIUS_INNER/8 * Math.cos(angle));
		int y1 = (int)( RADIUS_INNER/8 * Math.sin(angle));
		int x2 = (int)( RADIUS_INNER/8 * Math.cos(angle+Math.PI*0.8));
		int y2 = (int)( RADIUS_INNER/8 * Math.sin(angle+Math.PI*0.8));
		int x3 = (int)( RADIUS_INNER/8 * Math.cos(angle-Math.PI*0.8));
		int y3 = (int)( RADIUS_INNER/8 * Math.sin(angle-Math.PI*0.8));
		//triangle
		g.drawLine(getPosition().getXforDrawing()+x1, getPosition().getYforDrawing()-y1, getPosition().getXforDrawing()+x2, getPosition().getYforDrawing()-y2);
		g.drawLine(getPosition().getXforDrawing()+x3, getPosition().getYforDrawing()-y3, getPosition().getXforDrawing()+x2, getPosition().getYforDrawing()-y2);
		g.drawLine(getPosition().getXforDrawing()+x1, getPosition().getYforDrawing()-y1, getPosition().getXforDrawing()+x3, getPosition().getYforDrawing()-y3);
		//string
		g.drawString(""+angleIndexByte, getPosition().getXforDrawing()+getRadiusForDrawing(), getPosition().getYforDrawing()-getRadiusForDrawing());
		
		
	}
	
	
	//drehung nach links erhoeht den array-index um 1
	public static final int DX = 0; // x-bewegung / frame
	public static final int DY = 1; // y-bewegung / frame
	public static final int PX = 2; //erster entstehungsort-x relativ zur schiffsposition bei t=abschusszeit+MyShot.SHOTCREATIONDELAY
	public static final int PY = 3; //erster entstehungsort-y relativ zur schiffsposition bei t=abschusszeit+MyShot.SHOTCREATIONDELAY
	public static final int ORIX = 4; // x-orientierung des Raumschiffs
	public static final int ORIY = 5; // y-orientierung des Raumschiffs
	public static final int[][] shots = new int[][]{
		{63,0,152,0,1536,0},
		{63,4,152,8,1536,0},
		{63,9,152,16,1528,152},
		{62,14,152,32,1504,296},
		{61,18,152,40,1472,440},
		{59,23,144,56,1472,440},
		{57,27,136,64,1416,584},
		{55,31,136,72,1360,720},
		{53,35,128,80,1280,856},
		{50,39,120,96,1280,856},
		{47,42,112,104,1192,976},
		{44,46,104,112,1088,1088},
		{40,49,96,120,976,1192},
		{36,52,88,128,976,1192},
		{32,54,80,128,856,1280},
		{28,56,64,136,720,1360},
		{24,58,56,144,584,1416},
		{20,60,48,144,584,1416},
		{15,61,32,152,440,1472},
		{11,62,24,152,296,1504},
		{6,63,8,152,152,1528},
		{1,63,0,152,152,1528},
		{-3,63,-8,152,-152,1528},
		{-8,63,-24,152,-296,1504},
		{-13,62,-40,152,-296,1504},
		{-17,61,-48,152,-440,1472},
		{-22,60,-56,144,-584,1416},
		{-26,58,-72,144,-720,1360},
		{-30,56,-80,136,-720,1360},
		{-34,53,-88,128,-856,1280},
		{-38,51,-96,120,-976,1192},
		{-42,48,-112,120,-1088,1088},
		{-45,45,-120,112,-1088,1088},
		{-48,41,-120,96,-1192,976},
		{-51,38,-128,88,-1280,856},
		{-54,34,-136,80,-1360,720},
		{-56,30,-144,72,-1360,720},
		{-58,25,-152,56,-1416,584},
		{-60,21,-152,48,-1472,440},
		{-61,17,-160,40,-1504,296},
		{-63,12,-160,24,-1504,296},
		{-63,8,-160,16,-1528,152},
		{-64,3,-160,0,-1536,0},
		{-64,-2,-160,-8,-1536,0},
		{-63,-6,-160,-16,-1528,-152},
		{-63,-11,-160,-32,-1528,-152},
		{-62,-16,-160,-40,-1504,-296},
		{-61,-20,-160,-56,-1472,-440},
		{-59,-25,-152,-64,-1416,-584},
		{-57,-29,-144,-80,-1416,-584},
		{-55,-33,-144,-88,-1360,-720},
		{-52,-37,-136,-96,-1280,-856},
		{-49,-41,-128,-104,-1192,-976},
		{-46,-44,-120,-112,-1192,-976},
		{-43,-47,-112,-120,-1088,-1088},
		{-39,-50,-104,-128,-976,-1192},
		{-36,-53,-96,-136,-856,-1280},
		{-32,-56,-80,-144,-856,-1280},
		{-27,-58,-72,-152,-720,-1360},
		{-23,-59,-64,-152,-584,-1416},
		{-19,-61,-48,-160,-440,-1472},
		{-14,-62,-40,-160,-440,-1472},
		{-10,-63,-32,-160,-296,-1504},
		{-5,-64,-16,-160,-152,-1528},
		{0,-64,0,-160,0,-1536},
		{4,-64,8,-160,152,-1528},
		{9,-63,16,-160,296,-1504},
		{14,-62,32,-160,440,-1472},
		{18,-61,40,-160,440,-1472},
		{23,-59,56,-152,584,-1416},
		{27,-58,64,-152,720,-1360},
		{31,-56,72,-144,856,-1280},
		{35,-53,80,-136,856,-1280},
		{39,-50,96,-128,976,-1192},
		{42,-47,104,-120,1088,-1088},
		{46,-44,112,-112,1192,-976},
		{49,-41,120,-104,1192,-976},
		{52,-37,128,-96,1280,-856},
		{54,-33,128,-88,1360,-720},
		{56,-29,136,-80,1416,-584},
		{58,-25,144,-64,1416,-584},
		{60,-20,144,-56,1472,-440},
		{61,-16,152,-40,1504,-296},
		{62,-11,152,-32,1528,-152},
		{63,-6,152,-16,1528,-152},
		{63,-2,152,-8,1536,0},
		{63,3,152,0,1536,0},
		{63,8,152,16,1528,152},
		{62,12,152,24,1504,296},
		{61,17,152,40,1504,296},
		{60,21,144,48,1472,440},
		{58,25,144,56,1416,584},
		{56,30,136,72,1360,720},
		{53,34,128,80,1360,720},
		{51,38,120,88,1280,856},
		{48,41,120,96,1192,976},
		{45,45,112,112,1088,1088},
		{41,48,96,120,1088,1088},
		{38,51,88,120,976,1192},
		{34,53,80,128,856,1280},
		{30,56,72,136,720,1360},
		{25,58,56,144,720,1360},
		{21,60,48,144,584,1416},
		{17,61,40,152,440,1472},
		{12,62,24,152,296,1504},
		{8,63,16,152,296,1504},
		{3,63,0,152,152,1528},
		{-2,63,-8,152,-152,1528},
		{-6,63,-16,152,-152,1528},
		{-11,62,-32,152,-296,1504},
		{-16,61,-40,152,-440,1472},
		{-20,60,-56,144,-584,1416},
		{-25,58,-64,144,-584,1416},
		{-29,56,-80,136,-720,1360},
		{-33,54,-88,128,-856,1280},
		{-37,52,-96,128,-976,1192},
		{-41,49,-104,120,-976,1192},
		{-44,46,-112,112,-1088,1088},
		{-47,42,-120,104,-1192,976},
		{-50,39,-128,96,-1280,856},
		{-53,35,-136,80,-1280,856},
		{-56,31,-144,72,-1360,720},
		{-58,27,-152,64,-1416,584},
		{-59,23,-152,56,-1472,440},
		{-61,18,-160,40,-1472,440},
		{-62,14,-160,32,-1504,296},
		{-63,9,-160,16,-1528,152},
		{-64,4,-160,8,-1536,0},
		{-64,0,-160,0,-1536,0},
		{-64,-5,-160,-16,-1536,0},
		{-63,-10,-160,-32,-1528,-152},
		{-62,-14,-160,-40,-1504,-296},
		{-61,-19,-160,-48,-1472,-440},
		{-59,-23,-152,-64,-1472,-440},
		{-58,-27,-152,-72,-1416,-584},
		{-56,-32,-144,-80,-1360,-720},
		{-53,-36,-136,-96,-1280,-856},
		{-50,-39,-128,-104,-1280,-856},
		{-47,-43,-120,-112,-1192,-976},
		{-44,-46,-112,-120,-1088,-1088},
		{-41,-49,-104,-128,-976,-1192},
		{-37,-52,-96,-136,-976,-1192},
		{-33,-55,-88,-144,-856,-1280},
		{-29,-57,-80,-144,-720,-1360},
		{-25,-59,-64,-152,-584,-1416},
		{-20,-61,-56,-160,-584,-1416},
		{-16,-62,-40,-160,-440,-1472},
		{-11,-63,-32,-160,-296,-1504},
		{-6,-63,-16,-160,-152,-1528},
		{-2,-64,-8,-160,-152,-1528},
		{3,-64,0,-160,152,-1528},
		{8,-63,16,-160,296,-1504},
		{12,-63,24,-160,296,-1504},
		{17,-61,40,-160,440,-1472},
		{21,-60,48,-152,584,-1416},
		{25,-58,56,-152,720,-1360},
		{30,-56,72,-144,720,-1360},
		{34,-54,80,-136,856,-1280},
		{38,-51,88,-128,976,-1192},
		{41,-48,96,-120,1088,-1088},
		{45,-45,112,-120,1088,-1088},
		{48,-42,120,-112,1192,-976},
		{51,-38,120,-96,1280,-856},
		{53,-34,128,-88,1360,-720},
		{56,-30,136,-80,1360,-720},
		{58,-26,144,-72,1416,-584},
		{60,-22,144,-56,1472,-440},
		{61,-17,152,-48,1504,-296},
		{62,-13,152,-40,1504,-296},
		{63,-8,152,-24,1528,-152},
		{63,-3,152,-8,1536,0},
		{63,1,152,0,1536,0},
		{63,6,152,8,1528,152},
		{62,11,152,24,1528,152},
		{61,15,152,32,1504,296},
		{60,20,144,48,1472,440},
		{58,24,144,56,1416,584},
		{56,28,136,64,1416,584},
		{54,32,128,80,1360,720},
		{52,36,128,88,1280,856},
		{49,40,120,96,1192,976},
		{46,44,112,104,1192,976},
		{42,47,104,112,1088,1088},
		{39,50,96,120,976,1192},
		{35,53,80,128,856,1280},
		{31,55,72,136,856,1280},
		{27,57,64,136,720,1360},
		{23,59,56,144,584,1416},
		{18,61,40,152,440,1472},
		{14,62,32,152,440,1472},
		{9,63,16,152,296,1504},
		{4,63,8,152,152,1528},
		{0,63,0,152,0,1536},
		{-5,63,-16,152,-152,1528},
		{-10,63,-32,152,-296,1504},
		{-14,62,-40,152,-440,1472},
		{-19,61,-48,152,-440,1472},
		{-23,59,-64,144,-584,1416},
		{-27,57,-72,136,-720,1360},
		{-32,55,-80,136,-856,1280},
		{-36,53,-96,128,-856,1280},
		{-39,50,-104,120,-976,1192},
		{-43,47,-112,112,-1088,1088},
		{-46,44,-120,104,-1192,976},
		{-49,40,-128,96,-1192,976},
		{-52,36,-136,88,-1280,856},
		{-55,32,-144,80,-1360,720},
		{-57,28,-144,64,-1416,584},
		{-59,24,-152,56,-1416,584},
		{-61,20,-160,48,-1472,440},
		{-62,15,-160,32,-1504,296},
		{-63,11,-160,24,-1528,152},
		{-63,6,-160,8,-1528,152},
		{-64,1,-160,0,-1536,0},
		{-64,-3,-160,-8,-1536,0},
		{-63,-8,-160,-24,-1528,-152},
		{-63,-13,-160,-40,-1504,-296},
		{-61,-17,-160,-48,-1504,-296},
		{-60,-22,-152,-56,-1472,-440},
		{-58,-26,-152,-72,-1416,-584},
		{-56,-30,-144,-80,-1360,-720},
		{-54,-34,-136,-88,-1360,-720},
		{-51,-38,-128,-96,-1280,-856},
		{-48,-42,-120,-112,-1192,-976},
		{-45,-45,-120,-120,-1088,-1088},
		{-42,-48,-112,-120,-1088,-1088},
		{-38,-51,-96,-128,-976,-1192},
		{-34,-54,-88,-136,-856,-1280},
		{-30,-56,-80,-144,-720,-1360},
		{-26,-58,-72,-152,-720,-1360},
		{-22,-60,-56,-152,-584,-1416},
		{-17,-61,-48,-160,-440,-1472},
		{-13,-63,-40,-160,-296,-1504},
		{-8,-63,-24,-160,-296,-1504},
		{-3,-64,-8,-160,-152,-1528},
		{1,-64,0,-160,152,-1528},
		{6,-63,8,-160,152,-1528},
		{11,-63,24,-160,296,-1504},
		{15,-62,32,-160,440,-1472},
		{20,-61,48,-160,584,-1416},
		{24,-59,56,-152,584,-1416},
		{28,-57,64,-144,720,-1360},
		{32,-55,80,-144,856,-1280},
		{36,-52,88,-136,976,-1192},
		{40,-49,96,-128,976,-1192},
		{44,-46,104,-120,1088,-1088},
		{47,-43,112,-112,1192,-976},
		{50,-39,120,-104,1280,-856},
		{53,-36,128,-96,1280,-856},
		{55,-32,136,-80,1360,-720},
		{57,-27,136,-72,1416,-584},
		{59,-23,144,-64,1472,-440},
		{61,-19,152,-48,1472,-440},
		{62,-14,152,-40,1504,-296},
		{63,-10,152,-32,1528,-152},
		{63,-5,152,-16,1536,0}
	};
	public static final int len = shots.length;


	/**
	 * Converts the ship's angle Index Byte into an angle.
	 * 
	 * @param angleIndex	angleIndexByte of the Ship
	 * @param normalize		if true the result will be in range 0..2PI otherwise -PI..PI
	 * @return 				Angle in rad
	 */
	public static double getAngle(int angleIndex,boolean normalize)
	{
		double ang = Math.atan2(
				shots[angleIndex][DY],
				shots[angleIndex][DX]);
		
		return (ang<0 && normalize ? 2*Math.PI+ang : ang);
		
	}
	
	/**
	 * Converts an angle to an index (within one rotation). Returns an increment.
	 *  
	 * @param startIndex		0..255
	 * @param destinationAngle	-pi..pi (atan2)
	 * @return	startIndex + returned value will be close (not closest) to destination-AngleIndexByte
	 * 			return values: range -43..43
	 */
	public static int angle2Index(int startIndex, double destinationAngle)
	{		
		double curr=getAngle(startIndex,false);
		double d= destinationAngle-curr;
		if (d> Math.PI) d=-2*Math.PI+d;
		if (d<-Math.PI) d= 2*Math.PI+d;

//		System.out.println("got angcurr="+curr+" angdest="+destinationAngle+"  idx="+startIndex+" return: idx="+ret+" shots[idx+ret]="+Math.atan2(shots[ret+startIndex][DY],shots[ret+startIndex][DX])+" d="+d+"  d/w="+(d/MyShip.SHIPROTATIONSPEEDRAD));
		return (int)Math.round(d/MyShip.SHIPROTATIONSPEEDRAD);
		
	}

	public int getAngleIndexByte() {
		return angleIndexByte;
	}

	public void setAngleIndexByte(int angleIndexByte) {
		this.angleIndexByte = angleIndexByte;
	}
	

}
