package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.List;
import java.util.ArrayList;
import java.util.LinkedList;
//import org.apache.log4j.Level;
//import org.apache.log4j.Logger;

///TODO: es fehlt time changed listener -> update
public class MyObject {
	
//	public static final Logger logger = Logger.getLogger(MyObject.class);
	public static final int ARROWTIPSIZE = 5; //in pixels
	public static final int ARROWSIZEMULTIPLIER = 33;
	public static final int MAXINTERNDISTGENAU = 12; //abweichung pro frame 12 > sqrt(8²+8²) (maximale Abweichung 1 Pixel je Richtung)
	public static final int MAXINTERNDISTUNGENAU = 100; //abweichung pro frame
	public static final int BEWEGUNGSUEBERPRUEFUNGEN = 10;
	
	private static int counter = 0; 
	
	//*****

	private int id;
	
	private int radius_inner; // reference radius (garantiert im objekt drin)
	private int radius_outer; // savety radius (garantiert ausserhalb des objectes)

	//determines if the object is created from screen or not
	private boolean isVisible;
	
	//zeit
	//startzeit, endzeit b alles in position
	//ort - uncertainty - decrease faktor+init

	//position, zeit,type, ast-type
	private Position durchSchnittsPosition;
	
	private ArrayList<Position> gespeichertePositionen;
	//bewegung
	private Vector durchschnittsBewegung;
	private int anzUeberpruefungenBewegung;
	private boolean internBewegungGenau;
	
	//contains all executed firesolutions on this target
//	private LinkedList<FireSolution> killList;   
	
	//drawing data
	private String drawStringWithObject; 
	private Color drawColor;


	
	
	public int getId() {
		return id;
	}
	
	public Position.TYPE getType() {
		return durchSchnittsPosition.getType();
	}

	public Position.AsteroidType getAsteroidType() {
		return durchSchnittsPosition.getAsteroidType();
	}
	
	public int getCurrentTime(){
		return (durchSchnittsPosition==null)
		?Integer.MIN_VALUE
		:durchSchnittsPosition.getZeitpunkt();}
	
	
	public Vector getBewegung() {
		return durchschnittsBewegung;
	}
	/*
	 * gibt true zurueck, wenn die Bewegung genau bestimmt ist
	 */
	public boolean bewegungIstGenau() {
		return internBewegungGenau;
	}
	public Position getPosition() {
		return durchSchnittsPosition;
	}

//	/**
//	 * Changes modulo space - and returns the Position of that space
//	 * 
//	 * @param moduloSteps	number of changes
//	 * @return
//	 */
//	public Position getPosition(int moduloSteps) {
//		
//		if (moduloSteps==0) return new Position(durchSchnittsPosition);
//
//		double tx,ty;
//		
//		int dx = getBewegung().getX();
//		int dy = getBewegung().getY();
//		
//		int BorderX = dx<0?0:Position.screenSizeX;
//		int BorderY = dy<0?Position.offsetY:Position.screenSizeY+Position.offsetY;
//
//		int cposx = getPosition().getX();
//		int cposy = getPosition().getY();
//		int ctime = getCurrentTime();
//		
//		tx = ((double)(BorderX-cposx))/dx;
//		ty = ((double)(BorderY-cposy))/dy;
//		
//		tx = (dx<0)? Math.floor(tx):Math.ceil(tx);
//		ty = (dy<0)? Math.floor(ty):Math.ceil(ty);
//
//		int t=Integer.MIN_VALUE;
//		
//		
//		
//		if (moduloSteps==1) t = tx<ty?(int)tx:(int)ty;
//		if (moduloSteps==2) t = tx<ty?(int)ty:(int)tx;
//		if (moduloSteps>2) return null; //not implemented
//
//		if (dx==0 && dy==0) return new Position(durchSchnittsPosition);
//
//		if (dx==0 && moduloSteps==2)
//		{
//			t = (int)(ty + Math.ceil(Position.screenSizeY/dy));
//		}
//		
//		if (dy==0 && moduloSteps==2)
//		{
//			t = (int)(tx + Math.ceil(Position.screenSizeX/dx));
//		}
//		
//		if (t>10000)
//		{
//			logger.debug("shit");
//		}
//		
//		return new Position(
//						(cposx + t*dx),
//						(cposy + t*dy),
//						(t + ctime));
//
//	}
//	

	
	
	public void setPosition(Position newPos) {
		
//		if (newPos.getZeitpunkt()<World.getTick())
//		{
//			logger.debug("shit");, kommt vor, wenn sich alte asteroiden (fr kinder) klonen
//			
//		}
	
		//Sonderbehandlung fuer das Saucer
		if (newPos.getType() == Position.TYPE.SAUCER) {
			
			gespeichertePositionen.add(newPos);
			
			if (gespeichertePositionen.size() > 1) 
			{
				if (!internBewegungGenau) {
					gibInternBewegung();
				}
				Position est = estimatePosition(newPos.getZeitpunkt());
				if (est!=null &&
						est.getX() == newPos.getX()  && est.getY() == newPos.getY()) {
					durchSchnittsPosition = newPos;
					
				}
				else {

					
					gespeichertePositionen.clear();
					gespeichertePositionen.add(durchSchnittsPosition);
					gespeichertePositionen.add(newPos);
					internBewegungGenau = false;
					gibInternBewegung();
					MySaucer a = (MySaucer)this;
					a.setRichtungsaenderung(durchSchnittsPosition.getZeitpunkt());
//					logger.info("T:"+a.letzteRichtungsAenderung() + "Saucer hat Richtung geändert zu." + getBewegung().toString());
				}
			}
			durchSchnittsPosition = newPos;
			return;
		}
		//TODO: Ueberpruef spaeter noch ein paarmal ob die Bewegung wirklich korrekt ist.
		
		
		if (!internBewegungGenau)	{
			
			gespeichertePositionen.add(newPos);
			
			if (gespeichertePositionen.size() > 1) { 
				gibInternBewegung();
			}
		}

		else {
			if (anzUeberpruefungenBewegung < BEWEGUNGSUEBERPRUEFUNGEN 
					&& newPos.getType() == Position.TYPE.ASTEROID) {
				gespeichertePositionen.add(newPos);
				ueberpruefeBewegung();
			}
		}
		
		durchSchnittsPosition = newPos;
			
	
	}
	/*
	 * gibt true zurueck wenn zwei Positionen auf dem gleichen Pixel dargestellt werden
	 */
	public boolean wirdDargestelltAufGleichemPixel(Position p0, Position p1) {
		return (p0.getX()/8 == p1.getX()/8 && p0.getY()/8 == p1.getY()/8);
	}


	
	
	public void setBewegungGenau(Vector bewegung)
	{
		anzUeberpruefungenBewegung=BEWEGUNGSUEBERPRUEFUNGEN;
		internBewegungGenau = true;
		durchschnittsBewegung = new Vector(bewegung);
	}
	
	public Position estimatePosition(int aktTick) {
		return durchSchnittsPosition.estimatePosition(
				durchschnittsBewegung, 
				aktTick,
				true);
	}
	
	public Position estimatePosition(int aktTick, boolean checkModulo) {
		return durchSchnittsPosition.estimatePosition(
				durchschnittsBewegung, 
				aktTick,
				checkModulo);
	}
	
	public Position estimatePositionAliveAndCertain(int aktTick) {
		Position p = durchSchnittsPosition.estimatePosition(
				durchschnittsBewegung, 
				aktTick,
				true);
		return (p==null || !p.isAliveAt(aktTick) || !durchschnittsBewegung.isValidCertaintyAt(aktTick))?null:p; 
	}
	
	public Position estimatePositionAliveAndCertain(int aktTick, boolean checkModulo) {
		Position p = durchSchnittsPosition.estimatePosition(
				durchschnittsBewegung, 
				aktTick,
				checkModulo);
		return (p==null || !p.isAliveAt(aktTick) || !durchschnittsBewegung.isValidCertaintyAt(aktTick))?null:p; 
	}

	//genaue bewegung noetig
	MyObject(Position newPos, Vector bewegung, int radius_inner, int radius_outer, boolean isVisible) {

		gespeichertePositionen = new ArrayList<Position>();
		
		if (bewegung==null)
			internBewegungGenau = false;
		else
			internBewegungGenau = true;
		
		setPosition(newPos);
		this.durchschnittsBewegung = bewegung;
		this.radius_inner = radius_inner;
		this.radius_outer = radius_outer;
		setNewID();
		anzUeberpruefungenBewegung=0;
	}
	
	protected void setRadius_inner(int ri)
	{
		radius_inner = ri;
	}

	protected void setRadius_outer(int ro)
	{
		radius_outer = ro;
	}
	
	private boolean isSameObjectType(Position a)
	{		
		if (a.getType()==null) return false;

		//selbe typ und goesse
		if (a.getType().equals(getType()) && a.getSize_inner()==getRadius_inner())
		{
			
			//falls asteroid
			if (getType().equals(Position.TYPE.ASTEROID))
			{
				if (a.getAsteroidType()==null ||
						getAsteroidType() == null )	return false;
				
				
				//gleiche typ
				if (getAsteroidType().equals(a.getAsteroidType()))
				{
					return true;
				}
				else
				{
					return false;
				}
			}
			
			return true;
			
		}
		
		
		return false;

		
	}
	
	public boolean findeMyObject(List<Position> pos) {

		//current time
		int aktTick = World.getTick();

		
		//zukuenftige objeke
		if (!this.isAliveAndCertainAt(aktTick) &&
				this.willBeAliveAndCetrainAfter(aktTick)) return true;

		//fehler
		if (aktTick == getCurrentTime())
		{
//			logger.debug("Gleiche Zeiten (t="+aktTick+") this:"+this+"    pos:"+pos);					
			return true;
		}
		
		//empty list
		if (pos.isEmpty()) 
		{
//			logger.warn("empty list!");
			return false;
		}
		
		
		
		if (pos.get(0)==null)
		{
//			logger.warn("strange error");
			return false;
		}
		


		
		//debug- spezialfall fuer shots
		if (WorldObjects.numShots!=pos.size() && pos.get(0).type.equals(Position.TYPE.SHOT))
		{
//			logger.warn("anzahl schuesse verschieden:"+WorldObjects.numShots+"  curr="+pos.size());
		}

		//tempvar
		float currDistSQR = Float.NaN;
		Position bestKandidate=null;
		float bestDistSQR = Float.MAX_VALUE;
		StringBuffer s= new StringBuffer("");
		
		//suche gleiches element mit geringstem abstand
		for (Position a: pos)
		{
			if (a!=null&& isSameObjectType(a) &&!a.getMarkierung()) 
			{
				if (bewegungIstGenau())
				{
					currDistSQR = Position.distanceSquared(a, estimatePosition(aktTick, true));
				}
				else
				{
					currDistSQR = Position.distanceSquaredIgnoreTime(a, durchSchnittsPosition);
				}
				
				
				//naeherer kandiat?
				if (currDistSQR<bestDistSQR)
				{
					bestKandidate = a;
					bestDistSQR = currDistSQR;
				}
				
				s.append(a.toString()+"_checked("+currDistSQR+")   ");
			}
			else
			{
				if (a==null)
					s.append("null");
				else
					s.append(a.toString()+(a!=null)+isSameObjectType(a)+(!a.getMarkierung())+"   ");
			}
		}
		
		
		if (bestKandidate==null)
		{
//			logger.debug("keinen passenden matching-Typ gefunden fuer "+this.toString()+" in "+s);
			return false;
		}		
	
		//bestimme max-distanz
		float maxDistanzSQR = MAXINTERNDISTUNGENAU*(aktTick - getCurrentTime()); 
		if (bewegungIstGenau())
			 maxDistanzSQR  = MAXINTERNDISTGENAU  *(aktTick - getCurrentTime());
		maxDistanzSQR*=maxDistanzSQR;
		
		
		
		
		//naehste kandiat nah genug?
		if (bestDistSQR<maxDistanzSQR)
		{
			
			

			
			//gueltiger kandidat
			//logger.debug(this.toString()+" konnte gematcht werden(maxdist="+Math.sqrt(maxDistanzSQR)+" currdist="+Math.sqrt(bestDistSQR)+") mit "+bestKandidate+"   liste:");
			bestKandidate.markiere(true);
			setPosition(bestKandidate);
			return true;
		} else
		{
			//keinen besseren kandidaten gefunden
//			logger.debug(this.toString()+" nicht gematcht, da abstand zu gross(maxdist="+Math.sqrt(maxDistanzSQR)+" currdist="+Math.sqrt(bestDistSQR)+" von "+bestKandidate+") liste:"+s);
			// hier -> kindsuche falls ansteroid zerst�rt und gro�er asteroid
			return false;
			
		}
		
	}
	
	/**
	 * makes a flat copy of the object;
	 * 
	 * @param old	object to be copied
	 */
	MyObject(MyObject old)
	{

		gespeichertePositionen = new ArrayList<Position>();
		gespeichertePositionen.addAll(old.gespeichertePositionen);
		
		internBewegungGenau = old.bewegungIstGenau();
		durchschnittsBewegung = old.getBewegung();
		
		durchSchnittsPosition = old.durchSchnittsPosition;
		
//		maximaleBewegung = old.maximaleBewegung;
//		minimaleBewegung = old.minimaleBewegung;
		

		//id wird bernommen!
		this.id = old.id;
		
		radius_inner = old.radius_inner;
		radius_outer = old.radius_outer;
		isVisible = old.isVisible;

		drawColor = old.drawColor;
		this.drawStringWithObject = old.drawStringWithObject;
		
		
//		if (old.killList!=null)
//		{
//			killList = new LinkedList<FireSolution>();
//			for(FireSolution f:old.killList)
//				killList.add(f);
//		}
		
		anzUeberpruefungenBewegung = old.anzUeberpruefungenBewegung;
		
		
	}
	
	public int getCreationTime()
	{
		return durchSchnittsPosition.getMinTimeIsValid(
				durchschnittsBewegung);
	}

	public int getDeathTime()
	{
		return durchSchnittsPosition.getMaxTimeIsValid(
				durchschnittsBewegung);
	}
	
	
	//adds to killist
	protected boolean killObject(FireSolution f)
	{
		if (f==null)
		{
//			logger.debug("cannot kill object, f=null"+this);
			return false;
		}

		if (f.getTarget().getId()!=this.getId())
		{
//			logger.debug("cannot kill object: "+this+ " id - missmachtch: "+this.getId()+"!="+f.getTarget().getId()+" !");
			return false;
		}
		
		Position k = estimatePosition(f.getHitTimeInner());
		
		if (k==null)
		{
//			logger.debug("object is dead or uncertain at killtime:"+f.getHitTimeInner());
			return false;
		}
		
		if (!f.willEndConsistentlyAfter(getCurrentTime()))
		{
//			logger.debug("cannot kill object:  "+this+ " because FireSolution is not good: "+f);
			return false;
		}
		
		//setze neue sterbezeit
		//wenn krzere sterbezeit
		if (f.getHitTimeInner()<durchSchnittsPosition.getTimeMax())
		{
			durchSchnittsPosition = new Position(durchSchnittsPosition);
			durchSchnittsPosition.setTimeMax(f.getHitTimeInner());
		} else
		{
//			logger.fatal("cannot set new time max:"+f.getHitTimeInner()+">=  "+durchSchnittsPosition.getTimeMax());
			return false;
		}
		return true;
	}
	
	public boolean isAliveAndCertain()
	{
		if (durchschnittsBewegung==null) return false;
		if (durchSchnittsPosition==null) return false;

		if (!durchschnittsBewegung.isValidCertaintyAt(getCurrentTime())) return false;
		return durchSchnittsPosition.isAliveAt(getCurrentTime());
	}
	public boolean isAliveAndCertainAt(int time)
	{
		if (durchschnittsBewegung==null) return false;
		if (durchSchnittsPosition==null) return false;

		if (!durchschnittsBewegung.isValidCertaintyAt(time)) return false;
		return durchSchnittsPosition.isAliveAt(time);
}
	
	public boolean willBeAliveAndCetrainAfter(int time)
	{
		return durchSchnittsPosition.willBeAliveAndCetrainAfter(durchschnittsBewegung, time);
	}
	
	
	/**
	 * Returns a collision-object if a collision occurs in the future.
	 * 
	 * @param a	collision partner
	 * @return	returns null, if no valid collision occurs in the future
	 * 			returned collision is valid and in the future.
	 */
	public Collision getCollisionWith(MyObject a)
	{
		Collision c = new Collision(this,a); 

		return c.willOccurAfter(getCurrentTime()) ? c : null;
	}
	
	/**
	 * Returns a collision-object if a collision occurs, if the collision
	 * occurs in the time intervall.
	 */
	public Collision getCollisionWith(MyObject a,int timeStart, int timeEnd)
	{
		Collision c = new Collision(this,a);

//		if (c.willOccurAfter(timeStart))
//		{
//			logger.warn("Consistent collision found at "+c.getHitTimeInner()+" with "+c.getObject2() + "    coll:"+c);
//		}
		
		if (c.willOccurAfter(timeStart) &&  //TODO faster
			c.willOccurBefore(timeEnd))
			return c;
		

		return null;
	}
	
	
	public String toString()
	{

		return ""
		+getId()+"_"+getType()
		+"[t="+getCurrentTime()
		+" ,genau="+bewegungIstGenau()
		+" ,ri="+radius_inner
		+" , "+durchSchnittsPosition.toStringMyObject()
		+" , "+durchschnittsBewegung
		+"]";
	}
	
	
	
	public void draw( Graphics2D g )
	{
		final int letter_draw_size_x = 6;
		
		int time = World.getTick();
		
		if (drawColor!=null)
			g.setColor(drawColor);

		if (!isAliveAndCertainAt(time))
			g.setColor(Color.lightGray);


		//remove invalid firesolutions

		
		Position p = estimatePosition(time);
		Position p1 = estimatePosition(time+ARROWSIZEMULTIPLIER,false);
		
		if (p==null)
		{
//			logger.debug("Object Position unknown! Cannot Draw Object ("+this+")");
			//p = estimatePosition(time); -> wg threading kann das im debugger nicht null werden
			return;
		}
		
		//bewegung
		if (p1!=null)
			drawArrow(p,p1,g );


		//aussenkreis
//		Color old = g.getColor();
//		g.setColor(Color.gray);
		g.drawOval(p.getXforDrawing()-radius_outer/Position.FAKTOR, p.getYforDrawing()-radius_outer/Position.FAKTOR, 2*radius_outer/Position.FAKTOR, 2*radius_outer/Position.FAKTOR);
//		g.setColor(old);
//		g.setColor(drawColor);
		
		//innenkreis
		g.drawOval(p.getXforDrawing()-getRadiusForDrawing(), p.getYforDrawing()-getRadiusForDrawing(), 2*getRadiusForDrawing(), 2*getRadiusForDrawing());

		
		
		
		//draw drawStringWithObject
		if (drawStringWithObject!=null && !drawStringWithObject.equals(""))
			g.drawString(drawStringWithObject, p.getXforDrawing()+getRadiusForDrawing(), p.getYforDrawing()+getRadiusForDrawing());
		
		
		//draw other strings
		String drawString=""+getId();

		if (!bewegungIstGenau()) 
			drawString = drawString +"u";

	
		
//		if (getProbBeeingAlive(time)==0) 
//			drawString=drawString+"dead";
		
		if (getRadiusForDrawing()>15)
			g.drawString(drawString, p.getXforDrawing()-1*letter_draw_size_x, p.getYforDrawing());
		else
			g.drawString(drawString, p.getXforDrawing()-2*letter_draw_size_x-getRadiusForDrawing(), p.getYforDrawing()-getRadiusForDrawing());
			
//		if (logger.isDebugEnabled())
//		{
//		
//		Color old;
//		// draw killist
//		if (killList!=null)
//			for (FireSolution f:killList)
//			{
//				old = f.getDrawColor();
//				f.setDrawColor(drawColor);
//				f.draw(g);
//				f.setDrawColor(old);
//			}
//		}
		
	}
	
	public int getRadiusForDrawing()
	{
		return radius_inner/Position.FAKTOR;
	}
	
	protected static void drawArrow(Position from, Position to, Graphics2D g)
	{
		
		g.drawLine(from.getXforDrawing(), from.getYforDrawing(), to.getXforDrawing(),to.getYforDrawing());
		//use ARROWTIPSIZE
		
	}

	public String getDrawStringWithObject() {
		return drawStringWithObject;
	}

	public void setDrawStringWithObject(String drawStringWithObject) {
		this.drawStringWithObject = drawStringWithObject;
	}

	public Color getDrawColor() {
		return drawColor;
	}

	public void setDrawColor(Color drawColor) {
		this.drawColor = drawColor;
	}
	

	/*
	 * 
	 * gibt genauen InternBewegungsvektor über einen Frame zurück
	 * 
	 * wenn nicht möglich, dann 0
	 * Positionen müssen zeitlich sortiert sein
	 */
	public void gibInternBewegung() {
		
		
		ArrayList<Position> positionen = gespeichertePositionen;
		
		for (int i = 0; i < positionen.size() -1 ; i++) {
			for (int j = i+1; j < positionen.size(); j++) {
				int zeitDiff = positionen.get(j).getZeitpunkt() - positionen.get(i).getZeitpunkt();
				
				if (zeitDiff == 8) {
					durchschnittsBewegung = new Vector(positionen.get(j), positionen.get(i),0f,getCurrentTime(),1f);
					durchschnittsBewegung.setXY(
							durchschnittsBewegung.getX()/8, 
							durchschnittsBewegung.getY()/8);
					internBewegungGenau = true;
					//System.out.println("bew ist" + durchschnittsBewegung.toString());
					return;
				}	
				
			}
		}
		// Wenn Bewegung nicht eindeutig feststellbar, suche nach möglichst größer Zeitdifferenz zum Schätzen
		int maxZeitdiff =  0;
		if (positionen.size() <=1) return;
		int zeitpunkt1 = 0;
		int zeitpunkt2 = positionen.size()-1;
		int zeitdiff = positionen.get(zeitpunkt2).getZeitpunkt() - positionen.get(zeitpunkt1).getZeitpunkt();
//		maximaleBewegung = new Vector(positionen.get(zeitpunkt2) , positionen.get(zeitpunkt1));
		Vector maximaleBewegung = new Vector(
				positionen.get(zeitpunkt2).getX()-positionen.get(zeitpunkt1).getX(),
				positionen.get(zeitpunkt2).getY()-positionen.get(zeitpunkt1).getY(),Float.NaN,Integer.MAX_VALUE,Float.NaN);
		
		if (maximaleBewegung.getX() < 0)
			maximaleBewegung.add(-7,0);
		else 
			maximaleBewegung.add(7,0);
		if (maximaleBewegung.getY() < 0)
			maximaleBewegung.add(0,-7);
		else 
			maximaleBewegung.add(0,7); 
		maximaleBewegung = Vector.multiplizier(maximaleBewegung,1f/zeitdiff);
		
		Vector minimaleBewegung = new Vector(
				positionen.get(zeitpunkt2).getX()-positionen.get(zeitpunkt1).getX(),
				positionen.get(zeitpunkt2).getY()-positionen.get(zeitpunkt1).getY(),Float.NaN,Integer.MAX_VALUE,Float.NaN);
		if (minimaleBewegung.getX() > 0)
			minimaleBewegung.add(-7,0);
		else 
			minimaleBewegung.add(7,0);
		if (minimaleBewegung.getY() > 0)
			minimaleBewegung.add(0,-7);
		else 
			minimaleBewegung.add(0,7); 
		minimaleBewegung = Vector.multiplizier(minimaleBewegung,1f/zeitdiff);
		
		durchschnittsBewegung = new Vector(
				positionen.get(zeitpunkt2).getX()-positionen.get(zeitpunkt1).getX(),
				positionen.get(zeitpunkt2).getY()-positionen.get(zeitpunkt1).getY(),0f, positionen.get(zeitpunkt2).getZeitpunkt(),1);
		durchschnittsBewegung = Vector.multiplizier(durchschnittsBewegung,1f/zeitdiff);
//		World.notifyScreenChangedListener(); //TODO:EIGENTLICH DOCH
//		logger.debug("note from intern bew");
	}
/**s
	 * Calculates next the point in time, after which the object
	 * left the screen. If the movement is 0 then Integer.Max
	 * will be returned;
	 * @return
	 */
	public int getOverflowTime()
	{
		if (getBewegung()==null)
			return Integer.MIN_VALUE;
		if (getPosition()==null)
			return Integer.MIN_VALUE;
		
		int nx = getBewegung().getX();
		int ny = getBewegung().getY();
		
		if (nx==0 && ny ==0) return Integer.MIN_VALUE;
		
		int px = getPosition().getX();
		int py = getPosition().getY();
		
		//grenzen
		int gx = nx>0?Position.screenSizeX:0;
		int gy = ny>0?
				Position.screenSizeY+Position.offsetY
				:Position.offsetY;
		
		if (nx==0) return(gy-py)/ny+getCurrentTime()+1;
		if (ny==0) return(gx-px)/nx+getCurrentTime()+1;
		
		return Math.min(
				(gx-px)/nx+getCurrentTime()+1, 
				(gy-py)/ny+getCurrentTime()+1);
		
	}
	
	
	//time where objects are intersecting
	private static int bestDur;

	/**
	 * Must be called directly after {@link #hitTest(int, int, int, int, int, int)}
	 * 
	 * @return returns the intersecting time for computed the hit time.
	 */
	public static int getInterSectionTime()
	{
		return bestDur;
	}
	
	/**
	 * Tests if two objects hit and returns the hitProbability.
	 * obj-eqn: x(t) = mt+n
	 * rad-eqn: r(t) = Rt+Ro
	 * 
	 * computed will be t:  |x1(t)-x2(t)| = (r1(t)+r2(t)) 
	 * 
	 * @param dmx	m1x-m2x
	 * @param dmy	m1y-m2y
	 * @param dnx	pos1x-pos2x  (at time t=0)
	 * @param dny	pos1y-pos2y  (at time t=0)
	 * @param dR	(R1+R2)
	 * @param dRo	(Ro1+Ro2)
	 * @return	Integer.MIN_VALUE if object is not hit, 
	 * 			otherwise relative hittime is returned.
	 */
	public static int hitTest(int dmx, int dmy, int dnx, int dny, int dR, int dRo)
	{

		
		//solve: maxDist = (dmx^2+dmy^2-dR^2)t^2 + 2(dmx*dnx + dmy*dny-dR*dRo)t + dnx^2+dny^2-dRo^2
		//mitternachtsformel: x^2 + px + q = 0;
		double a= 1d/(dmx*dmx+dmy*dmy-dR*dR);
		double tmp;
		double p,q;
		
		int dnxb=dnx;
		int dnyb=dny;
		
		int tbestpos=Integer.MAX_VALUE;
		int tbestneg=Integer.MIN_VALUE;
		bestDur=Integer.MIN_VALUE; //
		int ttmp;
		
		for (int i=-1;i<2;i++)
			for (int j=-1;j<2;j++)
			{
				dnx = dnxb + i*Position.screenSizeX;
				dny = dnyb + j*Position.screenSizeY;
				
				p = a*(dmx*dnx+dmy*dny-dR*dRo);
				q = a*(dnx*dnx+dny*dny-dRo*dRo);
				tmp = p*p-q;
				
				//trift nicht
				if (tmp<0) continue;
				
				//trift
				tmp=Math.sqrt(tmp);
					
				//return smallest point of time
				if ((-p-tmp)>0)
				{
					ttmp = (int)Math.ceil(-p-tmp);
					if (ttmp<tbestpos)
					{
						tbestpos=ttmp;
						bestDur = (int)Math.floor(tmp*2);
					}
				} else
				{
					ttmp = (int)Math.floor(-p+tmp);
					if (ttmp>=0 && ttmp<tbestpos)
					{
						tbestpos=ttmp;
						bestDur = (int)Math.floor(tmp*2);
					}
					if (ttmp<0 && ttmp>tbestneg)
					{
						tbestneg=ttmp;
						bestDur = (int)Math.floor(tmp*2);
					}
				}
		
			}
		
		if (tbestpos==Integer.MAX_VALUE) return tbestneg;
		
		//sum over time kreiintersections
	
		return tbestpos;
		
		
	}
	

	public int getRadius_inner() {
		return radius_inner;
	}


	public int getRadius_outer() {
		return radius_outer;
	}

	public boolean isVisible() {
		return isVisible;
	}
	
	
	public float getPositionProbability(int time)
	{
		Position P = estimatePositionAliveAndCertain(time);
		return (P==null)?0:durchschnittsBewegung.getCertaintyAt(time); 
	}
	
	public void setVisible(boolean isVisible) {
		this.isVisible = isVisible;
	}
	private void ueberpruefeBewegung() {
		if (!internBewegungGenau)
			return;
		ArrayList<Position> positionen = gespeichertePositionen;
		int size = positionen.size();
		for (int i = size - 2; i > -1 ; --i) {
				int zeitDiff = positionen.get(size - 1).getZeitpunkt() - positionen.get(i).getZeitpunkt();
				
				if (zeitDiff == 8 ) {
					Vector tmp = new Vector(positionen.get(size - 1), positionen.get(i),Float.NaN,Integer.MAX_VALUE,Float.NaN);
					tmp.setXY(tmp.getX()/8, tmp.getY()/8);
					if (tmp.getX() == durchschnittsBewegung.getX() &&
						tmp.getY() == durchschnittsBewegung.getY())
					{
						++anzUeberpruefungenBewegung;
						//logger.fatal("Genaue Bewegung");
					}
					else 
					{
						gespeichertePositionen.clear();
						internBewegungGenau = false;
//						logger.info("Ungenaue BEwegung festgestellt. Lösche Positionen und berechne alles neu");
//						logger.debug("ScreenChanged");
//						World.notifyScreenChangedListener();
						return;
					}
				}	
				
		}
		
	}

		
	
	
	
	
	/**
	 * Returns the uncertaintiy about beeing at a certain pixel
	 * @param time		point of time
	 * @return			0..1 (1=very Uncertain, 0=certain)
	 */
	public float getUncertainty(int time)
	{
		float p = getPositionProbability(time);
		return (float)((p*Math.log(p)+(1-p)*Math.log(1-p))*loginvneg);
		
	}
	private static final double loginvneg= -1d/Math.log(2);
	
	public void setNewID(){
		this.id = counter++;
	}
	
	@Override
	public boolean equals(Object o)
	{
		
		if (o instanceof MyObject) 
		{
			MyObject obj = (MyObject) o;
			return obj.getId()==getId();
		} 
		else 
			return false;
		
	}
	
//	public List<FireSolution> getKillList()
//	{
//		return killList;
//	}
	
} 