package hek.de.hinni.hek.asteroids;

import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;



//benutzt Heuristiken zum Finden guter Loesungen
public class HinniStrategieKomplex extends Strategie{
	private LinkedList<FireSolution> abschussFIFO; // speichert die nächsten Ziele für Abschuss
	private LinkedList<MyObject> gefahrenList; //speichert Objekte die mit dem Raumschiff kollidieren werden
	private LinkedList<MyObject> abgeschossen; //speichert Objekte auf die bereits geschossen wurde
	
	private int schuesseAbzugeben;
	private boolean pause;
	public HinniStrategieKomplex() {
		abschussFIFO = new LinkedList<FireSolution>();
		gefahrenList = new LinkedList<MyObject>();
		abgeschossen = new LinkedList<MyObject>();
		schuesseAbzugeben = 0;
		pause = false;
	}
	
	public static final Logger logger = Logger.getLogger(HinniStrategieKomplex.class);
	/*
	 * @return true wenn ein Schuss mit dem Raumschiff kollidiert in den nächsten 2 Frames
	 * 
	 */
	public boolean ueberpruefeSchuesseAufGefahr(MyShip ship, List<MyShot> shots, int aktTick) {
		for (MyShot s: shots) {
			Collision c = new Collision(ship, s);
			if (c.willOccurAfter(aktTick)) {
				if (aktTick  + 2>= c.getHitTimeOuter()) { //wenn in den nächsten 2 Frames ein Schuss das Schiff zerstören würde 
					logger.info("Kritischer Schuss" + s.getId());
					return true;
				}
			}
		}
		return false;
	}
	/*
	 * return true wenn ein Asteroid mit dem Raumschiff kollidiert in den nächsten 2 Frames
	 */
	public boolean ueberpruefeAsteroidenAufGefahr(MyShip ship, List<MyAsteroid> asteroids, int aktTick) {
		if (aktTick %200 == 0) //RAUS DAMIT SPÄTER
			abgeschossen.clear();
		for (MyAsteroid a: asteroids) {
			Collision c = new Collision(ship, a);
			if (c.willOccurAfter(aktTick)) {
				if (aktTick  + 2>= c.getHitTimeOuter()) { //wenn in den nächsten 2 Frames ein Schuss das Schiff zerstören würde 
					logger.info("Kritischer Asteroid" + a.getId());
					return true;
				}
			}
		}
		return false;
	}
	/*
	 * gibt zurueck wieviele Schuesse man noch abgeben kann
	 */
	public int berechneFreieSchuesse(List<MyShot> shots) {
		int erg = 4;
		for (MyShot s: shots) {
			if (!s.isVisible()) //mein schuss
				--erg;
		}
		return erg;
	}
	public FireSolution gibBesteFiresolution(MyShip ship, LinkedList<FireSolution> firesolutions, LinkedList<MyObject> abgeschossen, LinkedList<MyObject> gefahrenList, int aktTick) {
		int min = aktTick + 100;
		FireSolution myFS = null;
		if (gefahrenList.size() != 0) {
			logger.info("Kritische Asteroden");
			for (FireSolution fs: firesolutions) {
				if (gefahrenList.contains(fs.getTarget())) {
					if (fs.canBeExecuted(ship ) && fs.getHitTimeInner() < min && !abgeschossen.contains(fs.getTarget())) {
						min = fs.getHitTimeInner();
						myFS = fs;
					}			
				}
			}
			if (myFS != null)
				return myFS;
		}
				
			
		
		for (FireSolution fs: firesolutions) {
			if (fs.canBeExecuted(ship) && !abgeschossen.contains(fs.getTarget()) && fs.getTarget().bewegungIstGenau()) {
				if (fs.getHitTimeInner() < min) {
					min = fs.getHitTimeInner();
					myFS = fs;
				}			
			}
		}
		return myFS;
	}
	public TastenTyp getEingabe(WorldObjects objects, StatusFlags status, int aktTick) {
		if (!status.ueberpruefe(StatusFlags.SHIP_EXISTS))
			return TastenTyp.NICHTS;
		LinkedList<FireSolution> firesolutions = new LinkedList<FireSolution>();
		
		//hole alle minimalen Zeitpunkte zu denen ein Asteroid abgeschossen werden könnte
		//vom momentanen Zustand des Schiffs ausgehend
		for (MyAsteroid a: objects.getMyAsteroids()) {
			FireSolution fs = objects.getMyShip().getFireSolution(a, true, 1f,objects.getMyShip().getCurrentTime());
			if (fs != null)
				firesolutions.add(fs);
		}
		
		//ueberprüfe auf gefährliche Asteroiden
		gefahrenList.clear();
		for (MyAsteroid a: objects.getMyAsteroids()) {
			Collision c = new Collision(objects.getMyShip(), a);
			if (c.willOccurAfter(aktTick))
				gefahrenList.add(a);
		}
		//Kollidiert UFO mit Schiff?
		if (status.ueberpruefe(StatusFlags.SAUCER_EXISTS)) {
			Collision c = new Collision(objects.getMyShip(), objects.getMySaucer());
			if (c.willOccurAfter(aktTick))
				gefahrenList.add(objects.getMySaucer());
		}
		
		//ueberprüfe auf gefährliche Schuesse
		//wenn 2 Frames vor tot sein und keine möglichkeit zu retten, dann hyperspace
		if (ueberpruefeSchuesseAufGefahr(objects.getMyShip(), objects.getMyShots(), aktTick))
			return TastenTyp.HYPERSPACE;
		if (ueberpruefeAsteroidenAufGefahr(objects.getMyShip(), objects.getMyAsteroids(), aktTick))
			return TastenTyp.HYPERSPACE;
		
		//bereche eigene freie Schüsse
		int schuesseFrei = berechneFreieSchuesse(objects.getMyShots());
		//bewerte Firesolutions
		if (abschussFIFO.size() == 0) {
			FireSolution myFS = gibBesteFiresolution(objects.getMyShip(), firesolutions, abgeschossen, gefahrenList, aktTick);
			if (myFS != null)
				abschussFIFO.addLast(myFS);
		}
		
		//wenn saucer existiert, bewerte es(schuessefrei, zeitbisschuessefrei, gefahrenList) <-- immer machen
		if (status.ueberpruefe(StatusFlags.SAUCER_EXISTS)) {
			FireSolution fs = objects.getMyShip().getFireSolution(objects.getMySaucer(), true, 1,objects.getMyShip().getCurrentTime());
			if (fs != null)
				if (fs.canBeExecuted(objects.getMyShip())) {
					abschussFIFO.addLast(fs);
			}
		}
		if (schuesseAbzugeben > 0) {
			if (pause) {
				pause = false;
				return TastenTyp.NICHTS;
			}
			else {
				pause = true;
				schuesseAbzugeben--;
				return TastenTyp.FEUER;
			}
		}

		if (abschussFIFO.size() != 0) {
			FireSolution fs = abschussFIFO.getFirst();
			if (fs.canBeExecuted(objects.getMyShip())) {
				TastenTyp t= fs.execute(objects.getMyShip());
				if (t != TastenTyp.FEUER)
					return t;
				else {
					MyObject ziel = abschussFIFO.get(0).getTarget();
					abgeschossen.add(ziel);
					abschussFIFO.removeFirst();
					if (ziel.getType() == Position.TYPE.ASTEROID) {
						MyAsteroid astZiel = (MyAsteroid)ziel;
						schuesseAbzugeben = (int)Math.pow(2,astZiel.getGroesseID())-1;
						if (schuesseAbzugeben > schuesseFrei)
							schuesseAbzugeben = schuesseFrei;
					}
					pause = true;
					--schuesseAbzugeben;
					return TastenTyp.FEUER;
				}
						
			}
			
			else {
				abschussFIFO.clear();
			}
		}
		return TastenTyp.NICHTS;
		
		/*if (abschussFIFO.size() == 0)
			return TastenTyp.NICHTS;
		FireSolution fs = firesolutions.get(0);
		if (!fs.canBeExecuted(objects.getMyShip())) {
			abschussFIFO.clear();
			//abschussFIFO.removeFirst();
			return TastenTyp.NICHTS;
		}
			
		//if (fs.execute(objects.getMyShip()) != TastenTyp.FEUER)
			return fs.execute(objects.getMyShip());*/
		/*MyObject ziel = abschussFIFO.get(0).getTarget();
		abgeschossen.add(ziel);
		abschussFIFO.removeFirst();
		if (ziel.getType() == Position.TYPE.ASTEROID) {
			MyAsteroid astZiel = (MyAsteroid)ziel;
			schuesseAbzugeben = (int)Math.pow(2,astZiel.getGroesseID())-1;
			if (schuesseAbzugeben > schuesseFrei)
				schuesseAbzugeben = schuesseFrei;
		}
		pause = true;
		--schuesseAbzugeben;
		return TastenTyp.FEUER;
*/


		//vwievieleschuesseAufBestenKandidatenabgeben(schuessefrei, zeitbisschuessefrei, gefahrenList
		//speicher Entscheidung in Liste
		//drehe und schieße
		//markiere Asteroiden als abgeschossen


	}
	
	public void draw(Graphics2D g) {
	
	}
	
	
}
