// player.h: Beispielspieler f�r Asteroids
// Harald B�geholz / c't
#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes f�r sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include "MovingObjects/MovingObject.h"
#include "MovingObjects/Shot.h"
#include "MovingObjects/Ship.h"
#include "MovingObjects/Ufo.h"
#include "MovingObjects/Asteroid.h"
#include "KeysPacket.h"

class Player
{
public:
    Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
    void Run(void);
    void ReceivePacket(FramePacket &packet);
    void SendPacket(KeysPacket &packet);
    void SendPlayerName();
private:
    SOCKET sd;
    ADDRESS server_ip;
};
