#ifndef SHOT_H
#define SHOT_H

#include "MovingObject.h"
#include "../FrameStatus/ObjectLink.h"

class Ship;
class Ufo;

/// \brief Represents a shot.

class Shot : public MovingObject, public ObjectLink<Shot>::Linkable
{
public:

    /// \todo When linked to previous shot, new shot should
    /// copy some properties (i.e. the firedFrom properties).

    Ship* firedFromShip; ///< Ship (and its status) the shot came from.
    Ufo* firedFromUfo; ///< Ufo (and its status) the shot came from.

    virtual std::string className() {return "Shot";}

    Shot()
    : firedFromShip(0), firedFromUfo(0)
    {}

    Shot(FrameStatus* frame, int x, int y)
    : MovingObject(frame,x,y), firedFromShip(0), firedFromUfo(0)
    {}



    virtual void listInsertAfter(MovingObject* o) {
        MovingObject::listInsertAfter(o);
        if (listNext) {
            ((Shot*)listNext)->firedFromShip = firedFromShip;
            ((Shot*)listNext)->firedFromUfo = firedFromUfo;
        }
    }

};

#endif
