#ifndef COLLISION_H
#define COLLISION_H

#include "cmath"
#include "MovingObject.h"

/// \brief Collision prediction of two moving objects.

class Collision
{
public:
    double time;  ///<  Est. time to collision, in seconds.
    double offs;  ///<  Center-center distance during collision.
    double dist;  ///<  Distance between objects.

    MovingObject *a;
    MovingObject *b;

    Collision(MovingObject &a, MovingObject &b)
    {
        double dx = a.getx()-(b.getx()+COL_MOVE_ASTEROID*b.getu()/60.);
        double dy = a.gety()-(b.gety()+COL_MOVE_ASTEROID*b.getv()/60.);
        FrameStatus::normalize(dx,dy);

        double du = a.getu()-b.getu();
        double dv = a.getv()-b.getv();

        double speed = du*du+dv*dv;
        double way   = du*dx+dv*dy;
        if (   speed <= 0
            || way   >  0)
            time = 10;
        else
            time = -way/speed;

        double ddx = dx+time*du;
        double ddy = dy+time*dv;
        offs = sqrt(ddx*ddx+ddy*ddy);
        if (offs > 1e3) offs = 1e3;

        // normalize deviation by distance
        dist = sqrt(dx*dx+dy*dy);

        this->a = &a;
        this->b = &b;

    }

};


#endif
