#ifndef KEYSPACKET_H
#define KEYSPACKET_H

#include <string>

/// \brief Key status, as send to ctMAME, and logged by FrameStatus.

class KeysPacket
{
private:
    static const char KEY_HYPERSPACE = 1;
    static const char KEY_FIRE = 2;
    static const char KEY_THRUST = 4;
    static const char KEY_RIGHT = 8;
    static const char KEY_LEFT = 0x10;

    char signature[6];
    char keys;
public:
    char ping;     // wird vom Server bei n�chster Gelegenheit zur�ckgeschickt. F�r Latenzmessung.

    std::string toString()
    {
        std::string r;

        if (keys & KEY_THRUST) r = r+"thrust:1 ";
        else r = r+"thrust:0 ";

        if (keys & KEY_HYPERSPACE) r = r+"hyper:1 ";
        else r = r+"hyper:0 ";

        if (keys & KEY_LEFT) r = r+"left:1 ";
        else r = r+"left:0 ";

        if (keys & KEY_RIGHT) r = r+"right:1 ";
        else r = r+"right:0 ";

        if (getFire()) r = r+"fire:1 ";
        else r = r+"fire:0 ";

        return r;
    }

    KeysPacket(void)
    {
        signature[0] = 'c';
        signature[1] = 't';
        signature[2] = 'm';
        signature[3] = 'a';
        signature[4] = 'm';
        signature[5] = 'e';
        keys = '@';
        ping = 0;
    }

    void clear(void)         // alle Tasten loslassen
    {
        keys = '@';
    }

    void hyperspace(bool b)  // Hyperspace dr�cken (true) oder loslassen (false)
    {
        if (b)
            keys |= KEY_HYPERSPACE;
        else
            keys &= ~KEY_HYPERSPACE;
    }

    void fire(bool b)        // Feuerknopf dr�cken (true) oder loslassen (false)
    {
        if (b)
            keys |= KEY_FIRE;
        else
            keys &= ~KEY_FIRE;
    }

    void thrust(bool b)      // Beschleunigen ...
    {
        if (b)
            keys |= KEY_THRUST;
        else
            keys &= ~KEY_THRUST;
    }

    void right(bool b)       // rechts drehen ...
    {
        if (b)
        {
            keys |= KEY_RIGHT;
            left(false);
        }
        else
            keys &= ~KEY_RIGHT;
    }

    bool getFire() {return keys & KEY_FIRE;}
    bool getThrust() {return keys & KEY_THRUST;}
    bool getRight() {return keys & KEY_RIGHT;}
    bool getLeft() {return keys & KEY_LEFT;}

    void left(bool b)        // links drehen
    {
        if (b)
        {
            keys |= KEY_LEFT;
            right(false);
        }
        else
            keys &= ~KEY_LEFT;
    }

};

#endif
