#ifndef INC_SANDBOX
#define INC_SANDBOX
/** this class use the frame scanner and all known input to get a idee of the 
    atari game state

		we avoid here all kind of dynamic array to allow later fast data movement instead 
		of using stl classes

*/

#include "tools.h"
#include "gameobj.h"
#include "framescanner.h"

/** the current game state
    a sandbox hold the current situation and a predication for the future 
*/
class sandBoxC {	
	/// the next key
	static int uniqueKey;
	/// list of all objects
	gameObjListC objects;	
	/// update timer for this box
	unsigned int updateTime;
	/// we need this value to calc our time correct
	unsigned int frameIndex;
	/// my ship
	spaceShipC spaceShip;
	///
	int shipPresent;
	///
	void removeOld();
	///
	int level;
	///
	int score;
	///
	unsigned int levelStartTime;
	///
	unsigned int gameStartTime;
	///
	int levelScore;
	///
	int levelFire;
	///
	int levelShots;
	///
	int lastObjectCount;
public:	
	///
	int getScore() const { return score;}
	///
	static unsigned int getNextKey() { return uniqueKey++;}
	///
	sandBoxC() { updateTime=-1;frameIndex=0;level=0;score=0;levelStartTime=0;lastObjectCount=0;levelScore=0;gameStartTime=TIME_INFINITE;levelShots=0;levelFire=0;}
	/// get one frame and see how this fit to our data
	void update(const gameStatusC & status);
	/// return a list of the current objects
	const gameObjListC & getObjects() const { return objects;}
	///
	unsigned int getTime() const { return updateTime;}
	///
	int getSpaceShip(spaceShipC & retShip) const { retShip=spaceShip;return shipPresent;}	
	/// update spaceship data for next frame
	void hitRotate(int head) { spaceShip.hitRotate(head);}
	///
	void hitFire(unsigned int time) { levelFire++;spaceShip.shot(time);}
	///
	void addForcastObject(const gameObjC & obj) { objects.add(obj);}
};

#endif
