#include "control.h"
#include "jumper.h"

gameCtrlC::gameCtrlC(const char * server)
{
	netCom.init(server);
}

void gameCtrlC::start()
{
	// our controler is nothing else than a status engine .. so define the states
	enum stateE {undef,waitForShip,waitForData,normalMode,spyMode,rotTest,waitForShipHype,waitLevelStart} state,fallbackData,lastState;

	unsigned int levelWaitStartTime=0;
	int          offFire=0;
	fallbackData=undef;
	// if we are in game mode .. use this
	state       =waitForShip;	
	// if we just want to watch the player .. use this
	// state       =spyMode;
	jumperC jumper;

	
	int anyNormalMode=0;
	
	
	lastState   =undef;

	int i=0;

	// the keys to send for next round ..
	keysPacketC key;
	key.clear();  	
	// 
	top:

	if (state!=lastState)
	{
		// printLog("frame %4d|state %d to %d\n",sandbox.getTime(),lastState,state);
		lastState=state;
	}
	
	switch (state) {
		// get data. important we have to send to get data
		// use a fallback to setup the state after doing this
		case waitForData:			 
			 sendKeys(netCom,key);			 
			 if (getFramebuffer(netCom,frame))
			 {  
					state=fallbackData;
					gameStatus.scanFrame(frame);
					sandbox.update(gameStatus);
				}
			break;
		// wait for ship ..
		case waitForShip:
			key.clear();
			// see if ship is here ...
			if (gameStatus.ship_present)
				state=normalMode;	// yes go to normal mode ..
			else
			{
				state=waitForData;
				fallbackData=waitForShip;
			}
			break;
		case rotTest:
			key.clear();

			if (i<10) { key.left(true);sandbox.hitRotate(1);}
			else if (i<20) { key.right(true);sandbox.hitRotate(-1);}
			else 
				fatalError("done");
			i++;

			
			state=waitForData;
			fallbackData=rotTest;

			break;
		case spyMode:
			// we using spy mode .. no ship is needed ..
			state=waitForData;
			fallbackData=normalMode;
			break;
		case normalMode:						
		{
			// we are in normal game mode ..
			key.clear();
			// our ship is way ..
			if (!sandbox.getSpaceShip(spaceShip))
			{
				state=waitForShip;
				break;
			}

			int headChange=0;
			int speedChange=0;
			int panic=0;
			unsigned int fireTime=0;
		 /*
			if (sandbox.getObjects().count()==0)
				jumper.setTarget(spaceShip.getPosition(),vecIntC(400,200));
			else
				jumper.getNextSeq(spaceShip,headChange,speedChange);
			*/

				
			// do update anyway
			plan.update(sandbox.getTime(),spaceShip,sandbox.getScore(),sandbox.getObjects());

			// see if we have any target
			if (sandbox.getObjects().count()==0)
			{
				state=waitLevelStart;
				levelWaitStartTime=sandbox.getTime();
				offFire=0;
				break;
			}

			anyNormalMode=1;
			
			plan.getOptimalKill(sandbox.getTime()+2,headChange,fireTime,panic);
			{

				switch (headChange) {
				case 0:break;
				case 1:key.left(1);sandbox.hitRotate(1);break;
				case -1:key.right(1);sandbox.hitRotate(-1);break;
				}
							
				if (fireTime>0)
				{
					key.fire(1);						
					sandbox.hitFire(sandbox.getTime()+2);		

				}
				if (speedChange)
					key.thrust(true);
				
			}
		

			{
				static int full=0;
				static int lastShot=0;
				static int shotCount=0;
				static int shotSum=0;
				static int nop=0;
				static int nopRot=0;


				if (sandbox.getObjects().count())
				{
					full++;

					if (!headChange)
						nopRot++;
					if (!headChange && !fireTime)
						nop++;
					if (fireTime>0)
					{
						shotCount++;

						// printf("%d\n",sandbox.getTime()-lastShot);
						
						shotSum+=sandbox.getTime()-lastShot;
						lastShot=sandbox.getTime();
					}

					if (full % 500==0)
					{
						printf("%d %d %d %d\n",full,nop,shotCount?shotSum/shotCount:0,nopRot);
					}
				}
			}


																		
			state=waitForData;
			fallbackData=normalMode;
			if (panic)
			{
				key.hyperspace(true);
				state=waitForShipHype;
			}
									
			break;
		}
		case waitLevelStart:
			 if (sandbox.getObjects().countTargets())
			 {
				 state=normalMode;
				 break;
			 }
			 key.clear();
			 // no obejcts found .. what is the next side for my ship ..
			 {
				 
				 vecDblC vec( convVec(spaceShip.getPosition())-vecDblC(524,396));
				 /*
				 if (anyNormalMode && vec.len()<250 && sandbox.getTime()-levelWaitStartTime<20)
					 key.hyperspace(true);
				 */
				 
				 // time to hit the wall from our position
				 int time=(700/2-vec.len())/8;
				 if (time<20)
					 time=20;
					
				 
				 // there are 165 Frames break .. so only shot in the last frames
				 if (sandbox.getTime()-levelWaitStartTime>160-time && offFire<3)
				 { // printf("#");					 
					 if ((sandbox.getTime() % 4)==0)
					 { // printf("+");
						 key.fire(true);
						 offFire++;						 
					 }
					 key.left(true);					 
					 spaceShip.hitRotate(1);
				 }
				 else				 
				 {
					 // this is the vec from ship to center ..
					 
					 if (vec.len()<1e-8) vec=vecDblC(0,1);
					 else
						 vec=vec.norm(1);

					 double angle=rotationData[spaceShip.getRotationIndex()].angDegree/180*PI;
					 vecDblC head(cos(angle),sin(angle));
					 double dir=head.cross(vec);
					 if (dir>0)
					 { spaceShip.hitRotate(1);
						 key.left(true);
					 }
					 else
					 { spaceShip.hitRotate(-1);
						 key.right(true);
					 }				 
				 }
			 }
			 state=waitForData;
			 fallbackData=waitLevelStart;
			 break;
		case waitForShipHype:
		{			
			if (gameStatus.ship_present)
			{
				state=waitForData;
				fallbackData=waitForShipHype;								
				break;
			}
		 
		 state=waitForShip;
		 break;
		}
	}

	goto top;

}