
#ifndef _GAMESTATUS_H
#define _GAMESTATUS_H

#include "objectmanager.h"
#include "commonplayer.h"

//using CommonPlayer::DistanceState;

class GameStatus
{
public:
	enum State
	{
 		unknown = 1,	// noch nicht ermittelt
		standby = 2,	// Wartet auf Start-Button
		prepare = 3,	// Start-Button gedrckt, Spiel beginnt bald
		playing = 4,	// Aktiv im Spiel
		gameover = 5,  // Letztes Schiff verloren
		highscore = 6  // Highscore eingeben
	};

	// bitweise, also | verknpft, abprfen mit &
	enum Event
	{
		nothing = 0,				// nichts passiert
		ship_lost = 1,			 // Schiff wurde zerstrt
		asteroid_destroyed = 2, // Asteroid wurde zerstrt
		saucer_destroyed = 4,	// Ufo wurde zerstrt
		ship_inhyperspace = 8,  // Schiff tritt in Hyperspace ein
		gamestart = 16,			// Spiel startet (erstes Level beginnt)
		nextlevel = 32,			// das nchste Level wurde erreicht
		newlife = 64,			  // neues Leben/Schiff erhalten
		state_changed = 128	  // Zustand hat sich verndert
	};
	
	State state;				// Zustand des Spieles
	Event events;			  // Ereignisse, dis seit der letzten Mal auftraten
	Ship ship;				  // Schiff
	Saucer saucer;			 // UFO
	unsigned int nasteroids;			// Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	unsigned int nbigasteroid;		 // Anzahl groer Asteroiden
	unsigned int nmidasteroid;		 // Anzahl mittlerer Asteroiden
	unsigned int nsmallasteroid;	  // Anzahl kleiner Asteroiden
	unsigned int nshots;				 // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	unsigned int nexplosions;		  // Anzahl Explosionen
	Explosion explosions[2*MAX_SHOTS];
	unsigned int t;			// Anzahl Durchlufe
	unsigned int frameno;	// aktuelle Framezahl; ohne Frameverlust == t
	unsigned int score;	  // erreichte Punktzahl
	unsigned int lifes;	  // noch zur Verfgung stehende Leben
	unsigned int level;	  // aktuell gespieltes Level
	
	ObjectManager m_objects;
	ObjectManager m_shots;

	GameStatus (void);
	void clear(void);
	//void Update(ObjectManager* objmgr);
	void Update(ObjectManager* mgr, ObjectManager* objmgr);
	void Kometenanzeige(ObjectManager* objm, ObjectManager* shotm, Saucer* saucer, Ship* ship);
};

const char* ToString (GameStatus::State st);
const char* ToString (GameStatus::Event e);

#endif // _GAMESTATUS_H
