// asteroid.cpp: Beispielspieler fr Asteroids
// Matthias Fuchs
// Original: Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>

#include "output.h"
#include "connection.h"
#include "game.h"
#include "exampleplayer.h"


int main(int argc, const char* argv[])
{

#ifdef _DEBUG
	OutputDebug2
		("LittleEndian: %s", Connection::IsLittleEndian() ? "Ja" : "Nein");
#endif

	unsigned int numofgames = ~0;
	unsigned int iparg = 0;

	// Parameter parsen
	if (argc > 1)
	{  // mind. ein Parameter
		if (argc > 2)
		{
			if ((argv[2][0] == '-' || argv[2][0] == '/') && argv[2][1] == 'n')
			{  // Option gefunden
				numofgames = atoi ((argv[2])+2);
				iparg = 1;
			}
		}
		else
		{
			if ((argv[1][0] == '-' || argv[1][0] == '/') && argv[1][1] == 'n')
			{  // Option gefunden
				numofgames = atoi ((argv[1])+2);
			}
			else
				iparg = 1;
		}
		if (argc > 3 ||
			(argv[1][0] == '-' || argv[1][0] == '/')
			&& (argv[1][1] == '?' || argv[1][1] == 'h'))
		{  // Bildschirm zur Verwendung anzeigen
			fprintf(stderr, "Aufruf: asteroid <IP-Adresse> /n[Anzahl]\n");
			return 1;
		}
	}
	const char* ip = iparg > 0 ? argv[iparg] : "127.0.0.1";
#ifdef _DEBUG
	OutputDebug2 ("Parameter: ip = %s, Anzahl = %u", ip, numofgames);
#endif

	try
	{
		Connection con(ip);

		ExamplePlayer player;

		Game game(con, &player);
		for (unsigned int i = 0; i < numofgames; ++i)
			game.Run();
	}
	catch (connection_error &ce)
	{
		OutputError(ce.what());
	}
	catch (...)
	{
		OutputError("Unerwarteter Fehler.");
	}

	return 0;
}
