/******************************************************************************
* vector2.h
******************************************************************************/

#ifndef VECTOR2_H
#define VECTOR2_H

#include "math.h"

//****************************************************************************//
// Forward declarations
//****************************************************************************//

class Matrix22;

typedef float VecFloat;

static const double Pi_double = 3.1415926535897932384626433832795;

//****************************************************************************//
// Class declaration
//****************************************************************************//

/*****************************************************************************/
/** The vector class.
*****************************************************************************/

class Vector2
{
  // member variables
public:
  VecFloat x;
  VecFloat y;

  // constructors/destructor
public:
  inline Vector2();
  inline Vector2(const Vector2& v);
  inline Vector2(VecFloat vx, VecFloat vy);
  inline ~Vector2();

  // member functions
public:
  inline void add(const Matrix22& a, const Matrix22& b, const Vector2& f);		// MG plasticity
  inline void blend(VecFloat d, const Vector2& v);
  inline void clear();
  inline VecFloat cross(Vector2& v);
  inline void invert();
  inline VecFloat length() const;
  inline VecFloat length2() const;
  inline void multiply(const Matrix22& a);
  inline void negate();
  inline VecFloat normalize();
  inline VecFloat phase();
  inline Vector2 projectOn(const Vector2& direction);
  inline void rotate(VecFloat alpha);
  inline void scale(const Vector2& f);
  inline void square();
  //substract the product of a*b*f from the vector instance. 
  inline void subtract(const Matrix22& a, const Matrix22& b, const Vector2& f);
  inline VecFloat vectorAngle(Vector2* a); 
  inline void operator-=(const Vector2& v);
  inline void operator%=(const Vector2& v);
  inline Vector2 operator%(const Vector2& v);
  inline VecFloat operator*(const Vector2& v);
  inline void operator*=(const VecFloat d);
  inline void operator/=(const VecFloat d);
  inline VecFloat& operator[](unsigned int i);
  inline const VecFloat& operator[](unsigned int i) const;
  inline void operator+=(const Vector2& v);
  inline void operator=(const Vector2& v);
  inline bool operator==(const Vector2& v);
	inline bool operator<(const Vector2& v);
  inline void set(VecFloat vx, VecFloat vy);
  friend inline Vector2 operator-(const Vector2 &v1, const Vector2 &v2);
  inline Vector2 operator-() const;
  friend inline Vector2 operator%(const Vector2 &v1, const Vector2 &v2);
  friend inline Vector2 operator*(const Vector2 &v, const VecFloat d);
  friend inline VecFloat operator*(const Vector2 &v1, const Vector2 &v2);
  friend inline Vector2 operator/(const Vector2 &v, const VecFloat d);
  friend inline Vector2 operator+(const Vector2 &v1, const Vector2 &v2);

  friend inline Matrix22 tensor(const Vector2 &v1, const Vector2 &v2);

  //inline Vector2 projectOn(const Vector2& direction);

	

};

// include the inline functions
#include "matrix.h"
#include "matrix22.h"
#include "vector2.inl"

#endif

//****************************************************************************//
