// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
// Changed by David Schulz, 30.06.2008

#if defined(WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;
static const int ROTATION_VECTS[] = {0,152,296,440,584,720,856,976,1088,1192,1280,1360,1416,1472,1504,1528,1536};
static const int NROT_VECTS = 17;

class Vector
{
public:
	Vector(int x, int y);
	int x;
	int y;
	void set(int x, int y);
};

class Asteroid
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int type; // 1 ... 4, outer form
	int sf;   // scale factor: 0 = big, 15 = mid, 14 = small

	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;

	void set(int x, int y);
};

class MovingObject
{
public:
	MovingObject();
	
	int x;    // Position des Objekts
	int y;
	int x_all;    // Bewegung gesamt
	int y_all;
	float dx;    // Bewegung
	float dy;
	int x10;	// Summe der letzten 10 Bewegungen
	int y10;
	float dx10;    // Bewegung der letzten 10 Frames
	float dy10;
	int dx_last_10[10]; // letzte 10 Bewegungen
	int dy_last_10[10]; // letzte 10 Bewegungen
	
	int numvals; // Anzahl der Werte in der Berechnung

	void add(int x, int y, int latency);
	void copy(MovingObject from);
	void clear(void);
	int propagate_x(int interval);
	int propagate_y(int interval);
};

class MovingAsteroid : public MovingObject
{
public:
	MovingAsteroid();
	
	//only for asteroids:
	int type; // 1 ... 4, outer Form
	int sf;   // scale factor: 0 = big, 15 = mid, 14 = small

	void clear(void);
	void copy (MovingAsteroid from);
	void add(Asteroid a, int latency);
};

class MovingShot : public MovingObject
{
public:
	MovingShot();
	
	//only for shots:
	bool self_shot;
	
	void clear(void);
	void copy (MovingShot from);
	void add(Shot s, MovingObject saucer, bool saucer_present, int latency);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	int ship_last_dx;        // Blickrichtung des Schiffes
	int ship_last_dy;
	bool saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	void clear(void);
	void print(int time, char frameno);
	void print_diff(GameStatus game_b);
	GameStatus GameStatus::clone(void);
};

class GameMove
{
public:
	GameMove(void);
	
	int numvals; // count of values in calculation

	MovingObject ship;
	MovingObject saucer;
	
	MovingAsteroid asteroids[MAX_ASTEROIDS];
	MovingShot shots[MAX_SHOTS];
	
	int nasteroids; // count of asteroids
	int nshots; // count of shots
	bool reordered_asteroids;
	bool reordered_shots;

	void add(GameStatus game, int latency);
	void reorder_asteroids(GameStatus game, int latency);
	void reorder_shots(GameStatus game, int latency);
	void clear(void);
	void clear_asteroids(void);
	void clear_shots(void);
	void print(void);
	void print_future(GameStatus game, int interval);
};

class Distance
{
private:
	int dist;
	int dx;
	int dy;
	
public:
	Distance(int x1, int y1, int x2, int y2);
	void correct_distance (int length);
	int get_distance (void);
	int get_dx (void);
	int get_dy (void);
};

class DistStraightPoint
//calculates the distance between a straight line and a point
{
private:
	int dist; //distance between straight and point
	int k; //factor to multiply the direction vector of the straight to get to point q
	       //q is the point on the straight closest to p
	
public:
	DistStraightPoint(Vector p, MovingObject o);
	int get_asteroid_distance(MovingAsteroid a);
	int get_distance (void);
	int get_k (void);
};

	
#pragma pack(1)
struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-Byte zurck
};

class KeysPacket
{
private:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char signature[6];
	char keys;
public:
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
};
#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	int get_distance(int x1, int y1, int x2, int y2);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
	int get_index(int);
};
