﻿using System;
using System.Collections.Generic;
using System.Reflection;
using System.IO;

namespace PlayerLogic
{
    public class BehaviourManager
    {
        private readonly SortedDictionary<string, Type> behaviourMap = new SortedDictionary<string,Type>();

        public BehaviourManager()
        {
            List<Assembly> assemblies = new List<Assembly>();
            assemblies.Add(Assembly.GetEntryAssembly());

            string loc = Assembly.GetEntryAssembly().Location;

            DirectoryInfo di = new DirectoryInfo(Path.GetDirectoryName(loc));
            FileInfo[] fis = di.GetFiles("*.dll");
            foreach (FileInfo fi in fis)
                assemblies.Add(Assembly.LoadFile(fi.FullName));

            List<Type> Classes = new List<Type>();
            foreach (Assembly ass in assemblies)
            {
                Classes.AddRange(ass.GetTypes());
            }

            foreach (Type Class in Classes)
            {
                BehaviourAttribute[] behaviorAttributes = (BehaviourAttribute[])Class.GetCustomAttributes(typeof(BehaviourAttribute), false);
                foreach (BehaviourAttribute attribute in behaviorAttributes)
                {
                    behaviourMap.Add(attribute.Name, Class);
                }
            }
        }

        public string[] BehaviourNames
        {
            get
            {
                string[] names = new string[behaviourMap.Count];
                int i = 0;
                foreach (KeyValuePair<string, Type> behaviour in behaviourMap)
                {
                    names[i++] = behaviour.Key;
                }
                return names;
            }
        }
        public Behaviour CreateBehaviour(string name)
        {
            if (behaviourMap.ContainsKey(name))
            {
                Type type = behaviourMap[name];
                return Activator.CreateInstance(type) as Behaviour;
            }
            return null;
        }
    }
}
