package de.curdreinert.asteroids.screenobject;

import de.curdreinert.asteroids.geometry.Approximation;
import de.curdreinert.asteroids.geometry.Vector;
import de.curdreinert.asteroids.geometry.Position;

public abstract class ScreenObject {

	private Position position;

	private Vector movement = null;

	public ScreenObject(int x, int y) {
		position = new Position(x, y);
	}

	public Vector calculateDirection(Position oldPosition) {
		return calculateDirection(oldPosition, 1);
	}

	public Vector calculateDirection(Position oldPosition, int frames) {
		movement = new Vector(oldPosition, this.position, frames);
		return movement;
	}

	public Position getPosition() {
		return position;
	}

	public Vector getMovement() {
		return movement;
	}

	public abstract String getName();

	public String toString() {
		return getName()
				+ " at "
				+ position
				+ (movement != null && movement.getLength() > 0 ? " moving to "
						+ movement
						: "");
	}

	public double distance(ScreenObject other) {
		return position.distance(other.position);
	}

	public Position[] getTrajectory(int frames) {
		Position[] result = new Position[frames];
		for (int i = 0; i < frames; i++) {
			result[i] = movement == null ? position : position.add(movement, i);
		}
		return result;
	}

	public Approximation[] getApproximation(ScreenObject other, int frames) {
		Approximation[] result = new Approximation[frames];
		Position[] myTrajectory = getTrajectory(frames);
		Position[] otherTrajectory = other.getTrajectory(frames);
		for (int i = 0; i < frames; i++) {
			result[i] = new Approximation(i, myTrajectory[i],
					otherTrajectory[i]);
		}
		return result;
	}

	public Position nextPosition() {
		return getTrajectory(2)[1];
	}

}
