package de.curdreinert.asteroids.display;

import de.curdreinert.asteroids.intelligence.Analysis;

public class DisplayThread extends Thread {

	private Display display;

	private Analysis analysis;

	public DisplayThread(Display display) {
		super("DisplayThread");
		this.display = display;
	}

	public void run() {
		while (true) {
			try {
				Analysis analysis = consumeAnalysis();
				if (analysis != null) {
					display.display(analysis);
				} else {
					Thread.sleep(5);
				}
			} catch (InterruptedException e) {
				// so what
			}
		}
	}

	private synchronized Analysis consumeAnalysis() {
		Analysis result = analysis;
		analysis = null;
		return result;
	}

	public synchronized void setAnalysis(Analysis analysis) {
		this.analysis = analysis;
	}

}
