package de.curdreinert.asteroids.base;

public class Size implements Comparable<Size> {

	private String description;

	private int value;

	public static final Size SMALL = new Size(0, "small");

	public static final Size MEDIUM = new Size(1, "medium");

	public static final Size LARGE = new Size(2, "large");

	private Size(int value, String description) {
		this.value = value;
		this.description = description;
	}

	public String toString() {
		return description;
	}

	public static Size forAsteroid(int size) {
		switch (size) {
		case 14:
			return SMALL;

		case 15:
			return MEDIUM;

		case 0:
			return LARGE;
		}
		throw new RuntimeException("Unknown size " + size);
	}

	public static Size forSaucer(int size) {
		switch (size) {
		case 14:
			return SMALL;

		case 15:
			return LARGE;
		}
		throw new RuntimeException("Unknown size " + size);
	}

	public int compareTo(Size other) {
		return value - other.value;
	}

}
