unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, IdBaseComponent, IdComponent, IdUDPBase, IdUDPClient,
  StdCtrls, Math, RealTimeCounter;

const MAX_OBJECTS=33;

type
  TSpaceObject = record
    birthframe: Cardinal;
    updated: Boolean;
    X,Y: Integer;
    firstX,firstY: Integer;
    Vx,Vy: Integer;
    objType: Byte;
    accuracy: Byte;
    lID: ShortInt;
    objID: Cardinal;
    ttl: Word;
  end;
  TShip = record
    X,Y: Integer;
    Vx,Vy: Integer;
    angle: Byte;
    sure: Boolean;
  end;
  TGameStatus = record
    gameRunning: Boolean;
    Score: Cardinal;
    pressStart: Boolean;
    enterHighscore: Byte;
    player1: Boolean;
    darkness: Boolean;
    shotsonair: Byte;
    collision: Boolean;
  end;
  TKeyState = record
    hyper,fire,thrust,right,left,start: Boolean;
  end;
  TKeyPress = record
    frame: Cardinal;
    keys: TKeyState;
  end;
  TGameField = record
    interpolated: Boolean;
    KeyState: TKeyState;
    status: TGameStatus;
    ship: TShip;
    objects: Array [0..MAX_OBJECTS-1] of TSpaceObject;
  end;
  THitStruct = record
    turn: ShortInt; //negativ ist Rechts-, positiv ist Linksdrehung
    shootFrame: Cardinal;
    flyingtime: Byte;
    objID: Cardinal;
    objType: Byte;
  end;
  TForm1 = class(TForm)
    ImgDisplay: TImage;
    cs: TIdUDPClient;
    BtnReceive: TButton;
    Shape1: TShape;
    MmoLog: TMemo;
    CBoxDisplay: TCheckBox;
    LblScore: TLabel;
    LblFrameNo: TLabel;
    TimerStart: TTimer;
    LblLevel: TLabel;
    LblOffset: TLabel;
    procedure displayField(RAM: Pointer);
    procedure displayVectors(gf: TGameField);
    procedure insertObject(objType: Byte;X,Y: Integer;var lgf,gf: TGameField);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BtnReceiveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure setFrameNo(frameID,pingByte: Byte);
    procedure receiveProc();
    procedure normalizeObject(x,y,xcenter,ycenter: Integer;out xn,yn: Integer);
    function distance(x1,y1,x2,y2: Integer): Extended;
    function distanceSqr(x1,y1,x2,y2: Integer): Integer;
    procedure setNewAngle(frame: Cardinal);
    procedure KI();
    procedure TimerStartTimer(Sender: TObject);
    function CheckCollision(X,Y,X1,Y1: Integer;objType: Byte;withShip: Boolean): Boolean;
    function isNewLevel(frame: Cardinal): Boolean;
    procedure ClearActions();
    procedure AddAction(key: Byte;press,release: Cardinal;overrPressKeys: Byte=255;overrRelKeys: Byte=255);
    function KeyStateToByte(keys: TKeyState): Byte;
    function fastestHit(frame: Cardinal;angle: Byte;shootAfter: Byte;depth: Byte=43): THitStruct;
    function CanShootObj(frame: Cardinal;angle: Byte;objNo: Byte;out flyingtime: Byte): Boolean;
  private
    { Private-Deklarationen }
    ROM: Pointer;
    sa: Array [0..255] of Array [0..3] of ShortInt;
    game: Array of TGameField;
    gameLength: Cardinal;
    frameNo: Cardinal;
    stopRec: Boolean;
    highestObjID: Cardinal;
    frameOffset: ShortInt;
    procedure interpolate(frame: Cardinal;length: Word); overload;
    function interpolate(frame: Cardinal;length: Word;var timetoCollision: Cardinal): ShortInt; overload;
    function submitPacket(): Boolean; overload;
    function submitPacket(keys: TKeyState): Boolean; overload;
    function CanShootNow(frame: Cardinal;overrideAngle: Boolean=false;angle: Byte=0): Boolean; overload;
    function CanShootNow(frame: Cardinal;out objectID: Cardinal;out flyingtime: Word;overrideAngle: Boolean=false;angle: Byte=0): Boolean; overload;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  keypresses: Array [0..63] of TKeyPress;
  nextCalc: Cardinal;

function CreateKeyState(keyByte: Byte): TKeyState; overload;
function CreateKeyState(hyper,fire,thrust,right,left,start: Boolean): TKeyState; overload;

implementation

{$R *.dfm}

function TForm1.CheckCollision(X,Y,X1,Y1: Integer;objType: Byte;withShip: Boolean): Boolean;
var
  dx,dy: Integer;
  radius: Byte;
begin
  Result:=false;
  dx:=Abs(X-X1)*4;
  dy:=Abs(Y-Y1)*4;
  radius:=0;
  case objType of
    1: radius:=42; //kl Ast
    2: radius:=72; //mi Ast
    3: radius:=132;//gr Ast
    4: radius:=40; //kl UFO
    5: radius:=66;//gr UFO
  end;
  if withShip then
    inc(radius,46);//halber Schiffsradius

  if not ((dx>radius) or
          (dy>radius) or
          (dx+dy>radius+radius div 2)) then Result:=true;
end;

procedure TForm1.normalizeObject(x,y,xcenter,ycenter: Integer;out xn,yn: Integer);
begin
  xn:=(x-xcenter+1536) mod 1024;
  yn:=(y-ycenter+1152) mod 768+128;
end;

function TForm1.distance(x1,y1,x2,y2: Integer): Extended;
begin
  Result:=sqrt(sqr(x1-x2)+sqr(y1-y2));
end;

function TForm1.distanceSqr(x1,y1,x2,y2: Integer): Integer;
begin
  Result:=sqr(x1-x2)+sqr(y1-y2);
end;

function CreateKeyState(keyByte: Byte): TKeyState;
begin
  Result.hyper :=($01 and keyByte)<>0;
  Result.fire  :=($02 and keyByte)<>0;
  Result.thrust:=($04 and keyByte)<>0;
  Result.right :=($08 and keyByte)<>0;
  Result.left  :=($10 and keyByte)<>0;
  Result.start :=($20 and keyByte)<>0;
end;

function CreateKeyState(hyper,fire,thrust,right,left,start: Boolean): TKeyState;
begin
  Result.hyper:=hyper;
  Result.fire:=fire;
  Result.thrust:=thrust;
  Result.right:=right;
  Result.left:=left;
  Result.start:=start;
end;

procedure TForm1.insertObject(objType: Byte;X,Y: Integer;var lgf,gf: TGameField);
var
  i,j,newAngle: Integer;
  xn,yn: Integer;
  found: Boolean;
  adjAngle: Cardinal;
begin
  //1,2,3: kl,mit,gr Asteroid
  //4,5: kl,gr UFO
  //6: Schuss
  i:=0;
  while (i<MAX_OBJECTS) and (gf.objects[i].objType<>0) do
    inc(i);
  if i=MAX_OBJECTS then begin
    MmoLog.Lines.Add('Too many objects in space.');
    Exit;
  end;

  found:=false;
  //finde das Objekt
  for j:=0 to MAX_OBJECTS-1 do begin
    if ((lgf.objects[j].objType=objType) or
       ((objType=6) and (lgf.objects[j].objType=7))) and
       (not lgf.objects[j].updated) then begin
      normalizeObject(X,Y,lgf.objects[j].X,lgf.objects[j].Y,xn,yn);
      dec(xn,512);
      dec(yn,512);
      if (lgf.objects[j].accuracy>0) then begin
        dec(xn,lgf.objects[j].Vx div lgf.objects[j].accuracy);
        dec(yn,lgf.objects[j].Vy div lgf.objects[j].accuracy);
      end;
      xn:=Abs(xn);
      yn:=Abs(yn);
      if ((xn<=1) and (yn<=1)) or  //vorausberechnet
         (lgf.interpolated and (xn<=3) and (yn<=3)) or //vorausberechnet, letzter Frame interpoliert
         ((lgf.objects[j].accuracy=0) and (distanceSqr(xn,yn,0,0)<144)) then begin //frisches Objekt, max 12 Pixel entfernt
        found:=true;
        gf.objects[i]:=lgf.objects[j];
        lgf.objects[j].updated:=true;
        gf.objects[i].lID:=j;
        gf.objects[i].X:=X;
        gf.objects[i].Y:=Y;
        if (gf.objects[i].ttl>0) then dec(gf.objects[i].ttl);
        if (gf.objects[i].accuracy<8) then begin
          gf.objects[i].accuracy:=frameNo-gf.objects[i].birthframe;
          normalizeObject(X,Y,gf.objects[i].firstX,gf.objects[i].firstY,xn,yn);
          gf.objects[i].Vx:=xn-512;
          gf.objects[i].Vy:=yn-512;
        end;

        if (gf.objects[i].objType=7) then
          inc(gf.Status.shotsonair);

        //synchronisiere Winkelbyte
        if (gf.objects[i].objType=7) and (frameNo-gf.objects[i].birthframe=8) then begin
          with gf.objects[i] do begin
            normalizeObject(X,Y,firstX,firstY,xn,yn);
            dec(xn,512);
            dec(yn,512);
            for newAngle:=0 to 255 do begin
              if (xn=sa[newAngle][0]) and (yn=sa[newAngle][1]) then begin
                game[frameNo-10].ship.sure:=true;
                if (newAngle<>game[frameNo-10].ship.angle) then begin
                  MmoLog.Lines.Add(Format('%u: synch (%u, %d)',
                    [frameNo,newAngle,newAngle-game[frameNo-10].ship.angle]));
                  game[frameNo-10].ship.angle:=newAngle;
                  for adjAngle:=frameNo-9 to frameNo-1 do
                    setNewAngle(adjAngle);
                end;
                break;
              end;
            end;
          end;
        end;
        break;
      end;
    end;
  end;


  //fuege neues Objekt hinzu
  if not found then begin
    inc(highestObjID);
    gf.objects[i].X:=X;
    gf.objects[i].Y:=Y;
    gf.objects[i].objType:=objType;
    gf.objects[i].lID:=-1;
    with gf.objects[i] do begin
      birthframe:=frameNo;
      updated:=false;
      firstX:=X;
      firstY:=Y;
      Vx:=0;
      Vy:=0;
      accuracy:=0;
      objID:=highestObjID;
      ttl:=0;
    end;

    if (objType=6) and (distanceSqr(X,Y,lgf.ship.X,lgf.ship.Y)<484) then begin //eigener Schuss?
      gf.objects[i].objType:=7;
      inc(gf.Status.shotsonair);
    end;

    //if frameNo>1 then
    //  MmoLog.Lines.Add(Format('%u: New object (%d)',[frameNo,gf.objects[i].objType]));
  end;
end;

procedure TForm1.displayVectors(gf: TGameField);
var
  oldBrush: TBrush;
  oldPen: TPen;
  actColor: TColor;
  i: Integer;
begin
  oldBrush:=ImgDisplay.Canvas.Brush;
  oldPen:=ImgDisplay.Canvas.Pen;

  for i:=0 to MAX_OBJECTS-1 do begin
    if (gf.objects[i].objType in [1..7]) and (gf.objects[i].accuracy>0) then begin
      case gf.objects[i].objType of
        4,5: actColor:=clYellow;
        6:   actColor:=clBlue;
        7:   actColor:=clGreen;
        else actColor:=clRed;
      end;
      with ImgDisplay.Canvas do begin
        Pen.Color:=actColor;
        MoveTo(gf.objects[i].X div 2,ImgDisplay.Height-gf.objects[i].Y div 2);
        LineTo(Round((gf.objects[i].X+(gf.objects[i].Vx / gf.objects[i].accuracy)*60)/2),
               ImgDisplay.Height-Round((gf.objects[i].Y+(gf.objects[i].Vy / gf.objects[i].accuracy)*60)/2));
      end;
    end;
  end;

  ImgDisplay.Canvas.Brush:=oldBrush;
  ImgDisplay.Canvas.Pen:=oldPen;
end;

function TForm1.submitPacket(): Boolean;
begin
  Result:=submitPacket(CreateKeyState(false,false,false,false,false,false));
end;

function TForm1.submitPacket(keys: TKeyState): Boolean; 
var
  sendBuf: Pointer;
  actKeys: Byte;
begin
  Result:=false;

  actKeys:=KeyStateToByte(keys);

  GetMem(sendBuf,8);
  FillMemory(sendBuf,8,0);
  StrCopy(PChar(sendBuf),'ctmame');
  PByte(Cardinal(sendBuf)+6)^:=actKeys;
  PByte(Cardinal(sendBuf)+7)^:=actKeys or $80;
  cs.SendBuffer(sendBuf^,8);
  FreeMem(sendBuf);
end;

procedure TForm1.displayField(RAM: Pointer);
var
  el,eh: PByte;
  ex: PWord;
  addr: Word;
  beamPos,lastLABS: TPoint;
  GSF: Byte;
  Stack: Array [0..3] of Cardinal;
  StackLevel: Byte;
  x,y: SmallInt;
  xs,ys: Boolean;
  scale: Word;
  brightness: Byte;
  actColor: TColor;

  buf: Byte;
  tmpScore: Cardinal;
  c: Char;
  start: String;
begin
  if CBoxDisplay.Checked then begin
    with ImgDisplay.Canvas do begin
      Pen.Color:=clBlack;
      Brush.Color:=clBlack;
      Rectangle(0,0,512,512);
    end;
  end;

  game[frameNo].ship.X:=0;
  game[frameNo].ship.Y:=0;
  game[frameNo].ship.Vx:=0;
  game[frameNo].ship.Vy:=0;
  game[frameNo].ship.sure:=false;

  game[frameNo].Status.Score:=0;
  game[frameNo].Status.pressStart:=false;
  game[frameNo].Status.enterHighscore:=0;
  game[frameNo].Status.player1:=false;
  game[frameNo].Status.shotsonair:=0;
  tmpScore:=0;

  game[frameNo].interpolated:=false;

  ex:=RAM;
  StackLevel:=0;
  beamPos:=Point(0,0);
  GSF:=0;
  while (Cardinal(ex)>=Cardinal(RAM)) and (Cardinal(ex)<Cardinal(RAM)+1024) or
        (Cardinal(ex)>=Cardinal(ROM)) and (Cardinal(ex)<Cardinal(ROM)+2048) do begin
    eh:=Pointer(Cardinal(ex)+1);
    el:=Pointer(Cardinal(ex));


    if (eh^ and $F0)=$E0 then begin //JMPL
      addr:=ex^ and $FFF;
      if (addr>=$800) then begin //Adresse liegt im ROM
        dec(addr,$800);
        ex:=Pointer(Cardinal(ROM)+addr*2);
      end else begin
        if (addr>$200) then dec(addr,$200); //Adresse im 2. KB
        ex:=Pointer(Cardinal(RAM)+addr*2);
      end;
      continue;
    end else


    if (eh^ and $F0)=$C0 then begin //JSRL
      if StackLevel=4 then begin
        MmoLog.Lines.Add('Stack overflow.');
        Exit;
      end;
      inc(StackLevel);
      Stack[StackLevel-1]:=Cardinal(ex)+2;

      addr:=ex^ and $FFF;
      if (addr>=$800) then begin //Adresse liegt im ROM
        dec(addr,$800);
        ex:=Pointer(Cardinal(ROM)+addr*2);

        case addr of
          $F3,$FF,$10D,$11A: //Asteroiden
            begin
              if frameNo>0 then begin
                case GSF of
                  14: insertObject(1,beamPos.X,beamPos.Y,game[frameNo-1],game[frameNo]);
                  15: insertObject(2,beamPos.X,beamPos.Y,game[frameNo-1],game[frameNo]);
                  0:  insertObject(3,beamPos.X,beamPos.Y,game[frameNo-1],game[frameNo]);
                end;
              end;
            end;
          $129: //UFOs
            begin
              if frameNo>0 then begin
                case GSF of
                  14: insertObject(4,beamPos.X,beamPos.Y,game[frameNo-1],game[frameNo]);
                  15: insertObject(5,beamPos.X,beamPos.Y,game[frameNo-1],game[frameNo]);
                end;
              end;
            end;
          else
          if beamPos.Y=876 then begin
            buf:=0;
            case (addr+$800) of
              $ADD: buf:=0;
              $B2E: buf:=1;
              $B32: buf:=2;
              $B3A: buf:=3;
              $B41: buf:=4;
              $B48: buf:=5;
              $B4F: buf:=6;
              $B56: buf:=7;
              $B5B: buf:=8;
              $B63: buf:=9;
            end;
            case beamPos.X of
              100: inc(tmpScore,buf*10000);
              124: inc(tmpScore,buf*1000);
              148: inc(tmpScore,buf*100);
              172: inc(tmpScore,buf*10);
              196: inc(tmpScore,buf);
            end;
            if (beamPos.X=196) and ((game[frameNo].Status.Score mod 100000)>=99000) and (tmpScore<game[frameNo].Status.Score) then begin
              inc(tmpScore,ceil(game[frameNo].Status.Score / 100000)*100000);
            end;
            LblScore.Caption:='Score: '+IntToStr(tmpScore);
            game[frameNo].Status.Score:=tmpScore;
          end else begin
            c:=#0;
            if (beamPos.Y=648) or (beamPos.Y=792) or (beamPos.Y=728) then begin
              case (addr+$800) of
                $A78: c:='A';
                $A80: c:='B';
                $A8D: c:='C';
                $A93: c:='D';
                $A9B: c:='E';
                $AA3: c:='F';
                $AAA: c:='G';
                $AB3: c:='H';
                $ABA: c:='I';
                $AC1: c:='J';
                $AC7: c:='K';
                $ACD: c:='L';
                $AD2: c:='M';
                $AD8: c:='N';
                $ADD: c:='0';
                $AE3: c:='P';
                $AEA: c:='Q';
                $AF3: c:='R';
                $AFB: c:='S';
                $B02: c:='T';
                $B08: c:='U';
                $B0E: c:='V';
                $B13: c:='W';
                $B1A: c:='X';
                $B1F: c:='Y';
                $B26: c:='Z';
                $B2C: c:=' ';
                $B2E: c:='1';
                $B32: c:='2';
                $B3A: c:='3';
                $B41: c:='4';
                $B48: c:='5';
                $B4F: c:='6';
                $B56: c:='7';
                $B5B: c:='8';
                $B63: c:='9';
              end;
              if c<>#0 then
                start:=start+c;
            end;
            if start='STARTKN0EPFE DRUECKEN' then begin
              game[frameNo].Status.pressStart:=true;
            end else
            if start='SPIELER 1' then begin
              game[frameNo].Status.player1:=true;
            end else
            if (start='BITTE GEBEN SIE IHRE INITIALEN EIN') then begin
              game[frameNo].Status.enterHighscore:=1;
              game[frameNo].Status.pressStart:=true;
            end;
          end;
        end;
      end else begin
        if (addr>$200) then dec(addr,$200); //Adresse im 2. KB
        ex:=Pointer(Cardinal(RAM)+addr*2);
      end;
      continue;
    end else


    if (eh^ and $F0)=$D0 then begin //RTSL
      if StackLevel=0 then begin
        MmoLog.Lines.Add('Stack is empty.');
        Exit;
      end;

      dec(StackLevel);
      ex:=Pointer(Stack[StackLevel]);
      continue;
    end else


    if (eh^ and $F0)=$B0 then begin //HALT
      Exit;
    end else


    if (eh^ and $F0)=$A0 then begin //LABS
      y:=(ex^ and $3FF);
      ex:=Pointer(Cardinal(ex)+2);
      eh:=Pointer(Cardinal(ex)+1);
      x:=(ex^ and $3FF);
      GSF:=eh^ shr 4;
      beamPos:=Point(x,y);
      lastLABS:=beamPos;
    end else


    if (eh^ and $F0)=$F0 then begin //SVEC
      x:=(el^ and $3) shl 8;
      y:=(eh^ and $3) shl 8;
      xs:=el^ and $4<>0;
      ys:=eh^ and $4<>0;
      scale:=(eh^ and $8 shr 3) or (el^ and $8 shr 2);
      case (GSF+scale) and $F of
        3: scale:=16;
        2: scale:=32;
        1: scale:=64;
        0: scale:=128;
        else scale:=1;
      end;

      brightness:=el^ and $F0 shr 4;

      if xs then x:=x*-1;
      if ys then y:=y*-1;

      if CBoxDisplay.Checked then begin
        with ImgDisplay.Canvas do begin
          actColor:=RGB(brightness shl 4+$F,brightness shl 4+$F,brightness shl 4+$F);
          Pen.Color:=actColor;
          MoveTo(beamPos.X div 2,ImgDisplay.Height-beamPos.Y div 2);
          if brightness>0 then begin
            LineTo((beamPos.X+x div scale) div 2,
                   ImgDisplay.Height-(beamPos.Y+y div scale) div 2);
            Pixels[(beamPos.X+x div scale) div 2,
                   ImgDisplay.Height-(beamPos.Y+y div scale) div 2]:=actColor;
          end;
        end;
      end;
      beamPos:=Point(beamPos.X+x div scale,beamPos.Y+y div scale);
    end else


    if (eh^ and $F0)<$A0 then begin //VCTR
      y:=ex^ and $3FF;
      ys:=eh^ and $4<>0;

      scale:=(eh^ and $F0) shr 4;
      case (GSF+scale) and $F of
        9: scale:=1;
        8: scale:=2;
        7: scale:=4;
        6: scale:=8;
        5: scale:=16;
        4: scale:=32;
        3: scale:=64;
        2: scale:=128;
        1: scale:=256;
        0: scale:=512;
        else scale:=1;
      end;

      ex:=Pointer(Cardinal(ex)+2);
      eh:=Pointer(Cardinal(ex)+1);

      x:=ex^ and $3FF;
      xs:=eh^ and $4<>0;

      brightness:=(eh^ and $F0) shr 4;
      actColor:=RGB(brightness shl 4+$F,brightness shl 4+$F,brightness shl 4+$F);

      with ImgDisplay.Canvas do begin
        if (brightness=12) and (scale=32) then begin
          if game[frameNo].ship.X=0 then begin
            game[frameNo].ship.X:=lastLABS.X;
            game[frameNo].ship.Y:=lastLABS.Y;
          end;
        end;
        if xs then x:=x*-1;
        if ys then y:=y*-1;
        if CBoxDisplay.Checked then begin
          Pen.Color:=actColor;
          MoveTo(beamPos.X div 2,ImgDisplay.Height-beamPos.Y div 2);
          if brightness>0 then begin
            LineTo((beamPos.X+x div scale) div 2,
                   ImgDisplay.Height-(beamPos.Y+y div scale) div 2);
            Pixels[(beamPos.X+x div scale) div 2,
                   ImgDisplay.Height-(beamPos.Y+y div scale) div 2]:=actColor;
          end;
        end;
        beamPos:=Point(beamPos.X+x div scale,
                       beamPos.Y+y div scale);
      end;

      if (x=0) and (y=0) and (brightness=15) and (frameNo>0) then begin //Schuss
        insertObject(6,beamPos.X,beamPos.Y,game[frameNo-1],game[frameNo]);
      end;
    end;

    ex:=Pointer(Cardinal(ex)+2);
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FreeMem(ROM);
end;

procedure TForm1.BtnReceiveClick(Sender: TObject);
begin
  stopRec:=not stopRec;
  if stopRec then begin
    cs.Active:=true;
    Shape1.Brush.Color:=clRed;
  end else begin
    cs.Active:=true;
    Shape1.Brush.Color:=clGreen;
    game[frameNo].Status.gameRunning:=false;

    submitPacket();

    receiveProc();
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  fh,bytesRead: Cardinal;
begin
  frameNo:=0;
  //normales Spiel dauert 5 Minuten = 18000 frames
  gameLength:=18000;
  SetLength(game,gameLength);
  FillMemory(@(game[0]),SizeOf(game[0]),0);
  FillMemory(@(keypresses[0]),64*SizeOf(TKeyPress),0);

  Form1.DoubleBuffered:=true;
  stopRec:=true;

  GetMem(ROM,2048);
  fh:=CreateFile('035127.02',GENERIC_READ,0,nil,OPEN_EXISTING,0,0);
  if fh=INVALID_HANDLE_VALUE then begin
    MessageBox(Handle,PChar('Can''t open ROM.'#13#10'Copy file ''035127.02'' into program directory.'),'Error',MB_ICONERROR or MB_OK);
    Application.Terminate;
  end;

  if not ReadFile(fh,ROM^,2048,bytesRead,nil) or (bytesRead<>2048) then begin
    MessageBox(Handle,PChar('ROM size invalid.'#13#10'Terminating.'),'Error',MB_ICONERROR or MB_OK);
    CloseHandle(fh);
    Application.Terminate;
  end;
  CloseHandle(fh);

  fh:=CreateFile('sw.dat',GENERIC_READ,0,nil,OPEN_EXISTING,0,0);
  if fh=INVALID_HANDLE_VALUE then begin
    MessageBox(Handle,PChar('Can''t open sw.dat.'),'Error',MB_ICONERROR or MB_OK);
    Application.Terminate;
  end;

  if not ReadFile(fh,sa,SizeOf(sa),bytesRead,nil) or (bytesRead<>SizeOf(sa)) then begin
    MessageBox(Handle,PChar('sw.dat size invalid.'#13#10'Terminating.'),'Error',MB_ICONERROR or MB_OK);
    CloseHandle(fh);
    Application.Terminate;
  end;
  CloseHandle(fh);

  if ParamCount()>0 then begin
    cs.Host:=ParamStr(1);
    MmoLog.Lines.Add('Starting game in 3 seconds.');
    TimerStart.Enabled:=true;
  end;
end;

{$J+}
procedure TForm1.setFrameNo(frameID,pingByte: Byte);
const
  lastFrameID: Byte=0;
var
  gap: Byte;
begin
  if frameNo=0 then lastFrameID:=frameID-1;
  gap:=frameID-lastFrameID;

  if (frameNo+gap)>=gameLength then begin
    //verlaengere das Spiel um 1 Minute
    inc(gameLength,3600);
    SetLength(game,gameLength);
  end;

  if (gap>1) then
    interpolate(frameNo,gap-1);
  inc(frameNo,gap);
  //setze aktuelles Spielfeld auf Null
  FillMemory(@(game[frameNo]),SizeOf(game[frameNo]),0);

  if (pingByte and $80)<>0 then begin
    game[frameNo].KeyState:=CreateKeyState(pingByte and $7f);
  end else begin
    game[frameNo].KeyState:=game[frameNo-1].KeyState;
  end;

  if (gap>1) then
    MmoLog.Lines.Add(Format('%u: frameloss (%u)',[frameNo,gap-1]));

  lastFrameID:=frameID;
end;
{$J-}

procedure TForm1.interpolate(frame: Cardinal;length: Word);
var
  dummy: Cardinal;
begin
  interpolate(frame,length,dummy);
end;

function TForm1.interpolate(frame: Cardinal;length: Word;var timeToCollision: Cardinal): ShortInt;
var
  i,j,l: Word;
  xn,yn: Integer;
begin
  Result:=-1;
  if (frame+length)>=gameLength then begin
    //verlaengere das Spiel um 1 Minute
    inc(gameLength,3600);
    SetLength(game,gameLength);
  end;
  for i:=1 to length do begin
    //setze aktuelles Spielfeld auf Null
    FillMemory(@(game[frame+i]),SizeOf(game[frame+i]),0);
    //uebernehme letztes "gutes" Spielfeld
    game[frame+i]:=game[frame+i-1];
    game[frame+i].ship.sure:=false;
    game[frame+i].interpolated:=true;

    //Objekte mit der definierten Geschwindigkeit weiterbewegen
    for j:=0 to MAX_OBJECTS-1 do begin
      game[frame+i].objects[j]:=game[frame].objects[j];
      with game[frame+i].objects[j] do begin
        if objType=0 then break;
        if accuracy=0 then continue;
        normalizeObject(X+(i*Vx) div accuracy,Y+(i*Vy) div accuracy,512,512,xn,yn);
        X:=xn;
        Y:=yn;

        //abgeschossene Objekte entfernen
        for l:=0 to 5 do begin
          if (game[frame+i].objects[l].objType in [6,7]) and (objType in [1..5]) then begin
            if CheckCollision(X,Y,game[frame+i].objects[l].X,game[frame+i].objects[l].Y,objType,false) then begin
              objType:=8;
              game[frame+i].objects[l].objType:=8;
              dec(game[frame+i].status.shotsonair);
              break;
            end;
          end else
          if (game[frame+i].objects[l].objType<>8) then begin
            break;
          end;
        end;
      end;

      //Kollision mit dem Eigenschiff?
      if CheckCollision(game[frame+i].ship.X,game[frame+i].ship.Y,
          game[frame+i].objects[j].X,game[frame+i].objects[j].Y,
          game[frame+i].objects[j].objType,true) then begin
        Result:=j;
        timeToCollision:=frame+i;
        Exit;  
      end;
    end;
    //Schusswinkel weitersetzen
    SetNewAngle(frame+i);
  end;
end;

procedure TForm1.receiveProc();
var
  buf: Pointer;
  read: Integer;
  frameID,pingByte: Byte;
  Start,Stop: Int64;
  level: Byte;
  levelBegin: Cardinal;
begin
  level:=0;
  levelBegin:=0;
  
  GetMem(buf,1026);
  repeat
    read:=cs.ReceiveBuffer(buf^,1026,100);
    if read=1026 then begin
      Start:=RDTSC;
      frameID:=PByte(Cardinal(buf)+1024)^;
      pingByte:=PByte(Cardinal(buf)+1025)^;

      setFrameNo(frameID,pingByte);

      displayField(buf);
      if CBoxDisplay.Checked then
        displayVectors(game[frameNo]);
      if game[frameNo].Status.player1 or
         game[frameNo].Status.pressStart then begin
        frameNo:=0;
        level:=1;
        frameOffset:=5;
        levelBegin:=0;
        highestObjID:=0;
        nextCalc:=0;
        ClearActions();

        if game[frameNo+1].Status.pressStart then begin
          AddAction(5,6,7,0,0);
        end;
      end;

      setNewAngle(frameNo);
      if isNewLevel(frameNo) then begin
        if frameNo-levelBegin>300 then begin
          inc(level);
          AddAction(1,frameNo,frameNo+1,0,0);
        end;
        game[frameNo].status.darkness:=true;
        levelBegin:=frameNo;
      end;
      LblFrameNo.Caption:='Frame: '+IntToStr(frameNo);
      LblLevel.Caption:='Level: '+IntToStr(level);

      //uebergebe Spielfeld an KI
      if frameNo>1 then
        KI();
      Stop:=RDTSC;
      if Ticks(Stop-Start)>12 then
        MmoLog.Lines.Add('KI is too slow.');
      //MmoLog.Lines.Add(Format('%u: KI brauchte %.3f ms',[frameNo,Ticks(Stop-Start)]));
    end;
    Application.ProcessMessages;
  until stopRec;
  FreeMem(buf);
end;

procedure TForm1.setNewAngle(frame: Cardinal);
begin
  if (frame>0) then begin
    //Schuss bricht mit game[frameNo-1].angle
    //Falls links und rechts gedrueckt gilt links
    //Bei Hyperspace verschwindet Schiff einen Frame nach Empfang
    //Hyperspace + rechts/links: dreht zwischen verschwinden und auftauchen
    //  nicht -> angle aendert sich nicht, solange Schiff nicht sichtbar
    //das Gleiche gilt bei zerstoertem Schiff

    //Bedingung stimmt noch nicht 100%ig.
    //wenn Schiff in Hyperraum geht oder zerstoert wird und dann eine Taste
    //losgelassen wird, so ist das Winkelbyte einmal zu oft weiter
    //gedreht worden.
    game[frame].ship.angle:=game[frame-1].ship.angle;
    if (game[frame].ship.Y>0) and (game[frame-1].ship.Y>0) then begin
      if game[frame].KeyState.left then begin
        inc(game[frame].ship.angle,3);
      end else
      if game[frame].KeyState.right then begin
        dec(game[frame].ship.angle,3);
      end;
    end;
  end;
end;

{$J+} {
procedure TForm1.KI();
var
  i: Integer;
  collisionFrame: Cardinal;
  colObj: ShortInt;
  hit: THitStruct;

  turn,newAngle: Integer;
  turntime,waittime: Byte;
  flyingtime: Byte;
  canDefend: Boolean;
begin
  if (game[frameNo].ship.Y=0) and not (game[frameNo].KeyState.hyper) then Exit;

  colObj:=interpolate(frameNo,120,collisionFrame);

  if (colObj=-1) and (collisionFrame<>0) then collisionFrame:=0;
  if colObj<>-1 then begin
    //Alles abschieen was vor die Muendung kommt.
    //Diese Strategie nur, wenn Kollisionsobjekt naht!
    if (collisionFrame<=frameNo+3) then begin
      //rette sich wer kann!
      ClearActions();
      nextCalc:=0;
      AddAction(0,frameNo,frameNo+5,0,0);
    end else
    if (not game[frameNo-1].KeyState.fire) and
       (game[frameNo+1].status.shotsonair<3) and
       CanShootNow(frameNo) then begin
      AddAction(1,frameNo,0);
    end;

    //gegen Schuesse kann ich eh nichts tun
    if not (game[frameNo].objects[colObj].objType in [1..5]) then begin
      colObj:=-1;
    end else
    if (nextCalc<=frameNo) then begin
      canDefend:=false;
      //einmal rechts und einmal links drehen
      for i:=0 to 86 do begin
        if i mod 2=0 then begin
          turn:=-i*3 div 2;
          turntime:=i div 2;
        end else begin
          turn:=(i+1)*3 div 2;
          turntime:=(i+1) div 2;
        end;
        newAngle:=(game[frameNo].ship.angle+turn+512) mod 256;
        for waittime:=0 to 5 do begin
          if turntime+waittime+frameNo>=collisionFrame then break;
          if CanShootObj(frameNo+turntime+waittime,newAngle,colObj,flyingtime) then begin
            if turn>0 then begin
              ClearActions();
              AddAction(4,frameNo,frameNo+turntime+1,255,0);
            end else
            if turn<0 then begin
              ClearActions();
              AddAction(3,frameNo,frameNo+turntime+1,255,0);
            end else begin
              ClearActions();
            end;
            nextCalc:=frameNo+turntime+waittime-1;
            canDefend:=true;
            break;
          end;
        end;
      end;
      //verteidigen is nicht mehr...
      if not canDefend then begin
        colObj:=-1;
      end;
    end;
  end;

  //falls irgendwelche sonderbaren Tastenzustaende im Spiel sind
  if (game[frameNo-1].KeyState.fire) then
    AddAction(1,0,frameNo);
  if (game[frameNo].KeyState.hyper and game[frameNo-6].KeyState.hyper) then
    AddAction(0,0,frameNo);


  //um Offset zu finden
  if game[frameNo].status.darkness then CanShootNow(frameNo);


  //Diese Strategie nur verwenden, wenn keine Kollision droht.
  if (nextCalc<=frameNo) and (colObj=-1) and not (game[frameNo].KeyState.hyper) then begin
    if game[frameNo].KeyState.fire then begin
      hit:=fastestHit(frameNo,game[frameNo].ship.angle,2);
    end else begin
      hit:=fastestHit(frameNo,game[frameNo].ship.angle,0);
    end;

    if hit.shootFrame>0 then begin
      nextCalc:=hit.shootFrame-1;
      if hit.turn<0 then begin
        AddAction(4,0,frameNo);
        AddAction(3,frameNo,frameNo+Byte(Abs(hit.turn)),255,0);
      end else
      if hit.turn>0 then begin
        AddAction(3,0,frameNo);
        AddAction(4,frameNo,frameNo+Byte(Abs(hit.turn)),255,0);
      end else begin
        AddAction(4,0,frameNo);
        AddAction(3,0,frameNo);
      end;
      if (hit.shootframe-frameNo<5) and CanShootNow(frameNo) then begin
        nextCalc:=frameNo;
        ClearActions();
        AddAction(1,hit.shootFrame,0);
        KI();
        Exit;
      end;
    end;
  end;

  //Tastendruecke uebermitteln
  for i:=0 to 63 do begin
    if (keypresses[i].frame<=frameNo) and (keypresses[i].frame>0) then begin
      submitPacket(keypresses[i].keys);
      if keypresses[i].frame<frameNo then
        MmoLog.Lines.Add(IntToStr(frameNo)+': submitPacket() '+IntToStr(frameNo-keypresses[i].frame)+' frames too late');
      keypresses[i].frame:=0;
      keypresses[i].keys:=CreateKeyState(0);
      break;
    end;
  end;
end;  }
{$J-} 

{$J+}
//die Notfall-KI  -  leider besser als alles was ich bisher probiert habe.
procedure TForm1.KI();
var
  i: Integer;
  collisionFrame: Cardinal;
  colObj: ShortInt;
begin
  if (game[frameNo].ship.Y=0) and not (game[frameNo].KeyState.hyper) then Exit;
  colObj:=interpolate(frameNo,8,collisionFrame);

  //Alles abschieen was vor die Muendung kommt.
  if (colObj<>-1) and (collisionFrame<=frameNo+3) then begin
    AddAction(0,frameNo,frameNo+5);
  end else
  if (not game[frameNo-1].KeyState.fire) and
     (game[frameNo+1].status.shotsonair<4) and
     CanShootNow(frameNo) then begin
    AddAction(1,frameNo,0);
  end;

  //Dauerdruck auf Feuer ist nicht gewuenscht!
  if (game[frameNo-1].KeyState.fire) then
    AddAction(1,0,frameNo);
  //Hat da wer was von anhalten gesagt!?
  if (not game[frameNo].KeyState.left) then
    AddAction(4,frameNo,0);


  //Tastendruecke uebermitteln
  for i:=0 to 63 do begin
    if (keypresses[i].frame<=frameNo) and (keypresses[i].frame>0) then begin
      submitPacket(keypresses[i].keys);
      if keypresses[i].frame<frameNo then
        MmoLog.Lines.Add(IntToStr(frameNo)+': submitPacket() '+IntToStr(frameNo-keypresses[i].frame)+' frames too late');
      keypresses[i].frame:=0;
      keypresses[i].keys:=CreateKeyState(0);
      break;
    end;
  end;
end;   
{$J-}

procedure TForm1.TimerStartTimer(Sender: TObject);
begin
  TimerStart.Enabled:=false;
  BtnReceiveClick(BtnReceive);
end;

function TForm1.CanShootNow(frame: Cardinal;overrideAngle: Boolean=false;angle: Byte=0): Boolean;
var
  dummy1: Cardinal;
  dummy2: Word;
begin
  Result:=CanShootNow(frame,dummy1,dummy2,overrideAngle,angle);
end;

function TForm1.CanShootNow(frame: Cardinal;out objectID: Cardinal;out flyingtime: Word;overrideAngle: Boolean=false;angle: Byte=0): Boolean;
var
  i,ft,xn,yn: Integer;
  j: ShortInt;
  lifetime: Byte;
  overTheScreen: Byte;
begin
  if not overrideAngle then begin
    angle:=game[frame].ship.angle;
  end;
  for i:=0 to MAX_OBJECTS-1 do begin
    {if not game[frame-1].objects[i].updated and (game[frame-1].objects[i].objType<>0) then begin
      MmoLog.Lines.Add(Format('%u: Removed object (%d) age: %u',[frame-1,game[frame-1].objects[i].objType,frame-1-game[frame-1].objects[i].birthframe]));
    end;}
    if not game[frame-1].objects[i].updated and
      (game[frame-1].objects[i].objType<>0) and
      game[frame-1].status.darkness and
      (frame-game[frame-1].objects[i].birthframe>=69) then
      frameOffset:=frame mod 4;
      LblOffset.Caption:='Offset: '+IntToStr(frameOffset);
  end;
  
  Result:=false;
  ft:=0;
  if frameOffset<>5 then begin
    lifetime:=72-Cardinal(frame-Byte(frameOffset)) mod 4;
  end else begin
    lifetime:=69;
  end;
  for i:=0 to MAX_OBJECTS-1 do begin
    with game[frame].objects[i] do begin
      if (objType=0) then break;
      if (objType in [6,7]) or (accuracy=0) or (ttl>0) then continue;

      normalizeObject(Round(X+Vx/accuracy),Round(Y+Vy/accuracy),
             game[frame].ship.X+Round(sa[angle][2]/8),
             game[frame].ship.Y+Round(sa[angle][3]/8),
             xn,yn);
      for overTheScreen:=0 to 4 do begin
        case overTheScreen of
          0: begin //Mitte
               dec(xn,512);
               dec(yn,512);
             end;
          1: begin //Links
               inc(xn,1024);
             end;
          2: begin //Rechts
               dec(xn,2048);
             end;
          3: begin //Oben
               inc(xn,1024);
               inc(yn,768);
             end;
          4: begin //Unten
               dec(yn,1536);
             end;
        end;
        if (Abs(xn)>1000) or (Abs(yn)>1000) then continue;
        if (Vx/accuracy=sa[angle][0]/8) and (Vy/accuracy=sa[angle][1]/8) then continue;
        try
          ft:=Round((xn*(sa[angle][0]/8-Vx/accuracy)+yn*(sa[angle][1]/8-Vy/accuracy))/
           (sqr(Vx/accuracy-sa[angle][0]/8)+sqr(Vy/accuracy-sa[angle][1]/8)));
        except
          MmoLog.Lines.Add('Floatingpoint exception');
          continue;
        end;
        if (ft<0) or (ft>lifetime+5) or
          (distanceSqr(Round(xn+ft*Vx / accuracy),
                       Round(yn+ft*Vy / accuracy),
                       Round(ft*sa[angle][0]/8),
                       Round(ft*sa[angle][1]/8))>2500)
        then continue;
        dec(ft,6);
        for j:=0 to 10 do begin
          inc(ft);
          if ft<=0 then continue;
          if ft>lifetime then break;
          //besser waere die Funktion ohne normalisierung -> 1 Rundung weniger
          if CheckCollision(Round(xn+ft*Vx/accuracy),
                            Round(yn+ft*Vy/accuracy),
                            Round(ft*sa[angle][0]/8),
                            Round(ft*sa[angle][1]/8),
                            objType,false) then
          begin
            Result:=true;
            if not overrideAngle then begin
              ttl:=ft+1;
            end else begin
              flyingtime:=ft;
              objectID:=objID;
            end;
            {MmoLog.Lines.Add(IntToStr(frame)+': die: '+IntToStr(frame+Cardinal(ft)+1)+' '+IntToStr(game[frame].status.shotsonair));
            MmoLog.Lines.Add(Format('a(%d|%d) s(%d|%d)',
               [Round(X+(ft+1)*Vx/accuracy),
                Round(Y+(ft+1)*Vy/accuracy),
                game[frame].ship.X+Round(sa[angle][2]/8+ft*sa[angle][0]/8),
                game[frame].ship.Y+Round(sa[angle][3]/8+ft*sa[angle][1]/8)]));}
            Exit;
          end;
        end;
      end;
    end;
  end;
end;

function TForm1.CanShootObj(frame: Cardinal;angle: Byte;objNo: Byte;out flyingtime: Byte): Boolean;
var
  ft,xn,yn: Integer;
  j: ShortInt;
  lifetime: Byte;
  overTheScreen: Byte;
begin
  Result:=false;
  ft:=0;
  if frameOffset<>5 then begin
    lifetime:=72-Cardinal(frame-Byte(frameOffset)) mod 4;
  end else begin
    lifetime:=69;
  end;
  with game[frame].objects[objNo] do begin
    if (objType=0) then Exit;
    if (objType in [6,7]) or (accuracy=0) or (ttl>0) then Exit;

    normalizeObject(Round(X+Vx/accuracy),Round(Y+Vy/accuracy),
           game[frame].ship.X+Round(sa[angle][2]/8),
           game[frame].ship.Y+Round(sa[angle][3]/8),
           xn,yn);
    for overTheScreen:=0 to 4 do begin
      case overTheScreen of
        0: begin //Mitte
             dec(xn,512);
             dec(yn,512);
           end;
        1: begin //Links
             inc(xn,1024);
           end;
        2: begin //Rechts
             dec(xn,2048);
           end;
        3: begin //Oben
             inc(xn,1024);
             inc(yn,768);
           end;
        4: begin //Unten
             dec(yn,1536);
           end;
      end;
      if (Abs(xn)>1000) or (Abs(yn)>1000) then continue;
      //unerreichbar, da gleiche Bewegungsvektoren
      if (Vx/accuracy=sa[angle][0]/8) and (Vy/accuracy=sa[angle][1]/8) then continue;
      try
        ft:=Round((xn*(sa[angle][0]/8-Vx/accuracy)+yn*(sa[angle][1]/8-Vy/accuracy))/
         (sqr(Vx/accuracy-sa[angle][0]/8)+sqr(Vy/accuracy-sa[angle][1]/8)));
      except
        MmoLog.Lines.Add('Floatingpoint exception'+IntToStr(frame));
        continue;
      end;
      if (ft<0) or (ft>lifetime+5) or
        (distanceSqr(Round(xn+ft*Vx / accuracy),
                     Round(yn+ft*Vy / accuracy),
                     Round(ft*sa[angle][0]/8),
                     Round(ft*sa[angle][1]/8))>2500)
      then continue;
      dec(ft,6);
      for j:=0 to 10 do begin
        inc(ft);
        if ft<=0 then continue;
        if ft>lifetime then break;
        //besser waere die Funktion ohne normalisierung -> 1 Rundung weniger
        if CheckCollision(Round(xn+ft*Vx/accuracy),
                          Round(yn+ft*Vy/accuracy),
                          Round(ft*sa[angle][0]/8),
                          Round(ft*sa[angle][1]/8),
                          objType,false) then
        begin
          Result:=true;
          flyingtime:=ft;
          Exit;
        end;
      end;
    end;
  end;
end;

function TForm1.isNewLevel(frame: Cardinal): Boolean;
var
  i: Integer;
begin
  Result:=true;
  for i:=0 to MAX_OBJECTS-1 do begin
    if (game[frame].objects[i].objType in [1..3]) then begin
      Result:=false;
      Exit;
    end;
    if (game[frame].objects[i].objType=0) then begin
      Exit;
    end;
  end;
end;

procedure TForm1.ClearActions();
var
  i: Integer;
begin
  for i:=0 to 63 do begin
    FillMemory(@(keypresses[i]),SizeOf(keypresses[i]),0);
  end;
  keypresses[0].frame:=frameNo;
end;

//Hier ist der Konzeptfehler, der das Projekt zum Scheitern brachte
//overrPressKeys/overrRelKeys ist dabei nur ein lausiger Workaround, der nicht-
//mal funktioniert.
procedure TForm1.AddAction(key: Byte;press,release: Cardinal;overrPressKeys: Byte=255;overrRelKeys: Byte=255);
var
  i,j: Integer;
  keyByte1: Byte;
begin
  if (press>0) then begin
    j:=-1;
    for i:=0 to 63 do begin
      if (j=-1) and (keypresses[i].frame=0) then begin
        j:=i;
      end else
      if (keypresses[i].frame=press) then begin
        j:=i;
        break;
      end;
    end;
    if j=-1 then begin
      MmoLog.Lines.Add('Too many actions in queue.');
      Exit;
    end;

    if keypresses[j].frame=0 then begin
      if overrPressKeys=255 then begin
        keyByte1:=KeyStateToByte(game[press].KeyState);
      end else begin
        keyByte1:=overrPressKeys;
      end;
    end else begin
      keyByte1:=KeyStateToByte(keypresses[j].keys);
    end;
    //falls Taste nach rechts, dann setze Taste nach links zurueck
    if key=3 then keyByte1:=keyByte1 and $EF;
    //und umgekehrt...
    if key=4 then keyByte1:=keyByte1 and $F7;
    case key of
      0: keyByte1:=keyByte1 or $01;
      1: keyByte1:=keyByte1 or $02;
      2: keyByte1:=keyByte1 or $04;
      3: keyByte1:=keyByte1 or $08;
      4: keyByte1:=keyByte1 or $10;
      5: keyByte1:=keyByte1 or $20;
    end;
    keypresses[j].keys:=CreateKeyState(keyByte1);
    keypresses[j].frame:=press;
  end;

  if (release>0) then begin
    j:=-1;
    for i:=0 to 63 do begin
      if (j=-1) and (keypresses[i].frame=0) then begin
        j:=i;
      end else
      if (keypresses[i].frame=release) then begin
        j:=i;
        break;
      end;
    end;
    if j=-1 then begin
      MmoLog.Lines.Add('Too many actions in queue.');
      Exit;
    end;

    if keypresses[j].frame=0 then begin
      if overrRelKeys=255 then begin
        keyByte1:=KeyStateToByte(game[press].KeyState);
      end else begin
        keyByte1:=overrRelKeys;
      end;
    end else begin
      keyByte1:=KeyStateToByte(keypresses[j].keys);
    end;
    case key of
      0: keyByte1:=keyByte1 and $FE;
      1: keyByte1:=keyByte1 and $FD;
      2: keyByte1:=keyByte1 and $FB;
      3: keyByte1:=keyByte1 and $F7;
      4: keyByte1:=keyByte1 and $EF;
      5: keyByte1:=keyByte1 and $DF;
    end;
    keypresses[j].keys:=CreateKeyState(keyByte1);
    keypresses[j].frame:=release;
  end;
end;

function TForm1.KeyStateToByte(keys: TKeyState): Byte;
begin
  Result:=0;
  if keys.hyper  then Result:=Result or $01;
  if keys.fire   then Result:=Result or $02;
  if keys.thrust then Result:=Result or $04;
  if keys.right  then Result:=Result or $08;
  if keys.left   then Result:=Result or $10;
  if keys.start  then Result:=Result or $20;
end;

function TForm1.fastestHit(frame: Cardinal;angle: Byte;shootAfter: Byte;depth: Byte=43): THitStruct;
var
  i,j: Integer;
  newAngle: Integer;
  turn: ShortInt;
  turnTime: Byte;
  hitOptions: Array of THitStruct;
  hitCnt,hitPos,bestHit: Integer;
  waittime,flyingtime: Byte;
begin
  hitCnt:=8;
  hitPos:=0;
  bestHit:=-1;
  SetLength(hitOptions,hitCnt);
  FillMemory(@(hitOptions[0]),SizeOf(hitOptions[0]),0);

  //von turn von -43 bis +43
  for i:=0 to depth*2 do begin
    if i mod 2=0 then begin
      turn:=-i*3 div 2;
      turntime:=i div 2;
    end else begin
      turn:=(i+1)*3 div 2;
      turntime:=(i+1) div 2;
    end;
    newAngle:=(angle+turn+512) mod 256;

    for j:=0 to MAX_OBJECTS-1 do begin
      if game[frame].objects[j].ttl>0 then continue;
      //max 5 frames warten...
      //waittime:=0; 
      for waittime:=0 to 5 do begin
        if turnTime+waittime<shootAfter then break;
        if game[frame+turnTime+waittime].objects[j].objType=0 then break;
        if not (game[frame+turnTime+waittime].objects[j].objType in [1..5]) or
          (game[frame+turnTime+waittime].status.shotsonair=4) then
          continue;
        if CanShootObj(frame+turnTime+waittime,Byte(newAngle),j,flyingtime) then begin
          inc(hitPos);
          if hitPos>hitCnt then begin
            inc(hitCnt,hitCnt);
            SetLength(hitOptions,hitCnt);
          end;
          hitOptions[hitPos-1].turn:=turn div 3;
          hitOptions[hitPos-1].shootFrame:=frame+turnTime+waittime;
          hitOptions[hitPos-1].flyingtime:=flyingtime;
          hitOptions[hitPos-1].objID:=game[frame+turnTime+waittime].objects[j].objID;
          hitOptions[hitPos-1].objType:=game[frame+turnTime+waittime].objects[j].objType;

          if bestHit=-1 then begin
            bestHit:=hitPos-1;
          end else begin
            //ist diese Moeglichkeit besser als die bisher beste?

            //Strategie: je schneller ich schiee, desto besser
            if (hitOptions[hitPos-1].shootFrame<hitOptions[bestHit].shootFrame) then begin
              bestHit:=hitPos-1;
            end;
          end;
          break;
        end;
      end;
    end;
  end;
  //MmoLog.Lines.Add(IntToStr(frame)+': '+IntToStr(hitPos)+' targets');
  if bestHit=-1 then begin
    Result:=hitOptions[0];
  end else begin
    Result:=hitOptions[bestHit];
  end;
end;

end.
