;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: WELTRAUMPUTZE; Base: 10 -*-

;;; Some command related functions for easier command byte handling

(in-package :weltraumputze)

(defun hyperspace (command)
  (> (boole boole-and #x1 command) 0))

(defun fire (command)
  (> (boole boole-and #x2 command) 0))

(defun thrust (command)
  (> (boole boole-and #x4 command) 0))

(defun right (command)
  (> (boole boole-and #x8 command) 0))

(defun left (command)
  (> (boole boole-and #x10 command) 0))

(defun create-command (command-symbols)
  (if (and (member 'right command-symbols) (member 'left command-symbols))
      (format t "create-command: Got ambigous command in ~A.~%" command-symbols))
  (if (> (length (union command-symbols '(hyperspace fire thrust right left))) 5)
      (format t "create-command: Unknown command symbol in ~A.~%" command-symbols))
  (+
   (if (member 'hyperspace command-symbols) #x1 0)
   (if (member 'fire command-symbols) #x2 0)
   (if (member 'thrust command-symbols) #x4 0)
   (if (member 'right command-symbols) #x8 0)
   (if (member 'left command-symbols) #x10 0)))