package asteroid.strategy;

import junit.framework.TestCase;

public class CollisionTest extends TestCase {
	public CollisionTest( String name) {
		super( name);
	}

	private void collision1( int x1, int y1, int ox, int oy, int x2, int y2, int sx, int sy) {
		int dd = (ox * sy) - (oy * sx);
		int o = (y1 * ox) - (x1 * oy);
		int s = (y2 * sx) - (x2 * sy);
		double x0 = (double) ((o * sx) - (s * ox)) / dd;
		double y0 = (double) ((o * sy) - (s * oy)) / dd;
		System.out.println( "x0=" + x0);
		System.out.println( "y0=" + y0);
		int dx = x2 - x1;
		int dy = y2 - y1;
		double ko = (double) ((dx * sy) - (dy * sx)) / dd;
		double ks = (double) ((dx * oy) - (dy * ox)) / dd;
		System.out.println( "ko=" + ko);
		System.out.println( "ks=" + ks);
		double vo = Math.sqrt( (ox * ox) + (oy * oy));
		double vs = Math.sqrt( (sx * sx) + (sy * sy));
		System.out.println( "vo=" + vo);
		System.out.println( "vs=" + vs);
		System.out.println( "to=" + ((x0 - x1) / ox));
		System.out.println( "to=" + ((y0 - y1) / oy));
		System.out.println( "ts=" + ((x0 - x2) / sx));
		System.out.println( "ts=" + ((y0 - y2) / sy));
		int dvx = sx - ox;
		int dvy = sy - oy;
		double ds2 = (dx * dvy) - (dy * dvx);
		int dv2 = (dvy * dvy) + (dvx * dvx);
		ds2 = ds2 * ds2 / dv2;
		System.out.println( "ds2=" + Math.sqrt( ds2));
		double t = -((dx * dvx) + (dy * dvy)) / dv2;
		System.out.println( "t=" + t);
		System.out.println( "x0o=" + (x1 + (t * ox)));
		System.out.println( "y0o=" + (y1 + (t * oy)));
		System.out.println( "x0s=" + (x2 + (t * sx)));
		System.out.println( "y0s=" + (y2 + (t * sy)));
		//
		System.out.println();
	}

	private void collision2( int x1, int y1, int ox, int oy, int x2, int y2, int sx, int sy) {
		int dx = x2 - x1;
		int dy = y2 - y1;
		System.out.println( "dx=" + dx);
		System.out.println( "dy=" + dy);
		int dMoveX = sx - ox;
		int dMoveY = sy - oy;
		int dMove2 = (dMoveX * dMoveX) + (dMoveY * dMoveY);
		int t = -100 * ((dx * dMoveX) + (dy * dMoveY)) / dMove2;
		long dd = 100 * ((dx * dMoveY) - (dy * dMoveX));
		long ds = dd * dd / dMove2;
		ds = (long) Math.sqrt( ds);
		System.out.println( "t=" + (t / 100.0));
		System.out.println( "ds=" + (ds / 100.0));
		//
		System.out.println();
	}

	public void testA() {
		// O0:5088,4032,62,-11
		// A1:7824,3472,-16,8:40,14
		collision1( 5088, 4032, 62, -11, 7824, 3472, -16, 8);
		//
		// O0:6144,3840,62,-11
		// A1:7552,3608,-16,8:24,-3
		collision1( 6144, 3840, 62, -11, 7552, 3608, -16, 8);
		//
		// O0:6640,3752,62,-11
		// A1:7424,3672,-16,8:16,-11
		collision1( 6640, 3752, 62, -11, 7424, 3672, -16, 8);
		//
		// O0:7072,3680,62,-11
		// A1:7312,3728,-16,8:8,-18
		collision1( 7072, 3680, 62, -11, 7312, 3728, -16, 8);
		// O2:4338,2651,6,-63
		// A15:4369,1812,3,20:10,0
		collision2( 4338, 2651, 6, -63, 4369, 1812, 3, 20);
	}
}
