package asteroid.udp;

import java.nio.ByteBuffer;

import asteroid.SimpleLogging;

class ReceiveFiFo extends AReceiveFiFo {
	ReceiveFiFo( int latenz) {
		super( latenz);
	}

	public synchronized void eventRead() {
		notifyAll();
	}

	public synchronized ByteBuffer nextRead( boolean blocked) {
		if ((mWrite <= mLatenz) && blocked) {
			waitFor();
		}
		if (mWrite <= mLatenz) {
			return null;
		}
		ByteBuffer data = mBuff[0];
		moveRead();
		return data;
	}

	public synchronized ByteBuffer nextWrite() {
		return mBuff[mWrite];
	}

	public synchronized void received() {
		if (frameOrder()) {
			moveWrite();
		}
		notifyAll();
	}

	private void waitFor() {
		try {
			wait();
		}
		catch (InterruptedException ex) {
			SimpleLogging.addException( ex);
		}
	}
}
