package asteroid.strategy;

import asteroid.Operation;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Ufo;

public class DistanceDemo extends AStrategie {
	private int mDist, mRot;
	private int mShipDX, mShipDY;
	private int mShipX, mShipY;

	public DistanceDemo( GameModel model) {
		super( model);
	}

	public void cleanup() {
	}

	public void forAsteroid( Asteroid ast) {
		if (ast.isVisible()) {
			int dx = Operation.signX8( ast.getX8() - mShipX);
			int dy = Operation.signY8( ast.getY8() - mShipY);
			int dist = (dx * dx) + (dy * dy);
			switch (ast.getZ()) {
				case 0: // grosser Asteroid
					dist -= 40 * 40 * 8 * 8;
					break;
				case 15: // mittlerer Asteroid
					dist -= 20 * 20 * 8 * 8;
					break;
				case 14: // kleiner Asteroid
					dist -= 8 * 8 * 8 * 8;
					break;
			}
			if (dist < mDist) {
				mDist = dist;
				mRot = (mShipDX * dy) - (mShipDY * dx);
			}
		}
	}

	public void forShip( Ship ship) {
		mShipX = ship.getX8();
		mShipY = ship.getY8();
		mShipDX = ship.getDx();
		mShipDY = ship.getDy();
	}

	public void forUfo( Ufo ufo) {
		if (ufo.isVisible()) {
			int dx = Operation.signX8( ufo.getX8() - mShipX);
			int dy = Operation.signY8( ufo.getY8() - mShipY);
			int dist = (dx * dx) + (dy * dy);
			switch (ufo.getZ()) { // Abstand um den ungefaehren Radius des UFOs korrigieren
				case 15: // grosses UFO
					dist -= 20 * 12 * 8 * 8;
					break;
				case 14: // kleines UFO
					dist -= 10 * 6 * 8 * 8;
					break;
			}
			if (dist < mDist) {
				mDist = dist;
				mRot = (mShipDX * dy) - (mShipDY * dx);
			}
		}
	}

	public int getKey() {
		int key = 0;
		if (mRot > 0) {
			key |= KEY_LEFT;
		}
		if (mRot < 0) {
			key |= KEY_RIGHT;
		}
		if (mDist < (27 * 27 * 8 * 8)) { // Flucht, wenn Kollision unausweichlich
			key |= KEY_HYPERSPACE;
		}
		if (mDist > (400 * 400 * 8 * 8)) { // beschleunigen, wenn nichts in der Naehe
			key |= KEY_THRUST;
		}
		if ((GameModel.sFrame % 2) == 0) { // Feuerknopf druecken, so schnell es geht
			key |= KEY_FIRE;
		}
		return mModel.isShipVisible() ? key : 0;
	}

	public void refresh() {
		if (mModel.getShip().isVisible()) {
			mDist = 0x7FFFFFFF;
			mModel.forShip( this);
			mModel.forAllAsteroids( this);
			mModel.forUfo( this);
		}
	}
}
