package asteroid.statistic;

public class AverageLong {
	public long mStart;
	private long mAverage;
	private int mMask;
	private int mPos;
	private long mRound;
	private int mShift;
	private long mSum;
	private long[] mValues;

	public AverageLong( int dim) {
		mShift = dim;
		int size = 1 << dim;
		mValues = new long[size];
		mMask = size - 1;
		mRound = size >> 1;
		mSum = mRound;
	}

	public void addDeviation( long value) {
		setValue( mPos++, value - mStart);
	}

	public void addValue( long value) {
		setValue( mPos++, value);
	}

	public double getAverage() {
		return mAverage;
	}

	public double getMean() {
		return (double) getSum() / mValues.length;
	}

	public void reset() {
		for (int i = 0; i < mValues.length; ++i) {
			mValues[i] = 0;
		}
		mAverage = 0;
		mSum = mRound;
	}

	public long getSum() {
		return mSum - mRound;
	}

	public void setValue( int pos, long value) {
		pos &= mMask;
		mSum -= mValues[pos];
		mSum += value;
		mValues[pos] = value;
		mAverage = mSum >> mShift;
	}
}
