package asteroid.printer;

import asteroid.model.ACompute;
import asteroid.model.Asteroid;
import asteroid.model.AsteroidVector;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.ShotVector;
import asteroid.model.Ufo;

public class RememberModel extends ACompute {
	Remember[] mAsts = new Remember[AsteroidVector.MAX_ASTEROIDS];
	Remember mShip;
	Remember[] mShots = new Remember[ShotVector.MAX_SHOTS];
	Remember mUfo;

	public RememberModel() {
		for (int i = 0; i < ShotVector.MAX_SHOTS; ++i) {
			mShots[i] = new Remember();
		}
		for (int i = 0; i < AsteroidVector.MAX_ASTEROIDS; ++i) {
			mAsts[i] = new Remember();
		}
	}

	public void forAsteroid( Asteroid ast) {
		mAsts[ast.getIndex()].saveAsteroid( ast);
	}

	public void forShip( Ship ship) {
		mShip.saveShip( ship);
	}

	public void forShot( Shot shot) {
		mShots[shot.getIndex()].saveShot( shot);
	}

	public void forUfo( Ufo ufo) {
		mUfo.saveUfo( ufo);
	}
}
