package asteroid.model;

import asteroid.Operation;
import asteroid.SimpleLogging;

public class Striker extends ACompute {
	private static final int MIN_HIT_DIST = 80;
	int mCreates, mScore, mStrikes, mVanish;
	private AsteroidVector mAsts;
	private Ship mShip;
	private ShotVector mShots;
	private Ufo mUfo;

	Striker( Ship ship, Ufo ufo, AsteroidVector asts, ShotVector shots) {
		mShip = ship;
		mUfo = ufo;
		mAsts = asts;
		mShots = shots;
	}

	void detect() {
		mVanish = mShots.getVanish();
		if (mAsts.getVanish() > 0) {
			mAsts.forAll( this);
			mVanish += mAsts.getVanish();
		}
		if (mShip.getVanish() == 1) {
			mShip.doIt( this);
			++mVanish;
		}
		if (mUfo.getVanish() == 1) {
			mUfo.doIt( this);
			++mVanish;
		}
		mShots.forAll( this);
		if (mShip.mVanish == 1) {
			mShip.mState = AFlyable.STATE_JUMP;
		}
	}

	public void forAsteroid( Asteroid ast) {
		if ((ast.mVanish == 1) && (mUfo.mVanish == 1) && isHitAsteroidUfo( ast, mUfo)) {
			ast.mVanish |= 2;
			mUfo.mVanish |= 2;
		}
		if ((ast.mVanish == 1) && (mShip.mVanish == 1) && isHitAsteroidShip( ast, mShip)) {
			ast.mVanish |= 2;
			mShip.mVanish |= 2;
			mScore += ast.getScore();
		}
		for (int i = 0; i < ShotVector.MAX_SHOTS; ++i) {
			Shot shot = mShots.mShots[i];
			if ((ast.mVanish == 1) && (shot.mVanish == 1) && isHitAsteroidShot( ast, shot)) {
				ast.mVanish |= 2;
				shot.mVanish |= 2;
				if (shot.isShip()) {
					++mStrikes;
					mScore += ast.getScore();
				}
			}
		}
	}

	public void forShip( Ship ship) {
		if ((ship.mVanish == 1) && (mUfo.mVanish == 1) && isHitShipUfo( ship, mUfo)) {
			ship.mVanish |= 2;
			mUfo.mVanish |= 2;
		}
		for (int i = 0; i < ShotVector.MAX_SHOTS; ++i) {
			Shot shot = mShots.mShots[i];
			if ((ship.mVanish == 1) && (shot.mVanish == 1) && isHitShipShot( ship, shot)) {
				ship.mVanish |= 2;
				shot.mVanish |= 2;
				if (shot.isShip()) {
					SimpleLogging.addLog( "oh nein, Selbstmord");
				}
			}
		}
	}

	public void forShot( Shot shot) {
		if (shot.mCreate == 1) {
			shot.mCreate |= 2;
			if (shot.isShip()) {
				++mCreates;
			}
		}
	}

	public void forUfo( Ufo ufo) {
		for (int i = 0; i < ShotVector.MAX_SHOTS; ++i) {
			Shot shot = mShots.mShots[i];
			if ((ufo.mVanish == 1) && (shot.mVanish == 1) && isHitUfoShot( ufo, shot)) {
				ufo.mVanish |= 2;
				shot.mVanish |= 2;
				if (shot.isShip()) {
					++mStrikes;
					mScore += ufo.getScore();
				}
			}
		}
	}

	public static boolean isHitAsteroidShip( Asteroid ast, Ship ship) {
		int distX8 = Operation.distX8( ast.mX8 - ship.mX8);
		int distY8 = Operation.distY8( ast.mY8 - ship.mY8);
		distX8 -= ast.sizeX();
		distY8 -= ast.sizeY();
		distX8 -= ship.sizeX();
		distY8 -= ship.sizeY();
		return (distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST);
	}

	public static boolean isHitAsteroidShot( Asteroid ast, Shot shot) {
		int distX8 = Operation.distX8( ast.mX8 - shot.mLast.mX8);
		int distY8 = Operation.distY8( ast.mY8 - shot.mLast.mY8);
		distX8 -= ast.sizeX();
		distY8 -= ast.sizeY();
		distX8 -= shot.sizeX();
		distY8 -= shot.sizeY();
		return (distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST);
	}

	public static boolean isHitAsteroidUfo( Asteroid ast, Ufo ufo) {
		int distX8 = Operation.distX8( ast.mX8 - ufo.mX8);
		int distY8 = Operation.distY8( ast.mY8 - ufo.mY8);
		distX8 -= ast.sizeX();
		distY8 -= ast.sizeY();
		distX8 -= ufo.sizeX();
		distY8 -= ufo.sizeY();
		return (distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST);
	}

	public static boolean isHitShipShot( Ship ship, Shot shot) {
		int distX8 = Operation.distX8( ship.mX8 - shot.mLast.mX8);
		int distY8 = Operation.distY8( ship.mY8 - shot.mLast.mY8);
		distX8 -= ship.sizeX();
		distY8 -= ship.sizeY();
		distX8 -= shot.sizeX();
		distY8 -= shot.sizeY();
		return (distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST);
	}

	public static boolean isHitShipUfo( Ship ship, Ufo ufo) {
		int distX8 = Operation.distX8( ship.mX8 - ufo.mX8);
		int distY8 = Operation.distY8( ship.mY8 - ufo.mY8);
		distX8 -= ship.sizeX();
		distY8 -= ship.sizeY();
		distX8 -= ufo.sizeX();
		distY8 -= ufo.sizeY();
		return (distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST);
	}

	public static boolean isHitUfoShot( Ufo ufo, Shot shot) {
		int distX8 = Operation.distX8( ufo.mX8 - shot.mLast.mX8);
		int distY8 = Operation.distY8( ufo.mY8 - shot.mLast.mY8);
		distX8 -= ufo.sizeX();
		distY8 -= ufo.sizeY();
		distX8 -= shot.sizeX();
		distY8 -= shot.sizeY();
		return (distX8 < MIN_HIT_DIST) && (distY8 < MIN_HIT_DIST);
	}

	public void reset() {
		mStrikes = mCreates = mScore = 0;
	}
}
