package asteroid.model;

import asteroid.Operation;

public class Asteroid extends AEnemy {
	public static final int MAX_FIRE_BIG = 1;
	public static final int MAX_FIRE_MEDIAN = 3;
	public static final int MAX_FIRE_SMALL = 1;
	public static final int EXPLOSION_COUNTDOWN = 37;
	public static final int[] EXPLOSION_SEQUENCE = {
		Operation.EXPLOSION_3, Operation.EXPLOSION_3, Operation.EXPLOSION_3, Operation.EXPLOSION_3,
		Operation.EXPLOSION_2, Operation.EXPLOSION_2, Operation.EXPLOSION_2, Operation.EXPLOSION_2,
		Operation.EXPLOSION_1, Operation.EXPLOSION_1, Operation.EXPLOSION_1, Operation.EXPLOSION_1,
		Operation.EXPLOSION_0, Operation.EXPLOSION_0, Operation.EXPLOSION_0, Operation.EXPLOSION_3,
		Operation.EXPLOSION_3, Operation.EXPLOSION_2, Operation.EXPLOSION_2, Operation.EXPLOSION_1,
		Operation.EXPLOSION_1, Operation.EXPLOSION_0, Operation.EXPLOSION_0, Operation.EXPLOSION_3,
		Operation.EXPLOSION_2, Operation.EXPLOSION_2, Operation.EXPLOSION_1, Operation.EXPLOSION_0,
		Operation.EXPLOSION_3, Operation.EXPLOSION_2, Operation.EXPLOSION_1, Operation.EXPLOSION_0,
		Operation.EXPLOSION_3, Operation.EXPLOSION_2, Operation.EXPLOSION_0, Operation.EXPLOSION_3,
		Operation.EXPLOSION_1
	};
	int mCountDown;
	private String mIdent;
	private int mIndex;

	Asteroid( int index) {
		mIndex = index;
		mIdent = "A" + index;
	}

	Asteroid( int index, int x8, int y8, int z, int moveX8, int moveY8) {
		super( x8, y8, z, moveX8, moveY8);
		mIndex = index;
		mIdent = "A" + index;
	}

	void correctCD() {
		while ((mCountDown > 0) && (EXPLOSION_SEQUENCE[mCountDown - 1] != mType)) {
			--mCountDown;
		}
	}

	void doIt( ICompute comp) {
		comp.forAsteroid( this);
	}

	public boolean isFired() {
		switch (mZ) {
			case 0: // grosser Asteroid
				return mFire < MAX_FIRE_BIG;
			case 15: // mittlerer Asteroid
				return mFire < MAX_FIRE_MEDIAN;
			case 14: // kleiner Asteroid
				return mFire < MAX_FIRE_SMALL;
		}
		return false;
	}

	public int getID() {
		return mIndex;
	}

	public String getIdent() {
		return mIdent;
	}

	public int getIndex() {
		return mIndex;
	}

	public void initFire() {
		switch (mZ) {
			case 0: // grosser Asteroid
				mFire = MAX_FIRE_BIG;
				break;
			case 15: // mittlerer Asteroid
				mFire = MAX_FIRE_MEDIAN;
				break;
			case 14: // kleiner Asteroid
				mFire = MAX_FIRE_SMALL;
				break;
		}
	}

	public int getScore() {
		switch (mZ) {
			case 0: // grosser Asteroid
				return 20;
			case 15: // mittlerer Asteroid
				return 50;
			case 14: // kleiner Asteroid
				return 100;
		}
		return 0;
	}

	public int size() {
		switch (mZ) {
			case 0: // grosser Asteroid
				return 250;
			case 15: // mittlerer Asteroid
				return 120;
			case 14: // kleiner Asteroid
				return 50;
		}
		return 0;
	}

	public int sizeX() {
		switch (mZ) {
			case 0: // grosser Asteroid
				return 320;
			case 15: // mittlerer Asteroid
				return 160;
			case 14: // kleiner Asteroid
				return 80;
		}
		return 0;
	}

	public int sizeY() {
		switch (mZ) {
			case 0: // grosser Asteroid
				return 320;
			case 15: // mittlerer Asteroid
				return 160;
			case 14: // kleiner Asteroid
				return 80;
		}
		return 0;
	}
}
