package asteroid.model;

import asteroid.Operation;

public abstract class AEnemy extends AFlyable {
	public static int sLimit;
	public double mWeight;
	int mDirectionOld, mStepsOld, mTimeShotOld, mTimeEnemyOld;
	int mType, mFire;
	private double mAlpha;
	private double mGamma;
	private TargetInfo mInfo = new TargetInfo();
	private double mTime;

	AEnemy() {
	}

	AEnemy( int x8, int y8, int z, int moveX8, int moveY8) {
		super( x8, y8, z, moveX8, moveY8);
	}

	public double getAlpha() {
		return mInfo.getAlpha();
	}

	public double getAlpha( Ship ship, int time) {
		double t1 = Math.abs( Angle.signRot( mAlpha - Angle.sRadiant)) / 3.0;
		t1 += time;
		double dx = Operation.signX8( getX8( t1) - ship.mX8);
		double dy = Operation.signY8( getY8( t1) - ship.mY8);
		double gamma = Math.atan2( dy, dx);
		double speedEnemy = getVelocity8();
		double shotSpeed8 = Angle.vShot( mDirectionOld);
		double dBG = getBetha() - gamma;
		double dAG = Math.asin( speedEnemy * Math.sin( dBG) / shotSpeed8);
		double tempE = speedEnemy * Math.cos( dBG);
		double tempS = shotSpeed8 * Math.cos( dAG);
		if (tempS < tempE) {
			dAG = Math.PI - dAG;
			tempS = -tempS;
		}
		return gamma + dAG;
	}

	public boolean canFire() {
		return mFire > sLimit;
	}

	public void decFire() {
		--mFire;
	}

	public int getDirection() {
		return mDirectionOld;
	}

	public void setDirection( Ship ship, int time) {
		double t1 = Math.abs( Angle.signRot( mAlpha - Angle.sRadiant)) / 3.0;
		t1 += time;
		double dx = Operation.signX8( getX8( t1) - ship.mX8);
		double dy = Operation.signY8( getY8( t1) - ship.mY8);
		mGamma = Math.atan2( dy, dx);
		double d = Math.sqrt( (dx * dx) + (dy * dy));
		double speedEnemy = getVelocity8();
		double shotSpeed8 = Angle.vShot( mDirectionOld);
		double dBG = getBetha() - mGamma;
		double dAG = Math.asin( speedEnemy * Math.sin( dBG) / shotSpeed8);
		double tempE = speedEnemy * Math.cos( dBG);
		double tempO = shotSpeed8 * Math.cos( dAG);
		if (tempO < tempE) {
			dAG = Math.PI - dAG;
			tempO = -tempO;
		}
		mAlpha = mGamma + dAG;
		mDirectionOld = Angle.getAngle( mAlpha);
		mTime = d / (tempO - tempE);
	}

	public double getDistance( Ship ship) {
		return Math.sqrt( getDistance2( ship));
	}

	public int getDistance2( Ship ship) {
		int dx = Operation.signX8( mX8 - ship.mX8);
		int dy = Operation.signY8( mY8 - ship.mY8);
		return (dx * dx) + (dy * dy);
	}

	public abstract boolean isFired();

	public double getGamma() {
		return mGamma;
	}

	public abstract int getID();

	public void incFire() {
		++mFire;
	}

	public TargetInfo getInfo() {
		return mInfo;
	}

	public void init( Ship ship) {
		mInfo.calculate( this, ship, Angle.sDirection, GameModel.sFrame, GameModel.sFrame);
//		if (mCreate > 0) {
//			int dx0 = TargetInfo.getX0( this, ship, Angle.sForward, 0);
//			int dy0 = TargetInfo.getY0( this, ship, Angle.sForward, 0);
//			mAlpha = Math.atan2( dy0, dx0);
//			mDirectionOld = Angle.getAngle( mAlpha);
//		}
////		setDirection( ship, Angle.sForward);
//		setDirection( ship, 0);
	}

	public abstract void initFire();

	void move( int time) {
		mX8 += time * mMoveX8;
		mY8 += time * mMoveY8;
	}

	public double getTime() {
		return mTime;
	}

	public int getType() {
		return mType;
	}
}
