/*
 * Decompiled with CFR 0.152.
 */
package asteroid.ui;

import asteroid.SimpleLogging;
import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.statistic.GameValues;
import asteroid.ui.ABaseBox;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

class StatusView
extends JPanel {
    private static final long serialVersionUID = 8102741931793581425L;
    private static final int GAP = 10;
    private GameValues mGame;
    private GameModel mModel;
    private JLabel[] mMsg = new JLabel[6];
    private JLabel mTxtCalc = StatusView.createLabelBox();
    private JLabel mTxtForward = StatusView.createLabelBox();
    private JLabel mTxtFrame = StatusView.createLabelBox();
    private JLabel mTxtHits = StatusView.createLabelBox();
    private JLabel mTxtLevel = StatusView.createLabelBox();
    private JLabel mTxtLifes = StatusView.createLabelBox();
    private JLabel mTxtPoints = StatusView.createLabelBox();
    private JLabel mTxtRates = StatusView.createLabelBox();
    private JLabel mTxtScore = StatusView.createLabelBox();
    private JLabel mTxtShots = StatusView.createLabelBox();
    private JLabel mTxtTime = StatusView.createLabelBox();

    public StatusView(GameModel gameModel, GameValues gameValues, int n, int n2) {
        this.mModel = gameModel;
        this.mGame = gameValues;
        for (int i = 0; i < 6; ++i) {
            JLabel jLabel;
            this.mMsg[i] = jLabel = new JLabel();
            jLabel.setAlignmentX(0.0f);
            jLabel.setForeground(Color.getHSBColor(0.0f, 0.0f, (float)i / 6.0f));
        }
        Dimension dimension = new Dimension(n, n2);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        ABaseBox.addBorder(this, BorderFactory.createLineBorder(this.getBackground().darker()));
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.createStatusBox());
        this.add(this.createStatisticBox());
        this.add(Box.createHorizontalGlue());
        this.add(this.createMessageBox());
    }

    private static JLabel createLabelBox() {
        JLabel jLabel = new JLabel();
        jLabel.setAlignmentX(1.0f);
        return jLabel;
    }

    private Box createMessageBox() {
        Box box = Box.createVerticalBox();
        ABaseBox.addEmptyBorder(box, 0, 10, 0, 10);
        ABaseBox.addBorder(box, BorderFactory.createTitledBorder("Nachrichten"));
        box.setPreferredSize(new Dimension(240, 100));
        for (int i = 0; i < 6; ++i) {
            box.add(this.mMsg[i]);
        }
        box.add(Box.createVerticalGlue());
        return box;
    }

    private Box createStatisticBox() {
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Punkte/min"));
        box.add(new JLabel("Schuss"));
        box.add(new JLabel("Treffer"));
        box.add(new JLabel("Vorhalten"));
        box.add(new JLabel("Framerate"));
        box.add(new JLabel("Rechenzeit"));
        box.add(Box.createVerticalGlue());
        Box box2 = Box.createVerticalBox();
        box2.add(this.mTxtPoints);
        box2.add(this.mTxtShots);
        box2.add(this.mTxtHits);
        box2.add(this.mTxtForward);
        box2.add(this.mTxtRates);
        box2.add(this.mTxtCalc);
        box2.add(Box.createVerticalGlue());
        Box box3 = Box.createHorizontalBox();
        ABaseBox.addEmptyBorder(box3, 0, 10, 0, 10);
        ABaseBox.addBorder(box3, BorderFactory.createTitledBorder("Statistik"));
        box3.add(box);
        box3.add(Box.createHorizontalStrut(10));
        box3.add(box2);
        return box3;
    }

    private Box createStatusBox() {
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Level"));
        box.add(new JLabel("Frame"));
        box.add(new JLabel("Zeit"));
        box.add(new JLabel("Punkte"));
        box.add(new JLabel("Leben"));
        box.add(Box.createVerticalGlue());
        Box box2 = Box.createVerticalBox();
        box2.add(this.mTxtLevel);
        box2.add(this.mTxtFrame);
        box2.add(this.mTxtTime);
        box2.add(this.mTxtScore);
        box2.add(this.mTxtLifes);
        box2.add(Box.createVerticalGlue());
        Box box3 = Box.createHorizontalBox();
        ABaseBox.addEmptyBorder(box3, 0, 10, 0, 10);
        ABaseBox.addBorder(box3, BorderFactory.createTitledBorder("Status"));
        box3.add(box);
        box3.add(Box.createHorizontalStrut(10));
        box3.add(box2);
        return box3;
    }

    private String getTimeText(long l) {
        long l2 = (l /= 100L) % 10L;
        long l3 = (l /= 10L) % 60L;
        long l4 = (l /= 60L) % 60L;
        StringBuffer stringBuffer = new StringBuffer();
        if ((l /= 60L) > 0L) {
            stringBuffer.append(l);
            stringBuffer.append(':');
            if (l4 < 10L) {
                stringBuffer.append('0');
            }
        }
        stringBuffer.append(l4);
        stringBuffer.append(':');
        if (l3 < 10L) {
            stringBuffer.append('0');
        }
        stringBuffer.append(l3);
        stringBuffer.append('.');
        stringBuffer.append(l2);
        return stringBuffer.toString();
    }

    void updateView() {
        int n;
        this.mTxtLevel.setText(Integer.toString(this.mModel.getLevel()));
        this.mTxtTime.setText(this.getTimeText(this.mGame.getPlayTime()));
        this.mTxtFrame.setText(Integer.toString(this.mModel.getPlayFrame()));
        this.mTxtScore.setText(Integer.toString(this.mModel.getScore()));
        this.mTxtLifes.setText(Integer.toString(this.mModel.getLives()));
        for (n = 0; n < 6; ++n) {
            this.mMsg[n].setText(SimpleLogging.getLog(n));
        }
        this.mTxtRates.setText(Double.toString((double)Math.round(10.0 * this.mGame.getAverageFrames()) / 10.0));
        this.mTxtPoints.setText(this.mModel.getPlayFrame() > 50 ? Long.toString(3600L * (long)this.mModel.getScore() / (long)this.mModel.getPlayFrame()) : "0");
        this.mTxtShots.setText(Integer.toString(this.mModel.getShots()));
        n = this.mModel.getShots() > 0 ? 100 * this.mModel.getHits() / this.mModel.getShots() : 0;
        this.mTxtHits.setText("(" + Integer.toString(n) + "%)  " + Integer.toString(this.mModel.getHits()));
        this.mTxtForward.setText(Integer.toString(Angle.sForward));
        this.mTxtCalc.setText(Double.toString((double)Math.round(10.0 * this.mGame.getCalcTime()) / 10.0) + "ms");
    }
}

