/*
 * Decompiled with CFR 0.152.
 */
package asteroid.ui;

import asteroid.model.GameModel;
import asteroid.statistic.GameValues;
import asteroid.ui.GameView;
import asteroid.ui.ListView;
import asteroid.ui.SampleView;
import asteroid.ui.StatusView;
import asteroid.ui.TestView;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 3632598983042456571L;
    public static final int INDEX_GAME = 1;
    public static final int INDEX_LIST = 2;
    public static final int INDEX_HIGH = 3;
    public static final int INDEX_TEST = 4;
    public static final int INDEX_SAMPLE = 5;
    private static final String ICON_DIR = "/asteroid/pictures/";
    private JButton mBtnAuto = new JButton(new MainAction("auto.gif", "auto", "Spiel starten."));
    private JToggleButton mBtnGame = new JToggleButton(new MainAction("game.gif", "game", "Spiel Simulation anzeigen."));
    private JToggleButton mBtnHigh = new JToggleButton(new MainAction("high.gif", "high", "Hoechstergebnisse anzeigen."));
    private JToggleButton mBtnIdent = new JToggleButton(new MainAction("ident.gif", "ident", "Objektbezeichnung anzeigen."));
    private JToggleButton mBtnList = new JToggleButton(new MainAction("list.gif", "list", "ROM Listing anzeigen."));
    private JToggleButton mBtnNone = new JToggleButton(new MainAction("nothing.gif", "none", "keine Darstellung"));
    private JToggleButton mBtnRepeat = new JToggleButton(new MainAction("repeat.gif", "repeat", "Mehrere Spiel automatisch starten."));
    private JToggleButton mBtnSample = new JToggleButton(new MainAction("sample.gif", "sample", "Sample darstellen."));
    private JToggleButton mBtnTest = new JToggleButton(new MainAction("test.gif", "test", "Kollision testen."));
    private JToggleButton mBtnTop = new JToggleButton(new MainAction("top.gif", "top", "Spieler in Bestenliste eintragen."));
    private JToggleButton mBtnVelo = new JToggleButton(new MainAction("velocity.gif", "velo", "Geschwindigkeitvektoren anzeigen."));
    private GameView mGameView;
    private int mLastType;
    private JComponent mListView;
    private GameModel mModel;
    private int mOffset;
    private JComponent mSampleView = new SampleView();
    private StatusView mStatusView;
    private JComponent mTestView = new TestView();
    static /* synthetic */ Class class$asteroid$ui$MainFrame;

    public MainFrame(GameModel gameModel, GameValues gameValues) {
        super("Asteroids");
        this.mModel = gameModel;
        this.mLastType = gameModel.getFrameType();
        this.setDefaultCloseOperation(3);
        this.mListView = new ListView(gameModel);
        this.mGameView = new GameView(gameModel);
        this.mStatusView = new StatusView(gameModel, gameValues, 640, 130);
        this.getContentPane().add((Component)this.createToolBar(), "North");
        this.getContentPane().add((Component)this.mStatusView, "Center");
        this.getContentPane().add((Component)this.createViews(), "South");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mBtnNone);
        buttonGroup.add(this.mBtnGame);
        buttonGroup.add(this.mBtnList);
        buttonGroup.add(this.mBtnTest);
        buttonGroup.add(this.mBtnSample);
        buttonGroup.add(this.mBtnHigh);
        this.updateButtons();
        this.mBtnVelo.setSelected(this.mGameView.isVelocity());
        this.mBtnIdent.setSelected(this.mGameView.isIdentifier());
        this.setView(1);
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        try {
            jToolBar.setRollover(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        jToolBar.add(this.mBtnAuto);
        jToolBar.add(this.mBtnRepeat);
        jToolBar.add(this.mBtnTop);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.add(this.mBtnNone);
        jToolBar.add(this.mBtnGame);
        jToolBar.add(this.mBtnList);
        jToolBar.add(this.mBtnSample);
        jToolBar.add(this.mBtnHigh);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.add(this.mBtnVelo);
        jToolBar.add(this.mBtnIdent);
        return jToolBar;
    }

    private Box createViews() {
        Box box = Box.createVerticalBox();
        box.add(this.mGameView);
        box.add(this.mListView);
        box.add(this.mTestView);
        box.add(this.mSampleView);
        return box;
    }

    public static Icon getIcon(String string) {
        try {
            URL uRL = (class$asteroid$ui$MainFrame == null ? (class$asteroid$ui$MainFrame = MainFrame.class$("asteroid.ui.MainFrame")) : class$asteroid$ui$MainFrame).getResource(ICON_DIR + string);
            if (uRL != null) {
                return new ImageIcon(uRL);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    public void refresh() {
        if (this.mGameView.isVisible()) {
            this.mGameView.repaint();
        }
        if (this.mTestView.isVisible()) {
            this.mTestView.repaint();
        }
        if (this.mSampleView.isVisible()) {
            this.mSampleView.repaint();
        }
        if (this.mListView.isVisible()) {
            this.mListView.repaint();
        }
        switch (++this.mOffset & 0xF) {
            case 4: {
                this.mStatusView.updateView();
                break;
            }
            case 8: {
                this.updateTitle();
                this.updateButtons();
            }
        }
    }

    private void updateButtons() {
        this.mBtnAuto.setEnabled(this.mModel.getFrameType() == 1 || this.mModel.getFrameType() == 2);
        this.mBtnRepeat.setSelected(this.mModel.isAutoStart());
        this.mBtnTop.setSelected(this.mModel.isTopList());
    }

    private void updateTitle() {
        if (this.mModel.getFrameType() != this.mLastType) {
            this.mLastType = this.mModel.getFrameType();
            switch (this.mLastType) {
                case 1: 
                case 2: {
                    this.setTitle("Asteroids");
                    break;
                }
                case 3: {
                    this.setTitle("Asteroids: Spiel beginnt gleich!");
                    break;
                }
                case 4: {
                    this.setTitle("Asteroids: Spiel aktiv...");
                    break;
                }
                case 5: {
                    this.setTitle("Asteroids: Spiel zu Ende");
                    break;
                }
                case 6: {
                    this.setTitle("Asteroids: Das Spiel ist zu Ende.");
                    break;
                }
                case 7: {
                    this.setTitle("Asteroids: Eintrag in die Bestenliste.");
                }
            }
        }
    }

    public void setView(int n) {
        switch (n) {
            case 1: {
                this.mBtnGame.setSelected(true);
                this.mGameView.setVisible(true);
                this.mListView.setVisible(false);
                this.mTestView.setVisible(false);
                this.mSampleView.setVisible(false);
                this.mGameView.setShowScore(false);
                break;
            }
            case 2: {
                this.mBtnList.setSelected(true);
                this.mGameView.setVisible(false);
                this.mListView.setVisible(true);
                this.mTestView.setVisible(false);
                this.mSampleView.setVisible(false);
                break;
            }
            case 3: {
                this.mBtnHigh.setSelected(true);
                this.mGameView.setVisible(true);
                this.mListView.setVisible(false);
                this.mTestView.setVisible(false);
                this.mSampleView.setVisible(false);
                this.mGameView.setShowScore(true);
                break;
            }
            case 4: {
                this.mBtnTest.setSelected(true);
                this.mGameView.setVisible(false);
                this.mListView.setVisible(false);
                this.mTestView.setVisible(true);
                this.mSampleView.setVisible(false);
                break;
            }
            case 5: {
                this.mBtnSample.setSelected(true);
                this.mGameView.setVisible(false);
                this.mListView.setVisible(false);
                this.mTestView.setVisible(false);
                this.mSampleView.setVisible(true);
                break;
            }
            default: {
                this.mBtnNone.setSelected(true);
                this.mGameView.setVisible(false);
                this.mListView.setVisible(false);
                this.mTestView.setVisible(false);
                this.mSampleView.setVisible(false);
            }
        }
        this.pack();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MainAction
    extends AbstractAction {
        private static final long serialVersionUID = -7638695993616867697L;

        MainAction(String string, String string2, String string3) {
            Icon icon = MainFrame.getIcon(string);
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            } else {
                this.putValue("Name", string);
            }
            this.putValue("ShortDescription", string3);
            this.putValue("ActionCommandKey", string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("auto".equals(actionEvent.getActionCommand())) {
                MainFrame.this.mBtnAuto.setEnabled(false);
                MainFrame.this.mModel.setAutoStart();
            } else if ("repeat".equals(actionEvent.getActionCommand())) {
                MainFrame.this.mModel.setRepeat(MainFrame.this.mBtnRepeat.isSelected());
            } else if ("top".equals(actionEvent.getActionCommand())) {
                MainFrame.this.mModel.setTopList(MainFrame.this.mBtnTop.isSelected());
            } else if ("velo".equals(actionEvent.getActionCommand())) {
                MainFrame.this.mGameView.setVelocity(MainFrame.this.mBtnVelo.isSelected());
            } else if ("ident".equals(actionEvent.getActionCommand())) {
                MainFrame.this.mGameView.setIdentifier(MainFrame.this.mBtnIdent.isSelected());
            } else if ("none".equals(actionEvent.getActionCommand())) {
                MainFrame.this.setView(0);
            } else if ("game".equals(actionEvent.getActionCommand())) {
                MainFrame.this.setView(1);
            } else if ("list".equals(actionEvent.getActionCommand())) {
                MainFrame.this.setView(2);
            } else if ("high".equals(actionEvent.getActionCommand())) {
                MainFrame.this.setView(3);
            } else if ("test".equals(actionEvent.getActionCommand())) {
                MainFrame.this.setView(4);
            } else if ("sample".equals(actionEvent.getActionCommand())) {
                MainFrame.this.setView(5);
            }
        }
    }
}

