/*
 * Decompiled with CFR 0.152.
 */
package asteroid.strategy.measure;

import asteroid.Operation;
import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.Ship;
import asteroid.model.TargetInfo;
import asteroid.strategy.measure.AMeasure;

public class Intersect
extends AMeasure {
    private static final int MAX_ROT = 32;
    private double mFakt;
    private int mS0;
    private int mT0;
    private int mDv2;
    private Ship mShip;

    public Intersect(Ship ship, double d) {
        this.mShip = ship;
        this.mFakt = d;
    }

    protected void measure(AEnemy aEnemy) {
        TargetInfo targetInfo = aEnemy.getInfo();
        int n = aEnemy.getMoveX8() - Angle.vShotX(targetInfo.getDirection());
        int n2 = aEnemy.getMoveY8() - Angle.vShotY(targetInfo.getDirection());
        this.mDv2 = n * n + n2 * n2;
        if (this.mDv2 == 0) {
            this.mT0 = -1;
            this.mS0 = -1;
            return;
        }
        int n3 = Operation.signX8(aEnemy.getX8() - this.mShip.getX8());
        int n4 = Operation.signY8(aEnemy.getY8() - this.mShip.getY8());
        int n5 = n3 * n2 - n4 * n;
        this.mS0 = (int)Math.sqrt((double)(n5 * n5 / this.mDv2) + 0.5);
        if (this.mS0 > this.mShip.size() + aEnemy.size() + 24) {
            this.mT0 = -1;
            this.mS0 = -1;
            return;
        }
        int n6 = n3 * n + n4 * n2;
        this.mT0 = -n6 / this.mDv2;
        if (this.mT0 < 0) {
            this.mT0 = -1;
            return;
        }
        if (this.mT0 > 32) {
            return;
        }
        this.mT0 = 32 - this.mT0;
        aEnemy.mWeight -= this.mFakt * (double)this.mDv2 * (double)this.mT0;
    }

    protected void print(AEnemy aEnemy, PrintWriterFormat printWriterFormat) {
        printWriterFormat.print(this.mS0);
        printWriterFormat.print(':');
        printWriterFormat.print(this.mT0);
        if (this.mT0 > 0) {
            printWriterFormat.print(':');
            printWriterFormat.print((double)Math.round(-1000.0 * this.mFakt * (double)this.mDv2 * (double)this.mT0) / 1000.0);
        }
        printWriterFormat.fill(20);
    }
}

