/*
 * Decompiled with CFR 0.152.
 */
package asteroid.printer;

import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.Asteroid;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.Shot;
import asteroid.model.Ufo;
import asteroid.printer.APrinter;
import java.io.PrintStream;

public class Shortly
extends APrinter {
    private int mFrame;
    private GameModel mModel;

    public Shortly(GameModel gameModel, String string) {
        super(string);
        this.mModel = gameModel;
    }

    public Shortly(GameModel gameModel, PrintStream printStream) {
        super(printStream);
        this.mModel = gameModel;
    }

    public void forAsteroid(Asteroid asteroid) {
        switch (asteroid.getState()) {
            case 1: {
                this.forFlyable("A" + asteroid.getIndex(), asteroid);
                break;
            }
            case 2: {
                this.forFlyable("E" + asteroid.getIndex(), asteroid);
                break;
            }
            case 3: {
                this.forFlyable("e" + asteroid.getIndex(), asteroid);
                break;
            }
            case 0: {
                this.forFlyable("a" + asteroid.getIndex(), asteroid);
            }
        }
    }

    private void forFlyable(String string, AFlyable aFlyable) {
        this.mOut.savePos();
        this.mOut.print(string);
        this.mOut.print(':');
        if (aFlyable != null) {
            this.printFlyable(aFlyable);
        }
        this.mOut.fill(28);
    }

    public void forShip(Ship ship) {
        switch (ship.getState()) {
            case 1: {
                this.forFlyable("S", ship);
                break;
            }
            case 2: {
                this.forFlyable("T", ship);
                break;
            }
            case 4: {
                this.forFlyable("J", ship);
                break;
            }
            case 0: {
                this.forFlyable("s", ship);
            }
        }
    }

    public void forShot(Shot shot) {
        switch (shot.getState()) {
            case 1: {
                this.forShot("M" + shot.getIndex(), shot);
                break;
            }
            case 0: {
                this.forShot("_" + shot.getIndex(), shot);
            }
        }
    }

    private void forShot(String string, Shot shot) {
        this.mOut.savePos();
        this.mOut.print(string);
        this.mOut.print(':');
        if (shot != null) {
            this.printFlyable(shot);
            if (shot.isVisible() && shot.getHitTime() < 100.0) {
                this.mOut.print(',');
                this.mOut.print((double)Math.round(10.0 * shot.getHitTime()) / 10.0);
            }
        }
        this.mOut.fill(34);
    }

    public void forUfo(Ufo ufo) {
        switch (ufo.getState()) {
            case 1: {
                this.forFlyable("U", ufo);
                break;
            }
            case 2: {
                this.forFlyable("X", ufo);
                break;
            }
            case 0: {
                this.forFlyable("u", ufo);
            }
        }
    }

    public void print() {
        this.mOut.savePos();
        this.mOut.print(this.mFrame++);
        this.mOut.print(',');
        this.mOut.printKey(Angle.sSendKey);
        this.mOut.print(',');
        this.mOut.printByte(Angle.sReceivePing);
        this.mOut.print(',');
        this.mOut.printByte(Angle.sSendPing);
        this.mOut.print(',');
        this.mOut.printByte(Angle.sDirection);
        this.mOut.print(',');
        this.mOut.print(Angle.sForward);
        int n = Angle.getShipIndex(this.mModel.getShip().getDx(), this.mModel.getShip().getDy());
        this.mOut.print(',');
        this.mOut.printByte(Angle.getMinAngle(n));
        this.mOut.print(',');
        this.mOut.printByte(Angle.getMaxAngle(n));
        this.mOut.fill(36);
        this.mModel.forShip(this);
        this.mModel.forAllShots(this);
        this.mModel.forAllAsteroids(this);
        this.mModel.forUfo(this);
        this.mOut.println();
    }

    private void printFlyable(AFlyable aFlyable) {
        this.mOut.printPos(aFlyable.isHidden() ? 0 : aFlyable.getX8());
        this.mOut.print(',');
        this.mOut.printPos(aFlyable.isHidden() ? 0 : aFlyable.getY8());
        this.mOut.print(',');
        this.mOut.printZoom(aFlyable.getZ());
        this.mOut.print(',');
        this.mOut.printSign(aFlyable.isVisible() ? aFlyable.getMoveX8() : 0);
        this.mOut.print(',');
        this.mOut.printSign(aFlyable.isVisible() ? aFlyable.getMoveY8() : 0);
        this.mOut.print(',');
        if (aFlyable.getCreate() > 0) {
            this.mOut.print(aFlyable.getCreate());
        } else {
            this.mOut.print('.');
        }
        if (aFlyable.getVanish() > 0) {
            this.mOut.print(aFlyable.getVanish());
        } else {
            this.mOut.print('.');
        }
    }
}

