/*
 * Decompiled with CFR 0.152.
 */
package asteroid.model;

import asteroid.Operation;
import asteroid.model.AFlyable;
import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.model.Ship;
import asteroid.model.TargetInfo;

public abstract class AEnemy
extends AFlyable {
    public static int sLimit;
    public double mWeight;
    int mDirectionOld;
    int mStepsOld;
    int mTimeShotOld;
    int mTimeEnemyOld;
    int mType;
    int mFire;
    private double mAlpha;
    private double mGamma;
    private TargetInfo mInfo = new TargetInfo();
    private double mTime;

    AEnemy() {
    }

    AEnemy(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
    }

    public double getAlpha() {
        return this.mInfo.getAlpha();
    }

    public double getAlpha(Ship ship, int n) {
        double d = Math.abs(Angle.signRot(this.mAlpha - Angle.sRadiant)) / 3.0;
        double d2 = Operation.signX8(this.getX8(d += (double)n) - (double)ship.mX8);
        double d3 = Operation.signY8(this.getY8(d) - (double)ship.mY8);
        double d4 = Math.atan2(d3, d2);
        double d5 = this.getVelocity8();
        double d6 = Angle.vShot(this.mDirectionOld);
        double d7 = this.getBetha() - d4;
        double d8 = Math.asin(d5 * Math.sin(d7) / d6);
        double d9 = d5 * Math.cos(d7);
        double d10 = d6 * Math.cos(d8);
        if (d10 < d9) {
            d8 = Math.PI - d8;
            d10 = -d10;
        }
        return d4 + d8;
    }

    public boolean canFire() {
        return this.mFire > sLimit;
    }

    public void decFire() {
        --this.mFire;
    }

    public int getDirection() {
        return this.mDirectionOld;
    }

    public void setDirection(Ship ship, int n) {
        double d = Math.abs(Angle.signRot(this.mAlpha - Angle.sRadiant)) / 3.0;
        double d2 = Operation.signX8(this.getX8(d += (double)n) - (double)ship.mX8);
        double d3 = Operation.signY8(this.getY8(d) - (double)ship.mY8);
        this.mGamma = Math.atan2(d3, d2);
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = this.getVelocity8();
        double d6 = Angle.vShot(this.mDirectionOld);
        double d7 = this.getBetha() - this.mGamma;
        double d8 = Math.asin(d5 * Math.sin(d7) / d6);
        double d9 = d5 * Math.cos(d7);
        double d10 = d6 * Math.cos(d8);
        if (d10 < d9) {
            d8 = Math.PI - d8;
            d10 = -d10;
        }
        this.mAlpha = this.mGamma + d8;
        this.mDirectionOld = Angle.getAngle(this.mAlpha);
        this.mTime = d4 / (d10 - d9);
    }

    public double getDistance(Ship ship) {
        return Math.sqrt(this.getDistance2(ship));
    }

    public int getDistance2(Ship ship) {
        int n = Operation.signX8(this.mX8 - ship.mX8);
        int n2 = Operation.signY8(this.mY8 - ship.mY8);
        return n * n + n2 * n2;
    }

    public abstract boolean isFired();

    public double getGamma() {
        return this.mGamma;
    }

    public abstract int getID();

    public void incFire() {
        ++this.mFire;
    }

    public TargetInfo getInfo() {
        return this.mInfo;
    }

    public void init(Ship ship) {
        this.mInfo.calculate(this, ship, Angle.sDirection, GameModel.sFrame, GameModel.sFrame);
    }

    public abstract void initFire();

    void move(int n) {
        this.mX8 += n * this.mMoveX8;
        this.mY8 += n * this.mMoveY8;
    }

    public double getTime() {
        return this.mTime;
    }

    public int getType() {
        return this.mType;
    }
}

