#ifndef _P2D_H_
#define _P2D_H_

#include <iostream>
#include <cmath>

static const double EPSILON=10E-10;

class p2d
{	public:
	double	x,y;
	p2d()
	{	x=y=0;
	}
	p2d(const p2d &p)
	{	x=p.x;
		y=p.y;
	}	
	p2d(double x_,double y_)
	{	x=x_;
		y=y_;
	}
	p2d operator - (const p2d &p) const
	{	return p2d(x-p.x,y-p.y);
	}
	p2d operator + (const p2d &p) const
	{	return p2d(x+p.x,y+p.y);
	}
	p2d operator * (double z) const
	{	return p2d(x*z,y*z);
	}
	bool operator == (const p2d &p) const
	{	return fabs(x-p.x)<EPSILON && fabs(y-p.y)<EPSILON;
	}
	bool operator !=(const p2d &p) const
	{	return !(*this==p);
	}
	p2d& operator -= (const p2d &p)
	{	x-=p.x;
		y-=p.y;
		return *this;
	}	
	p2d& operator += (const p2d &p)
	{	x+=p.x;
		y+=p.y;
		return *this;
	}	
	p2d operator *= (double z)
	{	x*=z;
		y*=z;
		return *this;
	}	
	p2d operator /= (double z)
	{	x/=z;
		y/=z;
		return *this;
	}	
	p2d operator - ()
	{	return p2d(-x,-y);
	}
	double magnitude() const
	{	return sqrt(x*x+y*y);
	}
	p2d operator / (double z) const
	{	return p2d(x/z,y/z);
	}
	void normalize()
	{	*this/=magnitude();
	}
	// clockwise
	inline const p2d& rotate(double a)
	{	double h=x*cos(a)+y*sin(a);
		y=y*cos(a)-x*sin(a);
		x=h;
		return *this;
	}	
};	

extern const p2d non_p2d;

std::ostream& operator << (std::ostream&,const p2d&);

#endif

