/*

     ASTEROID.H

     Header File

*/

#include <winsock2.h>

#include <windows.h>
#include <wincon.h>
#include <wingdi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <share.h>
#include <math.h>
#include <float.h>
#include <io.h>
#include <time.h>
#include <sys\timeb.h>
#include <sys\stat.h>
#include <process.h>
#include <signal.h>
#include <conio.h>
#include <direct.h>
#include <winbase.h>
#include <errno.h>

#define PID    int
#define TID    int
#define PTID   int*
#define PPID   int*
#define TERMINATE_THREAD _endthread()
#define PFNTHREAD LPTHREAD_START_ROUTINE 
#define _System          /* nix */

#define AST_PORT_NO    1979

#define KEY_HYPER   0x01 
#define KEY_FIRE    0x02
#define KEY_THRUST  0x04
#define KEY_RIGHT   0x08
#define KEY_LEFT    0x10



/* Die Opcodes des Vektor-Generators --------------------------------------------------- */

#define OPC_LABS       0x0A000
#define OPC_HALT       0x0B000
#define OPC_JSRL       0x0C000
#define OPC_RTSL       0x0D000
#define OPC_JMPL       0x0E000
#define OPC_SVEC       0x0F000
#define OPC_VCTR       0x00000 /* alle anderen ;-) */
#define VEC_SHIP       0x06000
#define VEC_SHOT       0x0



/* ------------------------- Byte Alignment -------------------------------------------- */
#pragma pack( push, asterpck, 1 )

typedef struct _framepack {
   char vecram[1024] ;
   char framno  ;     // wird bei jedem Frame inkrementiert
   char pingct  ;     // Der Server schickt das letzte empfangene ping-Byte zurck
} FRAMEPACK ;

typedef struct _keypck {
	char signat[6] ;
	char keycod    ;
	char pingct    ; // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.
} KEYPACK ;

#pragma pack( pop, asterpck )
/* ------------------------- Byte Alignment -------------------------------------------- */

#define OBJ_NIXNIX  0
#define OBJ_ASTER1  0x31545341
#define OBJ_ASTER2  0x32545341
#define OBJ_ASTER3  0x33545341
#define OBJ_ASTER4  0x34545341
#define OBJ_MYSHIP  0x50494853
#define OBJ_A_SHOT  0x544F4853
#define OBJ_UFOUFO  0x214F4655

#define DEPTH_ORIENTATION_STACK  8 /* ? Anzahl der Bewegungs-Schritte des 6502 Programms */
#define DEPTH_LOOKAHEAD       1024 /* So tief mchte ich abschtzen drfen               */
#define MAX_OBJECTS             64 /* Hoffentlich gibt es nicht mehr Objekte             */

typedef struct _objrec {
	int     obj_type ;    /* Der Objekt-Typ, siehe OBJ_... #defines                      */
	int     obj_size ;    /* Grsse des Objektes (ungefhr)                              */
	int     obj_dist ;    /* Entfernung zum Schiff (Scratch)                             */
	int     obj_dreh ;    /* Notwendige Drehungen (- links, + rechts)                    */
	int     obj_manz ;    /* Anzahl Wertepaare im Bewegungs-Rckschau-Stack              */
	int     obj_wpos ;    /* Nchste Schreibposition im Rckschau-Stack                  */
	int     obj_kolf ;    /* Kollisions-Flag != 0, dieses Objekt wird treffen in...      */
	int     obj_kolt ;    /* ... sovielen Schritten ab jetzt                             */
	int     obj_mysh ;    /* Es ist mein Schuss (ungefhrlich), drauf geschossen, warten */
	int     obj_tart ;    /* Typ des Ziels                                               */
	int     obj_tarx ;    /* OBJ_A_SHOT: Koordinaten des Ziels                           */
	int     obj_tary ;    /*             Koordinaten des Ziels                           */
	double  obj_xpos ;    /* Aktuelle Position horizontal                                */
	double  obj_ypos ;    /* Aktuelle Position vertikal                                  */
	double  obj_angl ;    /* Flugwinkel, resp. Orientierung des Schiffs                  */
	double  obj_xdif[DEPTH_ORIENTATION_STACK] ; /* Bewegungsmustr des Objekts (0,1,..,8) */
	double  obj_ydif[DEPTH_ORIENTATION_STACK] ; /*                                       */
	int     obj_ixpo[DEPTH_LOOKAHEAD] ; /* Die Look-Ahead-Tabelle des Objektes: da wird  */
	int     obj_iypo[DEPTH_LOOKAHEAD] ; /* das Ding in den nchsten n Takten wohl sein   */
} OBJREC ;

#define PI     3.141592654
#define SQRT2  1.414213562

#define TRACE_DUMP    0x0001
#define TRACE_DECODE  0x0002
#define TRACE_FRAME   0x0004
#define TRACE_SEND    0x0008
#define TRACE_SHOTS   0x0010
#define TRACE_PICKS   0x0020

#define SUCH_RADIUS      9.5

#define THREAD_0_BIT   0x001
#define THREAD_1_BIT   0x002
#define THREAD_2_BIT   0x004
#define THREAD_3_BIT   0x008
#define THREAD_4_BIT   0x010
#define THREAD_5_BIT   0x020
#define THREAD_6_BIT   0x040
#define THREAD_7_BIT   0x080
#define THREAD_8_BIT   0x100


#define SHOT_LOOK_AHEAD    16
/* ---------------------------------------------------------------------------------------------------- */
/* "Schusstabelle" so (ungefhr ;-) ) fliegen die Schsse in Abhngigkeit vom "Schiffswinkel"           */
/* ---------------------------------------------------------------------------------------------------- */
typedef struct _shotable {
   double sht_ship_x     ;
   double sht_ship_y     ;
   double sht_ship_a     ;
   double sht_shot_a     ;
   int    sht_init_x     ;
   int    sht_init_y     ;
   int    sht_dif_xy[SHOT_LOOK_AHEAD] ;
} SHOTRECORD ;

