// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"
#include <math.h>
#include <fstream>
#include <iomanip>
using namespace std;

ofstream file("werte.txt",ios_base::out);
int counter = 0;
int shotcounter = -1;

void Player::Run(void)
{
	FramePacket frame;
	KeysPacket keys;
	GameStatus game;
	char prevframe = 0;
	int t = 0;

	for (;;)
	{
		++t;         // Zeit
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		SendPacket(keys);
		ReceivePacket(frame);

		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
		{
			printf("Latenz %d. %d Frames verloren.\n", keys.ping - frame.ping, frame.frameno - prevframe);
			prevframe = frame.frameno;
		}

		InterpretScreen(frame, game);

		keys.clear();   // alle Tasten loslassen

		if(game.shotThisFrame)
		{
			game.shotLastFrame = true;
			game.shotThisFrame = false;
		}

		if(game.ship.isPresent)
		{
			//cout << game.ship.shotVector->getcurrentpos() << "\n";
			game.dirsync.push(game.ship.shotVector->getcurrentpos());
			if(game.dirsync.size() >= 2)
			{
				bool syncfound = false;
				if(game.ship.shotVector->getSyncVec(game.dirsync.front()) != game.ship.dir)
				{
					int syncloss = 0;
					int synclocation;
					for(int j = 1; j < 5; j++)
					{
						synclocation = game.dirsync.front()+j;
						if(synclocation > 255)
							synclocation -= 256;
						if(!syncfound && game.ship.dir == game.ship.shotVector->getSyncVec(synclocation))
						{
							syncloss = j;
							cout << "Syncloss: " << syncloss << "\n";
							for(int i = 0; i < j; i++)
								game.ship.shotVector->increment();
							syncfound = true;
						}
						synclocation = game.dirsync.front()-j;
						if(synclocation < 0)
							synclocation += 256;
						if(!syncfound && game.ship.dir == game.ship.shotVector->getSyncVec(synclocation))
						{
							syncloss = -j;
							cout << "Syncloss: " << syncloss << "\n";
							for(int i = 0; i < j; i++)
								game.ship.shotVector->decrement();
							syncfound = true;
						}
						if(syncfound)
						{
							while(!game.dirsync.empty())
								game.dirsync.pop();
							break;
						}
					}
				}
				if(!syncfound)
					game.dirsync.pop();
			}
		}
		else if(!game.dirsync.empty())
		{
			game.dirsync.pop();
		}
		if(game.ship.isPresent && (game.asteroids.size() > 0 || game.ufo.isPresent || game.shots.size() > 0))
		{
			game.minDist = 0x7fffffff;
			for (int i=0; i<game.asteroids.size(); i++)
			{  
				game.asteroids[i]->calcRelationsToShip(game.ship);
				if((game.asteroids[i]->distanceToShip - game.asteroids[i]->rcol) < game.minDist)
					game.minDist = game.asteroids[i]->distanceToShip - game.asteroids[i]->rcol;
			}
			for (int i=0; i<game.shots.size(); i++)
			{
				if(!game.shots[i]->PlayerShot)
				{
					Vector2D distToShip = game.shots[i]->position - game.ship.position;
					if(distToShip.Length()-5 < game.minDist)
						game.minDist = distToShip.Length() - 30;
				}
			}
			if(game.minDist <= game.ship.r)
			{
				keys.hyperspace(true);
				continue;
			}

			//Shoot anything you would hit
			if(!game.shotLastFrame && game.playerShots < 4)
			{
				for(int i = 0; i < game.asteroids.size(); i++)
				{
					if((game.asteroids[i]->distanceToShip < 550 && game.asteroids[i]->shotAt == false) || (game.asteroids[i]->willCollide && game.asteroids[i]->distanceToShip < 100))
					{
						if(RaySphereIntersect(game.ship.position,game.asteroids[i]->aimLocation,game.asteroids[i]->r,game.ship.shotVector->getcurrentvec()))
						{
							keys.fire(true);
							game.shotThisFrame = true;
							game.asteroids[i]->nShots++;
							break;
						}
					}
				}
				if(!game.shotThisFrame && game.ufo.isPresent && game.ufo.shotAt == false)
				{
					if(RaySphereIntersect(game.ship.position, game.ufo.aimLocation, game.ufo.r, game.ship.shotVector->getcurrentvec()))
					{
						keys.fire(true);
						game.shotThisFrame = true;
						game.ufo.nShots++;
					}
				}
			}
			else
				game.shotLastFrame = false;

			//Evaluate where to turn if you didnt fire
			if(!game.shotThisFrame)
			{
				game.ufo.calcRelationsToShip(game.ship);
				// normalize & calculate priority
				for (int i=0; i<game.asteroids.size(); ++i)
				{
					if(game.asteroids[i]->shotAt == false && game.asteroids[i]->distanceToShip < 550)
					{
						game.asteroids[i]->prioAngle = 1 - (float)(game.asteroids[i]->angleToShipDEG / 180);
						game.asteroids[i]->prioDistToShip = (float)(200 / game.asteroids[i]->distanceToShip);
						if(game.asteroids[i]->willCollide)
							game.asteroids[i]->prioCollision = 1;
						else
							game.asteroids[i]->prioCollision = 0;
			            
						// Calculate total priority
						game.asteroids[i]->prioTotal = prioWeightAngle * game.asteroids[i]->prioAngle
								+	game.asteroids[i]->prioDistToShip * prioWeightDistToShip
								+   game.asteroids[i]->prioCollision * prioWeightCollision;
					}
					else
						game.asteroids[i]->prioTotal = 0;
				}
		        
				// determine target by maximum priority
				float prioMax = 0;
				
				for (int i=0; i<game.asteroids.size(); ++i) 
					prioMax = max(prioMax, game.asteroids[i]->prioTotal);
		        
				for (int i=0; i<game.asteroids.size(); ++i) 
				{  
					if (prioMax == game.asteroids[i]->prioTotal) 
						game.asterTarget = i;
					game.asteroids[i]->isTarget = false;
				}
		        
				// handle ufo
				if (game.ufo.isPresent && game.ufo.shotAt == false && game.ufo.distanceToShip < 550) 
				{             
					game.ufo.prioAngle = 1 - (float)(game.ufo.angleToShipDEG / 180);
					game.ufo.prioDistToShip = (float)(1 / game.ufo.distanceToShip);
		            
					// Calculate total priority
					game.ufo.prioTotal = 100;

					if(game.ufo.prioTotal > prioMax)
					{
						game.asterTarget = -1;
						game.ufo.isTarget = true;
						game.currentTarget = &game.ufo;
					}

				}
				else
				{  
					if (game.asterTarget>=0 && !game.asteroids.empty()) 
					{  
						game.asteroids[game.asterTarget]->isTarget = true;
						game.ufo.isTarget = false;
						game.currentTarget = game.asteroids[game.asterTarget];
					} 
					else
					{  
						game.currentTarget = NULL;
					}
				}
				//Turn towards next Target
				if(game.currentTarget != NULL)
				{
					if(game.currentTarget->rotationDir == 1)
					{
						keys.left(true);
						game.ship.shotVector->increment();
					}
					else if(game.currentTarget->rotationDir == -1)
					{
						keys.right(true);
						game.ship.shotVector->decrement();
					}
				}
			}
		}
		else
			game.playerShots = 0;
	}
}

void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;
	game.playerShots = 0;
	bool asteroidFound;
	bool shotFound;
	Asteroid* tAsteroid;
	Shot tShot;
	vector<Asteroid*>::iterator iterRoid;
	vector<Shot*>::iterator iterShot;
	game.ufo.isPresent = game.ufo.isDetected;

	game.clear();

	for(iterRoid = game.asteroids.begin(); iterRoid != game.asteroids.end();)
	{
		if(!(*iterRoid)->isPresent)
		{
			if((*iterRoid) == game.currentTarget)
				game.currentTarget = NULL;
			delete *iterRoid;
			iterRoid = game.asteroids.erase(iterRoid);
			//cout << "asteroid erased \n";
		}
		else
			iterRoid++;
	}

	for(iterShot = game.shots.begin(); iterShot != game.shots.end();)
	{
		if(!(*iterShot)->isPresent)
		{
			delete *iterShot;
			iterShot = game.shots.erase(iterShot);
			//cout << "shot erased \n";
		}
		else
			iterShot++;
	}

	for(iterRoid = game.asteroids.begin(); iterRoid != game.asteroids.end(); iterRoid++)
	{
		(*iterRoid)->isPresent = false;
	}

	for(iterShot = game.shots.begin(); iterShot != game.shots.end(); iterShot++)
	{
		(*iterShot)->isPresent = false;
	}
	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				tAsteroid = new Asteroid();
				tAsteroid->set(vx,vy,1,vs);
				asteroidFound = false;
				for(iterRoid = game.asteroids.begin(); iterRoid != game.asteroids.end(); iterRoid++)
				{
					if((*iterRoid)->isEqual(*tAsteroid))
					{
						//cout << "asteroid von typ 1 wieder gefunden\n";
						asteroidFound = true;
						(*iterRoid)->isPresent = true;
						if((*iterRoid)->updateCounter < 7)
						{
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].x = tAsteroid->position.x - (*iterRoid)->position.x;
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].y = tAsteroid->position.y - (*iterRoid)->position.y;
						}
						else if((*iterRoid)->updateCounter == 7)
						{
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].x = tAsteroid->position.x - (*iterRoid)->position.x;
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].y = tAsteroid->position.y - (*iterRoid)->position.y;
							float totx = 0;
							float toty = 0;
							for(int i = 0; i < 8; i++)
							{
								totx += (*iterRoid)->dirplotting[i].x;
								toty += (*iterRoid)->dirplotting[i].y;
							}
							(*iterRoid)->dir.x = totx/8;
							(*iterRoid)->dir.y = toty/8;
							(*iterRoid)->plotted = true;
							(*iterRoid)->updateCounter = 0;
						}
						(*iterRoid)->updateCounter++;
						(*iterRoid)->position.x = tAsteroid->position.x;
						(*iterRoid)->position.y = tAsteroid->position.y;
						delete tAsteroid;
						break;
					}
				}
				if(!asteroidFound)
				{
					//cout << "asteroid von typ 1 entdeckt\n";
					game.asteroids.push_back(tAsteroid);
				}
				break;
			case 0x8ff:
				tAsteroid = new Asteroid();
				tAsteroid->set(vx,vy,2,vs);
				asteroidFound = false;
				for(iterRoid = game.asteroids.begin(); iterRoid != game.asteroids.end(); iterRoid++)
				{
					
					if((*iterRoid)->isEqual(*tAsteroid))
					{
						asteroidFound = true;
						(*iterRoid)->isPresent = true;
						if((*iterRoid)->updateCounter < 7)
						{
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].x = tAsteroid->position.x - (*iterRoid)->position.x;
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].y = tAsteroid->position.y - (*iterRoid)->position.y;
						}
						else if((*iterRoid)->updateCounter == 7)
						{
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].x = tAsteroid->position.x - (*iterRoid)->position.x;
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].y = tAsteroid->position.y - (*iterRoid)->position.y;
							float totx = 0;
							float toty = 0;
							for(int i = 0; i < 8; i++)
							{
								totx += (*iterRoid)->dirplotting[i].x;
								toty += (*iterRoid)->dirplotting[i].y;
							}
							(*iterRoid)->dir.x = totx/8;
							(*iterRoid)->dir.y = toty/8;
							(*iterRoid)->plotted = true;
							(*iterRoid)->updateCounter = 0;
						}
						(*iterRoid)->updateCounter++;
						(*iterRoid)->position.x = tAsteroid->position.x;
						(*iterRoid)->position.y = tAsteroid->position.y;
						delete tAsteroid;
						break;
					}
				}
				if(!asteroidFound)
				{
					game.asteroids.push_back(tAsteroid);
				}
				break;
			case 0x90d:
				tAsteroid = new Asteroid();
				tAsteroid->set(vx,vy,3,vs);
				asteroidFound = false;
				for(iterRoid = game.asteroids.begin(); iterRoid != game.asteroids.end(); iterRoid++)
				{
					if((*iterRoid)->isEqual(*tAsteroid))
					{
						asteroidFound = true;
						(*iterRoid)->isPresent = true;
						if((*iterRoid)->updateCounter < 7)
						{
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].x = tAsteroid->position.x - (*iterRoid)->position.x;
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].y = tAsteroid->position.y - (*iterRoid)->position.y;
						}
						else if((*iterRoid)->updateCounter == 7)
						{
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].x = tAsteroid->position.x - (*iterRoid)->position.x;
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].y = tAsteroid->position.y - (*iterRoid)->position.y;
							float totx = 0;
							float toty = 0;
							for(int i = 0; i < 8; i++)
							{
								totx += (*iterRoid)->dirplotting[i].x;
								toty += (*iterRoid)->dirplotting[i].y;
							}
							(*iterRoid)->dir.x = totx/8;
							(*iterRoid)->dir.y = toty/8;
							(*iterRoid)->plotted = true;
							(*iterRoid)->updateCounter = 0;
						}
						(*iterRoid)->updateCounter++;
						(*iterRoid)->position.x = tAsteroid->position.x;
						(*iterRoid)->position.y = tAsteroid->position.y;
						delete tAsteroid;
						break;
					}
				}
				if(!asteroidFound)
				{
					//cout << "asteroid von typ 3 entdeckt\n";
					game.asteroids.push_back(tAsteroid);
				}
				break;
			case 0x91a:
				tAsteroid = new Asteroid();
				tAsteroid->set(vx,vy,4,vs);
				asteroidFound = false;
				for(iterRoid = game.asteroids.begin(); iterRoid != game.asteroids.end(); iterRoid++)
				{
					if((*iterRoid)->isEqual(*tAsteroid))
					{
						//cout << "asteroid von typ 4 wieder gefunden\n";
						asteroidFound = true;
						(*iterRoid)->isPresent = true;
						if((*iterRoid)->updateCounter < 7)
						{
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].x = tAsteroid->position.x - (*iterRoid)->position.x;
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].y = tAsteroid->position.y - (*iterRoid)->position.y;
						}
						else if((*iterRoid)->updateCounter == 7)
						{
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].x = tAsteroid->position.x - (*iterRoid)->position.x;
							(*iterRoid)->dirplotting[(*iterRoid)->updateCounter].y = tAsteroid->position.y - (*iterRoid)->position.y;
							float totx = 0;
							float toty = 0;
							for(int i = 0; i < 8; i++)
							{
								totx += (*iterRoid)->dirplotting[i].x;
								toty += (*iterRoid)->dirplotting[i].y;
							}
							(*iterRoid)->dir.x = totx/8;
							(*iterRoid)->dir.y = toty/8;
							(*iterRoid)->plotted = true;
							(*iterRoid)->updateCounter = 0;
						}
						(*iterRoid)->updateCounter++;
						(*iterRoid)->position.x = tAsteroid->position.x;
						(*iterRoid)->position.y = tAsteroid->position.y;
						delete tAsteroid;
						break;
					}
				}
				if(!asteroidFound)
				{
					//cout << "asteroid von typ 4 entdeckt\n";
					game.asteroids.push_back(tAsteroid);
				}				
				break;
			case 0x929:
				game.ufo.isDetected = true;
				if(game.ufo.isPresent == true)
				{
					game.ufo.dir.x = vx - game.ufo.position.x;
					game.ufo.dir.y = vy - game.ufo.position.y;
				}
				game.ufo.position.x = vx;
				game.ufo.position.y = vy;
				game.ufo.size = vs;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
			{
				tShot.set(vx,vy);
				shotFound = false;
				for(iterShot = game.shots.begin(); iterShot != game.shots.end(); iterShot++)
				{
					if((*iterShot)->isEqual(tShot))
					{
						//cout << "asteroid von typ 4 wieder gefunden\n";
						if((*iterShot)->PlayerShot)
							game.playerShots++;
						shotFound = true;
						(*iterShot)->isPresent = true;
						(*iterShot)->updateCounter++;

						if((*iterShot)->updateCounter == 1)
						{
							(*iterShot)->dir.x = tShot.position.x - (*iterShot)->position.x;
							(*iterShot)->dir.y = tShot.position.y - (*iterShot)->position.y;
						}
						else
						{
							(*iterShot)->dir.x = ((tShot.position.x - (*iterShot)->position.x)+(*iterShot)->dir.x)/2;
							(*iterShot)->dir.y = ((tShot.position.y - (*iterShot)->position.y)+(*iterShot)->dir.y)/2;
						}
						(*iterShot)->position.x = tShot.position.x;
						(*iterShot)->position.y = tShot.position.y;
					/*	if((!(*iterShot)->syncCheck) && ((*iterShot)->updateCounter > 3))
						{
							(*iterShot)->syncCheck = true;
							if((*iterShot)->PlayerShot)
							{
								Vector2D syncVec = (*iterShot)->dir;
								syncVec.Normalize();
								file.precision(15);
								file << counter++;
								file << ' ';
								file << setw(20) << syncVec.x;
								file << ' ';
								file << setw(20) << syncVec.y;
								file << ' ';
								file << setw(20) << game.shipdir.x;
								file << ' ';
								file << setw(20) << game.shipdir.y;
								file << "\n";*/
								//if(!game.dirsync.empty())
								//{
								//	if(!(syncVec == game.shotvector.getvec(game.dirsync.front())))
								//	{
								//		int syncloss = 0;
								//		for(int j = 1; j < 20; j++)
								//		{
								//			if(syncVec == game.shotvector.getvec(game.dirsync.front()+j))
								//			{
								//				syncloss = j;
								//				cout << "Syncloss: " << syncloss << "\n";
								//				game.shotvector.setIndex(game.shotvector.getcurrentpos()+syncloss);
								//			}
								//			if(syncVec == game.shotvector.getvec(game.dirsync.front()-j))
								//			{
								//				syncloss = -j;
								//				cout << "Syncloss: " << syncloss << "\n";
								//				game.shotvector.setIndex(game.shotvector.getcurrentpos()+syncloss);
								//			}
								//		}
								//		if(syncloss == 0)
								//			cout << "SYNC PROBLEM!!! FELIX BAUT SCHEISSE!!!\n";
								//	}
								//	game.dirsync.pop();
								//}
						//	}
						//}

						break;
					}
				}
				if(!shotFound)
				{
					//cout << "shot entdeckt\n";
					if((tShot.position.y < (game.ship.position.y + 30)) && (tShot.position.y > (game.ship.position.y - 30)) && (tShot.position.x < (game.ship.position.x + 30)) && (tShot.position.x > (game.ship.position.x - 30))) 
					{
						tShot.PlayerShot = true;
					}
					else if(tShot.position.y < 10 || tShot.position.x < 10 || tShot.position.y > 760 || tShot.position.x > 1015)
					{
						for(iterShot = game.shots.begin(); iterShot != game.shots.end(); iterShot++)
						{
							if(!(*iterShot)->isPresent && (*iterShot)->PlayerShot)
							{
								tShot.PlayerShot = true;
								tShot.syncCheck = true;
							}
						}
					}else
					{
						tShot.PlayerShot = false;
						tShot.syncCheck = true;
					}
					game.shots.push_back(new Shot(tShot));
					
				}				
			}
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship.isPresent = true;
					game.ship.position.x = vx;
					game.ship.position.y = vy;
					game.ship.dir.x = v1x - dx;
					game.ship.dir.y = v1y - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   
}





void Shot::set(int x, int y)
{
	this->position.x = x;
	this->position.y = y;
}

bool Shot::isEqual(Shot shot2)
{
	return((abs(this->position.x - shot2.position.x) +abs(this->position.y - shot2.position.y)) < 20);
}

void GameStatus::clear(void)
{
	ship.isPresent = false;
	ufo.isDetected = false;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}
