// /home/epsilon/Projects/Asteroid/ABot/Framework1/GLVisualizer/GLUfo.cs created with MonoDevelop
// User: epsilon at 23:21 22.04.2008
//

using System;
using GLUtils;
using Tao.OpenGl;


namespace GLVisualizer
{
	public class GLUfo : GLUtils.GLObject
	{
        // constructor: position, size
        public GLUfo(Vector3 position, Vector3 size)
			: base (position, size)
        {
			this.Color = new Vector3(0.0f, 1.0f, 0.0f);
        }

        // constructor: position
        public GLUfo(Vector3 position)
            : base(position, new Vector3(0.1f, 0.1f, 0.0f))
		{
			this.Color = new Vector3(0.0f, 1.0f, 0.0f);
		}
		
		public GLUfo()
			: base(new Vector3(0.0f, 0.0f, 0.0f), new Vector3(0.2f, 0.075f, 0.0f))
		{
			this.Color = new Vector3(0.0f, 1.0f, 0.0f);
		}
		
		public override void Draw()
		{
            Gl.glLoadIdentity(); // Reset The Current Modelview Matrix
            Gl.glTranslatef(thePosition.X, thePosition.Y, thePosition.Z);

            // XYZ-rotation
            // rotation angle must be given in degrees
            Gl.glRotatef((float)(180.0 / Math.PI * theRotation.X), 1.0f, 0.0f, 0.0f);
            Gl.glRotatef((float)(180.0 / Math.PI * theRotation.Y), 0.0f, 1.0f, 0.0f);
            Gl.glRotatef((float)(180.0 / Math.PI * theRotation.Z), 0.0f, 0.0f, 1.0f);

			GLScreen.UnbindTexture();
			
            if (theUseAlphaBlending)
            {
                Gl.glEnable(Gl.GL_BLEND);
                Gl.glColor4f(theColor.X, theColor.Y, theColor.Z, theAlphaBlending);
            }
            else
            {
                Gl.glDisable(Gl.GL_BLEND);
                Gl.glColor3f(theColor.X, theColor.Y, theColor.Z);
            }

           
            Gl.glBegin(Gl.GL_TRIANGLE_STRIP); // draw quad using a triangle strip
            {
                Gl.glVertex3f(-0.5f * theSize.X, -0.5f * theSize.Y, 0.0f); // left corner
                Gl.glVertex3f(-0.2f * theSize.X, 0.5f * theSize.Y, 0.0f); // upper left connection
                Gl.glVertex3f(-0.2f * theSize.X, -0.5f * theSize.Y, 0.0f); // lower left connection
                Gl.glVertex3f(0.2f * theSize.X, 0.5f * theSize.Y, 0.0f); // upper right connection
                Gl.glVertex3f(0.2f * theSize.X, -0.5f * theSize.Y, 0.0f); // lower right connection
                Gl.glVertex3f(0.5f * theSize.X, -0.5f * theSize.Y, 0.0f); // right corner
            }
            Gl.glEnd();	// done drawing the triangle strip

			Gl.glDisable(Gl.GL_BLEND);
		}
	}
}
