// /home/epsilon/Projects/Asteroid/ABot/Framework1/Framework1/IVisualizationPlugin.cs created with MonoDevelop
// User: epsilon at 16:50 19.04.2008
//

using System;

namespace Framework1
{
	// interface
	public interface IVisualizationPlugin : IPlugin
	{
		void StartVisualization();
		void StopVisualization();
	}
	
	// Template class
	public abstract class VisualizationPluginTemplate : IVisualizationPlugin
	{
		// fields
		private IPluginHost theHost;

		// properties
		public PluginTypes PluginType
		{
			get { return PluginTypes.VisualizationPlugin;}
		}
		
		public IPluginHost Host
		{
			set
			{
				theHost = value;
				theHost.RegisterPlugin(this);
			}
		}
		

		// methods
		public override string ToString()
		{
			return "VisualizationPlugin";
		}
		
		public virtual void UpdatePlayfield(Playfield playfield)
		{
		}

		public virtual void UpdateCurrentKeys(KeySet keys)
		{
		}

		public virtual void UpdateCalibration(GameCalibration calibration)
		{
		}
		
		public virtual void UpdateBotStatus(BotStatus status)
		{
		}

		public virtual void StartVisualization()
		{
		}

		public virtual void StopVisualization()
		{
		}
	}
}
