// /home/epsilon/Projects/Asteroid/ABot/Framework1/Framework1/IStatisticsPlugin.cs created with MonoDevelop
// User: epsilon at 16:50 19.04.2008
//

using System;

namespace Framework1
{
	// interface
	public interface IStatisticsPlugin : IPlugin
	{
		event ChangeCalibrationEventHandler ChangeCalibration;
	}
	
	// ChangeCalibrationEvent
	public delegate void ChangeCalibrationEventHandler(object sender, ChangeCalibrationEventArgs e);

	public class ChangeCalibrationEventArgs : EventArgs
	{
		public GameCalibration calibration;
	}

	// Template class
	public abstract class StatisticsPluginTemplate : IStatisticsPlugin
	{
		// fields
		private IPluginHost theHost;

		// properties
		public PluginTypes PluginType
		{
			get { return PluginTypes.StatisticsPlugin;}
		}
		
		public IPluginHost Host
		{
			set
			{
				theHost = value;
				theHost.RegisterPlugin(this);
			}
		}
		

		// methods
		public override string ToString()
		{
			return "StatisticsPlugin";
		}
		
		public virtual void UpdatePlayfield(Playfield playfield)
		{
		}

		public virtual void UpdateCurrentKeys(KeySet keys)
		{
		}

		public virtual void UpdateCalibration(GameCalibration calibration)
		{
		}
		
		public virtual void UpdateBotStatus(BotStatus status)
		{
		}

		// events
		public event ChangeCalibrationEventHandler ChangeCalibration;
		
		protected virtual void OnChangeCalibration(ChangeCalibrationEventArgs e)
		{
			if (ChangeCalibration != null)
				ChangeCalibration(this, e);
		}		
	}
}
