#ifndef SORTEDLIST_H_
#define SORTEDLIST_H_

#include "LinkedList.h"
#include "IComparable.h"

template<class T>
class SortedList:public LinkedList<T>
{
public:
	SortedList():LinkedList<T>()
	{
	}
	
	SortedList(const SortedList&ref):LinkedList<T>(ref)
	{
	}
	 
	T& addElement(T& data);
	using LinkedList<T>::addElement;
	
	using typename LinkedList<T>::Enumerator;
	
	using LinkedList<T>::getEnumerator;
};

template<class T>
T& SortedList<T>::addElement(T&data)
{	
	typename LinkedList<T>::LinkedListElement* newElement = new typename LinkedList<T>::LinkedListElement(data);
	
	if(this->first == 0)
	{
		this->first = this->last = newElement;
	}
	else
	{
		typename LinkedList<T>::LinkedListElement* current = this->first;
		while(current)
		{
			if(current->getData()> data)
			{
				if(current->getPrev() == 0)
				{
					current->setPrev(newElement);
					newElement->setNext(current);
					this->first = newElement;
				}
				else
				{
					current->getPrev()->setNext(newElement);
					newElement->setPrev(current->getPrev());
					newElement->setNext(current);
					current->setPrev(newElement);
				}
				break;
			}
			current = current->getNext();
		}
		
		if(!current)
		{
			this->last->setNext(newElement);
			newElement->setPrev(this->last);
			this->last = newElement;
		}	
		
	}
	
	return newElement->getData();
}


#endif /*SORTEDLIST_H_*/
