#ifndef SNAPSHOT_H_
#define SNAPSHOT_H_

#include "AsteroidSnapshot.h"
#include "UfoSnapshot.h"
#include "Explosion.h"
#include "ShotSnapshot.h"
#include "ShipSnapshot.h"
#include "AsteroidSnapshot.h"
#include <list>

using namespace std;

enum AsteroidPhaenoType
{
	AsteroidType1Small = 0,
	AsteroidType1Medium,
	AsteroidType1Big,
	AsteroidType2Small,
	AsteroidType2Medium,
	AsteroidType2Big,
	AsteroidType3Small,
	AsteroidType3Medium,
	AsteroidType3Big,
	AsteroidType4Small,
	AsteroidType4Medium,
	AsteroidType4Big
};
	

class Snapshot
{
private:
	list<AsteroidSnapshot> asteroids[12];
	
	int points;
	int highscore;
	int lives;
	
	list<ShotSnapshot> shots;
	list<Explosion> explosions;
	UfoSnapshot ufo;
	ShipSnapshot ship;
	
	unsigned char frameID;
	unsigned char outputID;
	
public:
	Snapshot(unsigned char frameID):
		frameID(frameID)
	{ }
	
	void setPoints(int points) { this->points = points; }
	int getPoints() { return points; }
	void setHighScore(int highscore) { this->highscore = highscore; }
	int getHighScore() { return highscore; }
	void setLives(int lives) { this->lives = lives; }
	int getLives() { return this->lives; }
	
	void addAsteroid(wxPoint pos,AsteroidPhaenoType index)
	{
		AsteroidSnapshot asteroid(pos, this->frameID); 
		asteroids[index].push_back(asteroid);
	}
	
	void addShot(wxPoint pos)
	{
		ShotSnapshot shot(pos, this->frameID); 
		shots.push_back(shot);
		
	}
	
	void addExplosion(wxPoint pos)
	{
		Explosion  explosion(pos, this->frameID); 
		explosions.push_back(explosion);
		
		/*explosion = new Explosion(pos,this->frameID);
		
		asteroidsAndExplosions[numberAsteroidsAndExplosions++] = explosion;*/
	}
	
	void addShip(ShipState state,wxPoint pos, Angle angle) { ship = ShipSnapshot(state,pos, angle, this->frameID); }
	
	void addUfo(wxPoint pos, UfoSize size) { ufo = UfoSnapshot(pos, this->frameID, size); }
	
	list<AsteroidSnapshot>* getAsteroids() { return asteroids; }
	
	list<ShotSnapshot>& getShots() { return shots; }
	
	list<Explosion>& getExplosions() { return explosions; }
	
	ShipSnapshot& getShip() { return ship; }
	
	UfoSnapshot& getUfo() { return ufo; }
	
	unsigned char getOutputID() { return outputID; }
	
	void setOutputID(unsigned char outputID) { this->outputID = outputID; }
	
	int getFrameID() { return frameID; }
	
	/*int getNumberAsteroidsAndExplosions()
	{
		return numberAsteroidsAndExplosions;
	}
	
	FlyingObjectSnapshot** getAsteroidsAndExplosions()
	{
		return asteroidsAndExplosions;
	}*/
};

#endif /*SNAPSHOT_H_*/
