#include "ActionSnapshot.h"
#include "Tools.h"

ActionSnapshot::ActionSnapshot(Ship & ship):
	ship(ship),
	numAsteroids(0),
	frames(0),
	gain(0),
	leftBestTarget(-1),
	rightBestTarget(-1),
	left(0),
	right(0),
	prev(0)
	{
	}
	
ActionSnapshot::ActionSnapshot(ActionSnapshot& snapshot)
{
	
	ShotAction action;
	int bestIndex;
	
	if(snapshot.getMinFrames() == snapshot.getLeftFrames())
	{
		action = snapshot.shotActions[snapshot.leftBestTarget];
		bestIndex = snapshot.leftBestTarget;
	}
	else
	{
		action = snapshot.shotActions[snapshot.rightBestTarget];
		bestIndex = snapshot.rightBestTarget;
	}
	
	ship = snapshot.ship;
	ship.setAbsolutePosition(Tools::calcPosition(ship.getAbsolutePosition(),ship.getFlightVector(),action.turnSteps));
	ship.setAngle(action.angle);
	
	frames = snapshot.frames+action.turnSteps;
	
	Asteroid* asteroid = (Asteroid*)action.ptr;
	
	if(asteroid->getAsteroidSize() == AsteroidSize::small)
		gain = 100;
	else if(asteroid->getAsteroidSize() == AsteroidSize::medium)
		gain = 50;
	else
		gain = 20;
			
	gain += snapshot.gain;
	
	numAsteroids=0;
	
	for(int i =0 ; i< snapshot.numAsteroids;i++)
	{
		if(i != bestIndex)
		{
			addAsteroid(snapshot.asteroids[i]);
			asteroids[numAsteroids-1].setAbsolutePosition(Tools::calcPosition(asteroids[numAsteroids-1].getAbsolutePosition(),asteroids[numAsteroids-1].getFlightVector(),action.turnSteps));
		}
	}
	
	leftBestTarget = -1;
	rightBestTarget= -1;
	
	prev = &snapshot;
	left = 0;
	right =0;
}

void ActionSnapshot::calcShotActions()
{
	for(int i = 0;i< numAsteroids;i++)
	{
		if(asteroids[i].getHits() ==0)
		{
			shotActions[i] = Tools::calcShotAction(ship,asteroids[i]);
			
			if(shotActions[i].shotFrames != -1)
			{
			
				if(shotActions[i].angle - ship.getAngle() >= 0  && (leftBestTarget == -1 || getCosts(leftBestTarget) > getCosts(i)))
				{
					leftBestTarget=i;			
				}
				if(shotActions[i].angle - ship.getAngle() <= 0 && (rightBestTarget == -1 || getCosts(rightBestTarget) > getCosts(i)))
					rightBestTarget = i;
			}
		}
	}

/*	
	if(leftBestTarget != -1)
		wxLogDebug("left: angle %d turnSteps %d wait %d shot %d",shotActions[leftBestTarget].angle,shotActions[leftBestTarget].turnSteps,shotActions[leftBestTarget].waitFrames,shotActions[leftBestTarget].shotFrames);
	
	if(rightBestTarget != -1)
		wxLogDebug("right: angle %d turnSteps %d wait %d shot %d",shotActions[rightBestTarget].angle,shotActions[rightBestTarget].turnSteps,shotActions[rightBestTarget].waitFrames,shotActions[rightBestTarget].shotFrames);
		*/
	
}
