package doertbrexel;

import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;

public class AsteroidGame
{

	/**
	 * @param args
	 * @throws UnknownHostException
	 * @throws SocketException
	 */
	public static void main(String[] args)
	{
		if (Constants.INFO)
			System.out.println("Start - " + AsteroidGame.class.getSimpleName() + ": "
					+ new Date());
		InetAddress server_ip = null;
		DatagramSocket datagramSocket = null;
		Player player = null;
		try
		{
			if (args.length < 1)
				server_ip = InetAddress.getByName(Constants.MAME_SERVER_ADDRESS);
			else
				server_ip = InetAddress.getByName(args[0]);
			datagramSocket = new DatagramSocket();
			datagramSocket.connect(server_ip, Constants.MAME_IN_PORT);
			player = new Player(datagramSocket);
			player.run();
		} catch (Exception e)
		{
			e.printStackTrace();
		} finally
		{
			if (player != null)
				player.close();
			if (datagramSocket != null)
				datagramSocket.close();
		}
		if (Constants.INFO)
			System.out.println("Ende: " + new Date());

	}

}
