package doertbrexel.spaceobjects;

import doertbrexel.util.Vector2D;

public abstract class SpaceObject
{
	// Aktuelle Koordinaten dieses Objekts
	public Vector2D	mLocation		= null;
	// Aktuelle Geschwindigkeit dieses Objekts
	public Vector2D	mVelocity		= new Vector2D(0, 0);
	// Quadrat der Entfernung zum Raumschiff
	// wird berechnet beim Aufruf der Methode calculateDistance2Ship
	int				mDistance2Ship	= 0x7fffffff;
	// Normierter Richtungsvektor vom Raumschiff auf dieses Objekt
	Vector2D		mDelta2Ship		= null;
	// Grssenkorrektur fr die Berechnung des Abstandes;
	protected int	mKorr			= 0;
	// Bewertung fr Abschuss
	public int		mRating			= 0;
	public int		mType			= -1;

	public SpaceObject(final int pX, final int pY)
	{
		mLocation = new Vector2D(pX, pY);
	}

	public float calculateDistance2Ship(SpaceObject pSpaceShip)
	{
		mDelta2Ship = mLocation.substract(pSpaceShip.mLocation).normalize();
		// Quadrat des Abstands zu diesem Objekt
		// Grsse des Objekts ber Korrekturwert bercksichtigen
		mDistance2Ship = mDelta2Ship.squaredLength() - mKorr;
		return mDistance2Ship;
	}

	public void calculateVelocity(SpaceObject pPreviousSpaceObject, int pLatency)
	{
		if (pPreviousSpaceObject != null)
		{
			int steps = pLatency + 1;
			mVelocity = mLocation.substract(pPreviousSpaceObject.mLocation).div(steps);
			System.out.println("v=" + mVelocity);
		}
	}

	public int getType()
	{
		return mType;
	}

	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		if (mType > 0)
			sb.append("type=").append(mType).append(" ");
		sb.append("loc=").append(mLocation).append(" ");
		if (mVelocity != null)
			sb.append("v=").append(mVelocity).append(" ");
		return sb.toString();
	}
}
