package doertbrexel.operations;

import doertbrexel.GameStatus;
import doertbrexel.ProcessorContext;

/**
 * @author G.Doert-Brexel
 * 
 * Schiebt die die Adresse des nchsten Befehls auf den Stack
 * und springt die absolute Adresse, die sich aus den Bits 0 ... 11 ergibt, an.
 * 
 */
public class JsrlOperation extends OneWordOperation
{
	private int		asteroidType	= -1;
	private int		explosionType	= -1;
	private boolean	isSaucer		= false;
	private String	mType			= null;

	protected JsrlOperation(int pAddressPointer, int pOpcode, int pFirstWord)
	{
		super(pAddressPointer, pOpcode, pFirstWord);
		switch (mFirstWord)
		{
			case 0x852 :
				mType = "Copyright";
				break;
			case 0x880 :
				explosionType = 3;
				mType = "Explosion";
				break;
			case 0x896 :
				explosionType = 2;
				mType = "Explosion";
				break;
			case 0x8B5 :
				explosionType = 1;
				mType = "Explosion";
				break;
			case 0x8f3 :
				asteroidType = 1;
				mType = "Asteroid";
				break;
			case 0x8ff :
				asteroidType = 2;
				mType = "Asteroid";
				break;
			case 0x90d :
				asteroidType = 3;
				mType = "Asteroid";
				break;
			case 0x91a :
				asteroidType = 4;
				mType = "Asteroid";
				break;
			case 0x929 :
				isSaucer = true;
				mType = "Saucer";
				break;
			case 0xA6D :
				mType = "Raumschiff aufrecht";
				break;
			case 0xB2C :
				mType = "Leerzeichen";
				break;
			default :
				if (mFirstWord >= 0xA78 && mFirstWord <= 0xB26)
					mType = "Buchstabe";
				else if (mFirstWord >= 0xB2E && mFirstWord <= 0xB63)
					mType = "Zahl";
				break;
		}
	}
	public String toString()
	{
		String result = getAddress() + " JSRL - " + super.toString();
		if (mType != null)
			result += " " + mType;
		if (asteroidType > 0)
			result += " " + mType + "(" + asteroidType + ")";
		else if (isSaucer)
			result += " " + mType;
		return result;
	}

	@Override
	public boolean execute(ProcessorContext processorContext, GameStatus pGameStatus)
	{
		//pProcessorContext.addressPointerStack[pProcessorContext.stackPointer++] = mAddressPointer;
		if (asteroidType > 0)
		{
			pGameStatus.addAsteroid(processorContext.absX, processorContext.absY,
					asteroidType, processorContext.globalScalingFactor);
		} else if (isSaucer)
		{
			pGameStatus.setSaucer(processorContext.absX, processorContext.absY,
					processorContext.globalScalingFactor);
		}
		return false;
	}
}
