package doertbrexel;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

import doertbrexel.GameStatus.AsteroidsIterator;
import doertbrexel.spaceobjects.Asteroid;
import doertbrexel.spaceobjects.FlyingSaucer;
import doertbrexel.spaceobjects.SpaceObject;
import doertbrexel.spaceobjects.SpaceShip;
import doertbrexel.util.Helper;

public class Player
{
	private static final float	GREAT_DISTANCE				= 400 * 400;
	private static final float	CRITICAL_DISTANCE			= 27 * 27;
	private static final float	CRITICAL_SAUCER_DISTANCE	= 300 * 300;

	private static class DecisionBean
	{
		public DecisionBean(SpaceShip pSpaceShip)
		{
			mSpaceShip = pSpaceShip;
		}

		private SpaceShip	mSpaceShip				= null;

		boolean				mHasCriticalDistance	= false;
		boolean				mHasGreatDistance		= true;
		float				mMaxWeight				= 0;
		SpaceObject			mChoosenSpaceObject		= null;

		public boolean eval(final SpaceObject spaceObject)
		{
			float distance = spaceObject.calculateDistance2Ship(mSpaceShip);
			if (distance < GREAT_DISTANCE)
			{
				mHasGreatDistance = false;
			}
			if (distance < CRITICAL_DISTANCE)
			{
				mHasCriticalDistance = true;
			} else
			{
				float weigth = spaceObject.mRating / distance;
				if (weigth > mMaxWeight)
				{
					mMaxWeight = weigth;
					mChoosenSpaceObject = spaceObject;
				}
			}
			return mHasCriticalDistance;
		}
	}

	private DatagramSocket	mDatagramSocket	= null;

	public Player(final DatagramSocket pDatagramSocket)
	{
		mDatagramSocket = pDatagramSocket;
	}

	void run() throws IOException
	{
		final FramePacket framePacket = new FramePacket();
		final KeysPacket keysPacket = new KeysPacket();
		byte prevFrameno = 0;
		int time = 0;

		for (;;)
		{
			++time; // Zeit
			final byte ping = keysPacket.incrementPing(); // jedes gesendete Pckchen
			// erhlt eine individuelle
			// Nummer zur Latenzmessung
			sendPacket(keysPacket);
			receivePacket(framePacket);

			if (framePacket.getFrameno() != ++prevFrameno
					|| framePacket.getPing() != ping)
			{
				Helper.trace(new Object[]
				{"Latenz ", (ping - framePacket.getPing()), " ",
						(framePacket.getFrameno() - prevFrameno), " Frames verloren.\n"});
				prevFrameno = framePacket.getFrameno();
			}
			final GameStatus gameStatus = new VectorProcessor(framePacket).process();

			keysPacket.clear(); // alle Tasten loslassen
			if (gameStatus.isShipPresent())
			{
				final SpaceShip spaceShip = gameStatus.getShip();
				DecisionBean decisionBean = new DecisionBean(spaceShip);
				for (final AsteroidsIterator asteroidsIterator = gameStatus
						.getAsteroidsIterator(); asteroidsIterator.hasNext();)
				{ // lohnendes SpaceObject zum abballern suchen
					if (decisionBean.eval(asteroidsIterator.next()))
						break;
				}
				if (!decisionBean.mHasCriticalDistance && gameStatus.isSaucerPresent())
				{ // eventuell ist ein UFO noch nher dran
					decisionBean.eval(gameStatus.getFlyingSaucer());
				}
				if (decisionBean.mHasCriticalDistance)
				{
					// unausweichlich
					keysPacket.hyperspace(true);
				} else
				{
					if (decisionBean.mHasGreatDistance)
					{
						// nichts in der Nhe
						keysPacket.thrust(true);
					} else
					// Schiff in Richtung auf das nchstgelegene Objekt drehen
					if (decisionBean.mChoosenSpaceObject != null
							&& spaceShip.turnDirection(decisionBean.mChoosenSpaceObject) == -1)
					{
						keysPacket.left(true);
					} else
					{
						keysPacket.right(true);
					}

					// Ballern was das Zeug hlt
					if (time % 2 == 0)
					{
						keysPacket.fire(true);
					}
				}
			}
		}
	}

	void receivePacket(final FramePacket pFramePacket) throws IOException
	{
		final byte[] buffer = pFramePacket.getBuffer();
		final DatagramPacket datagramPacket = new DatagramPacket(buffer, buffer.length);
		mDatagramSocket.receive(datagramPacket);
		pFramePacket.eval();
	}

	void sendPacket(final KeysPacket pKeysPacket) throws IOException
	{
		final byte[] buffer = pKeysPacket.getBuffer();
		final DatagramPacket datagramPacket = new DatagramPacket(buffer, buffer.length);
		mDatagramSocket.send(datagramPacket);
		Helper.trace(new Object[]
		{"Package send: ", pKeysPacket});
	}

	public void close()
	{
		// TODO Auto-generated method stub

	}
}
