/* txRnaAccs.c was originally generated by the autoSql program, which also 
 * generated txRnaAccs.h and txRnaAccs.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "txRnaAccs.h"


struct txRnaAccs *txRnaAccsLoad(char **row)
/* Load a txRnaAccs from row fetched with select * from txRnaAccs
 * from database.  Dispose of this with txRnaAccsFree(). */
{
struct txRnaAccs *ret;

AllocVar(ret);
ret->accCount = sqlSigned(row[2]);
ret->name = cloneString(row[0]);
ret->primary = cloneString(row[1]);
{
int sizeOne;
sqlStringDynamicArray(row[3], &ret->accs, &sizeOne);
assert(sizeOne == ret->accCount);
}
return ret;
}

struct txRnaAccs *txRnaAccsLoadAll(char *fileName) 
/* Load all txRnaAccs from a whitespace-separated file.
 * Dispose of this with txRnaAccsFreeList(). */
{
struct txRnaAccs *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileRow(lf, row))
    {
    el = txRnaAccsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct txRnaAccs *txRnaAccsLoadAllByChar(char *fileName, char chopper) 
/* Load all txRnaAccs from a chopper separated file.
 * Dispose of this with txRnaAccsFreeList(). */
{
struct txRnaAccs *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[4];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = txRnaAccsLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct txRnaAccs *txRnaAccsCommaIn(char **pS, struct txRnaAccs *ret)
/* Create a txRnaAccs out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new txRnaAccs */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->name = sqlStringComma(&s);
ret->primary = sqlStringComma(&s);
ret->accCount = sqlSignedComma(&s);
{
int i;
s = sqlEatChar(s, '{');
AllocArray(ret->accs, ret->accCount);
for (i=0; i<ret->accCount; ++i)
    {
    ret->accs[i] = sqlStringComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
}
*pS = s;
return ret;
}

void txRnaAccsFree(struct txRnaAccs **pEl)
/* Free a single dynamically allocated txRnaAccs such as created
 * with txRnaAccsLoad(). */
{
struct txRnaAccs *el;

if ((el = *pEl) == NULL) return;
freeMem(el->name);
freeMem(el->primary);
/* All strings in accs are allocated at once, so only need to free first. */
if (el->accs != NULL)
    freeMem(el->accs[0]);
freeMem(el->accs);
freez(pEl);
}

void txRnaAccsFreeList(struct txRnaAccs **pList)
/* Free a list of dynamically allocated txRnaAccs's */
{
struct txRnaAccs *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    txRnaAccsFree(&el);
    }
*pList = NULL;
}

void txRnaAccsOutput(struct txRnaAccs *el, FILE *f, char sep, char lastSep) 
/* Print out txRnaAccs.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->primary);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->accCount);
fputc(sep,f);
{
int i;
if (sep == ',') fputc('{',f);
for (i=0; i<el->accCount; ++i)
    {
    if (sep == ',') fputc('"',f);
    fprintf(f, "%s", el->accs[i]);
    if (sep == ',') fputc('"',f);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
}
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

