# trackDb.sql was originally generated by the autoSql program, which also 
# generated trackDb.c and trackDb.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#This describes an annotation track.
CREATE TABLE trackDb (
    tableName varchar(255) not null,	# Symbolic ID of Track
    shortLabel varchar(255) not null,	# Short label displayed on left
    type varchar(255) not null,	# Track type: bed, psl, genePred, etc.
    longLabel varchar(255) not null,	# Long label displayed in middle
    visibility tinyint unsigned not null,	# 0=hide, 1=dense, 2=full, 3=pack
    priority float not null,	# 0-100 - where to position.  0 is top
    colorR tinyint unsigned not null,	# Color red component 0-255
    colorG tinyint unsigned not null,	# Color green component 0-255
    colorB tinyint unsigned not null,	# Color blue component 0-255
    altColorR tinyint unsigned not null,	# Light color red component 0-255
    altColorG tinyint unsigned not null,	# Light color green component 0-255
    altColorB tinyint unsigned not null,	# Light color blue component 0-255
    useScore tinyint unsigned not null,	# 1 if use score, 0 if not
    private tinyint unsigned not null,	# 1 if only want to show it on test site
    restrictCount int not null,	# Number of chromosomes this is on (0=all though!)
    restrictList longblob not null,	# List of chromosomes this is on
    url longblob not null,	# URL to link to when they click on an item
    html longblob not null,	# Some html to display when they click on an item
    grp varchar(255) not null,	# Which group track belongs to
    canPack tinyint unsigned not null,	# 1 if can pack track display, 0 otherwise
    settings longblob not null,	# Name/value pairs for track-specific stuff
              #Indices
    PRIMARY KEY(tableName)
);
