table stsInfo
"Constant STS marker information"
    (
    uint identNo;                 "UCSC identification number"
    string name;                  "Official UCSC name"
    uint gbCount;                 "Number of related GenBank accessions"
    string[gbCount] genbank;      "Related GeneBank accessions"
    uint gdbCount;                "Number of related GDB identifiers"
    string[gdbCount] gdb;         "Related GDB identifies"
    uint nameCount;               "Number of alias names"
    string[nameCount] otherNames; "Alias names"
    uint dbSTSid;                 "ID number in UniSTS or dbSTS"
    uint otherDbstsCount;         "Number of related dbSTS IDs"
    uint[otherDbstsCount] otherDbSTS;  "Related dbSTS IDs"

    string leftPrimer;            "5' primer sequence"
    string rightPrimer;           "3' primer sequence"
    string distance;              "Length of STS sequence"
    string organism;              "Organism for which STS discovered"
    uint sequence;                "Whether the full sequence is available (1) or not (0) for STS"

    uint otherUCSCcount;          "Number of related active UCSC ids"
    uint[otherUCSCcount] otherUCSC;  "Related active UCSC ids"
    uint mergeUCSCcount;          "Number of merged inactive UCSC ids"
    uint[mergeUCSCcount] mergeUCSC;  "Related merged inactive UCSC ids"

    string genethonName;          "Name in Genethon map"
    string genethonChr;           "Chromosome in Genethon map"
    float genethonPos;            "Position in Genethon map"
    float genethonLOD;            "LOD score in Genethon map"
    string marshfieldName;        "Name in Marshfield map"
    string marshfieldChr;         "Chromosome in Marshfield map"
    float marshfieldPos;          "Position in Marshfield map"
    float marshfieldLOD;          "LOD score in Marshfield map"
    string wiyacName;             "Name in WI YAC map"
    string wiyacChr;              "Chromosome in WI YAC map"
    float wiyacPos;               "Position in WI YAC map"
    float wiyacLOD;               "LOD score in WI YAC map"
    string wirhName;              "Name in WI RH map"
    string wirhChr;               "Chromosome in WI RH map"
    float wirhPos;                "Position in WI RH map"
    float wirhLOD;                "LOD score in WI RH map"
    string gm99gb4Name;           "Name in GeneMap99 GB4 map"
    string gm99gb4Chr;            "Chromosome in GeneMap99 GB4 map"
    float gm99gb4Pos;             "Position in GeneMap99 GB4 map"
    float gm99gb4LOD;             "LOD score in GeneMap99 GB4 map"
    string gm99g3Name;            "Name in GeneMap99 G3 map"
    string gm99g3Chr;             "Chromosome in GeneMap99 G3 map"
    float gm99g3Pos;              "Position in GeneMap99 G3 map"
    float gm99g3LOD;              "LOD score in GenMap99 G3 map"
    string tngName;               "Name in Stanford TNG map"
    string tngChr;                "Chromosome in Stanford TNG map"
    float tngPos;                 "Position in Stanford TNG map"
    float tngLOD;                 "LOD score in Stanford TNG map"
    )
