/* dv.c was originally generated by the autoSql program, which also 
 * generated dv.h and dv.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "dv.h"


void dvStaticLoad(char **row, struct dv *ret)
/* Load a row from dv table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->spID = row[0];
ret->start = sqlUnsigned(row[1]);
ret->len = sqlUnsigned(row[2]);
ret->orig = row[3];
ret->variant = row[4];
ret->varId = row[5];
ret->varStatus = row[6];
}

struct dv *dvLoad(char **row)
/* Load a dv from row fetched with select * from dv
 * from database.  Dispose of this with dvFree(). */
{
struct dv *ret;

AllocVar(ret);
ret->spID = cloneString(row[0]);
ret->start = sqlUnsigned(row[1]);
ret->len = sqlUnsigned(row[2]);
ret->orig = cloneString(row[3]);
ret->variant = cloneString(row[4]);
ret->varId = cloneString(row[5]);
ret->varStatus = cloneString(row[6]);
return ret;
}

struct dv *dvLoadAll(char *fileName) 
/* Load all dv from a whitespace-separated file.
 * Dispose of this with dvFreeList(). */
{
struct dv *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileRow(lf, row))
    {
    el = dvLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct dv *dvLoadAllByChar(char *fileName, char chopper) 
/* Load all dv from a chopper separated file.
 * Dispose of this with dvFreeList(). */
{
struct dv *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[7];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = dvLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct dv *dvCommaIn(char **pS, struct dv *ret)
/* Create a dv out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new dv */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->spID = sqlStringComma(&s);
ret->start = sqlUnsignedComma(&s);
ret->len = sqlUnsignedComma(&s);
ret->orig = sqlStringComma(&s);
ret->variant = sqlStringComma(&s);
ret->varId = sqlStringComma(&s);
ret->varStatus = sqlStringComma(&s);
*pS = s;
return ret;
}

void dvFree(struct dv **pEl)
/* Free a single dynamically allocated dv such as created
 * with dvLoad(). */
{
struct dv *el;

if ((el = *pEl) == NULL) return;
freeMem(el->spID);
freeMem(el->orig);
freeMem(el->variant);
freeMem(el->varId);
freeMem(el->varStatus);
freez(pEl);
}

void dvFreeList(struct dv **pList)
/* Free a list of dynamically allocated dv's */
{
struct dv *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    dvFree(&el);
    }
*pList = NULL;
}

void dvOutput(struct dv *el, FILE *f, char sep, char lastSep) 
/* Print out dv.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->spID);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->start);
fputc(sep,f);
fprintf(f, "%u", el->len);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->orig);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->variant);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->varId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->varStatus);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

