/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.sen.ReadingProcessor;
import net.java.sen.StringTagger;
import net.java.sen.dictionary.Dictionary;
import net.java.sen.dictionary.Tokenizer;
import net.java.sen.dictionary.Viterbi;
import net.java.sen.tokenizers.ja.JapaneseTokenizer;
import net.java.sen.util.IOUtils;

public class SenFactory {
    private static final Map<String, SenFactory> map = new ConcurrentHashMap<String, SenFactory>();
    private static final String EMPTY_DICTIONARYDIR_KEY = "NO_DICTIONARY_INSTANCE";
    public static final String unknownPOS = "\u672a\u77e5\u8a9e";
    private final String[] posIndex;
    private final String[] conjTypeIndex;
    private final String[] conjFormIndex;
    private final ByteBuffer costs;
    private final ByteBuffer pos;
    private final ByteBuffer tokens;
    private final ByteBuffer trie;

    public static synchronized SenFactory getInstance(String dictionaryDir) {
        String key = dictionaryDir == null || dictionaryDir.trim().length() == 0 ? EMPTY_DICTIONARYDIR_KEY : dictionaryDir;
        SenFactory instance = map.get(key);
        if (instance == null) {
            try {
                instance = new SenFactory(dictionaryDir);
                map.put(key, instance);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SenFactory(String dictionaryDir) throws IOException {
        InputStream in = null;
        DataInputStream din = null;
        try {
            in = SenFactory.getInputStream("header.sen", dictionaryDir);
            din = new DataInputStream(in);
            this.costs = SenFactory.loadBuffer("connectionCost.sen", din.readInt(), dictionaryDir).asReadOnlyBuffer();
            this.pos = SenFactory.loadBuffer("partOfSpeech.sen", din.readInt(), dictionaryDir).asReadOnlyBuffer();
            this.tokens = SenFactory.loadBuffer("token.sen", din.readInt(), dictionaryDir).asReadOnlyBuffer();
            this.trie = SenFactory.loadBuffer("trie.sen", din.readInt(), dictionaryDir).asReadOnlyBuffer();
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(din, in);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(din, in);
        try {
            int i;
            in = SenFactory.getInputStream("posIndex.sen", dictionaryDir);
            din = new DataInputStream(in);
            this.posIndex = new String[din.readChar()];
            for (i = 0; i < this.posIndex.length; ++i) {
                this.posIndex[i] = din.readUTF();
            }
            this.conjTypeIndex = new String[din.readChar()];
            for (i = 0; i < this.conjTypeIndex.length; ++i) {
                this.conjTypeIndex[i] = din.readUTF();
            }
            this.conjFormIndex = new String[din.readChar()];
            for (i = 0; i < this.conjFormIndex.length; ++i) {
                this.conjFormIndex[i] = din.readUTF();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(din, in);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(din, in);
    }

    private static InputStream getInputStream(String name, String dictionaryDir) throws IOException {
        InputStream in = null;
        in = dictionaryDir == null || dictionaryDir.trim().length() == 0 ? SenFactory.class.getResourceAsStream(name) : new FileInputStream(new File(dictionaryDir, name));
        if (in == null) {
            throw new RuntimeException("Not found resource[" + name + "]. dictionaryDir=[" + dictionaryDir + "]");
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer loadBuffer(String resource, int size, String dictionaryDir) throws IOException {
        ByteBuffer byteBuffer;
        InputStream in = null;
        try {
            int numBytes;
            in = SenFactory.getInputStream(resource, dictionaryDir);
            ByteBuffer buffer = ByteBuffer.allocateDirect(size);
            buffer.limit(size);
            byte[] buf = new byte[1024];
            while ((numBytes = in.read(buf)) != -1) {
                buffer.put(buf, 0, numBytes);
            }
            buffer.rewind();
            byteBuffer = buffer;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(in);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(in);
        return byteBuffer;
    }

    private static Tokenizer getTokenizer(String dictionaryDir, boolean tokenizeUnknownKatakana) {
        SenFactory localInstance = SenFactory.getInstance(dictionaryDir);
        return new JapaneseTokenizer(new Dictionary(localInstance.costs.asShortBuffer(), localInstance.pos.duplicate(), localInstance.tokens.duplicate(), localInstance.trie.asIntBuffer(), localInstance.posIndex, localInstance.conjTypeIndex, localInstance.conjFormIndex), unknownPOS, tokenizeUnknownKatakana);
    }

    static Viterbi getViterbi(String dictionaryDir, boolean tokenizeUnknownKatakana) {
        return new Viterbi(SenFactory.getTokenizer(dictionaryDir, tokenizeUnknownKatakana));
    }

    public static StringTagger getStringTagger(String dictionaryDir, boolean tokenizeUnknownKatakana) {
        return new StringTagger(SenFactory.getTokenizer(dictionaryDir, tokenizeUnknownKatakana));
    }

    static ReadingProcessor getReadingProcessor(String dictionaryDir, boolean tokenizeUnknownKatakana) {
        return new ReadingProcessor(SenFactory.getTokenizer(dictionaryDir, tokenizeUnknownKatakana));
    }
}

